/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.websocket;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketServerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.toClient.MainWindow;
import org.jetbrains.projector.server.core.util.SslKt;
import org.jetbrains.projector.server.core.websocket.HttpWsServer;
import org.jetbrains.projector.server.core.websocket.WsTransportBuilder;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016R&\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/projector/server/core/websocket/HttpWsServerBuilder;", "Lorg/jetbrains/projector/server/core/websocket/WsTransportBuilder;", "host", "Ljava/net/InetAddress;", "port", "", "(Ljava/net/InetAddress;I)V", "getMainWindows", "Lkotlin/Function0;", "", "Lorg/jetbrains/projector/common/protocol/toClient/MainWindow;", "getGetMainWindows", "()Lkotlin/jvm/functions/Function0;", "setGetMainWindows", "(Lkotlin/jvm/functions/Function0;)V", "build", "Lorg/jetbrains/projector/server/core/websocket/HttpWsServer;", "projector-server-core"})
public final class HttpWsServerBuilder
extends WsTransportBuilder {
    @NotNull
    private final InetAddress host;
    private final int port;
    public Function0<? extends List<MainWindow>> getMainWindows;

    public HttpWsServerBuilder(@NotNull InetAddress host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
    }

    @NotNull
    public final Function0<List<MainWindow>> getGetMainWindows() {
        Function0<? extends List<MainWindow>> function0 = this.getMainWindows;
        if (function0 != null) {
            return function0;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"getMainWindows");
        throw null;
    }

    public final void setGetMainWindows(@NotNull Function0<? extends List<MainWindow>> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.getMainWindows = function0;
    }

    @Override
    @NotNull
    public HttpWsServer build() {
        InetAddress inetAddress = this.host;
        int n = this.port;
        HttpWsServer wsServer2 = new HttpWsServer(this, inetAddress, n){
            final /* synthetic */ HttpWsServerBuilder this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            @NotNull
            public List<MainWindow> getMainWindows() {
                return (List)this.this$0.getGetMainWindows().invoke();
            }

            public void onError(@Nullable WebSocket connection, @NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getOnError().invoke((Object)connection, (Object)e);
            }

            public void onWsOpen(@NotNull WebSocket connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                this.this$0.getOnWsOpen().invoke((Object)connection);
            }

            public void onWsClose(@NotNull WebSocket connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                this.this$0.getOnWsClose().invoke((Object)connection);
            }

            public void onWsMessage(@NotNull WebSocket connection, @NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.this$0.getOnWsMessageString().invoke((Object)connection, (Object)message2);
            }

            public void onWsMessage(@NotNull WebSocket connection, @NotNull ByteBuffer message2) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.this$0.getOnWsMessageByteBuffer().invoke((Object)connection, (Object)message2);
            }
        };
        String hint2 = SslKt.setSsl((Function1<? super WebSocketServerFactory, Unit>)((Function1)new Function1<WebSocketServerFactory, Unit>(wsServer2){

            public final void invoke(@NotNull WebSocketServerFactory p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                (this.receiver).setWebSocketFactory(p0);
            }
        }));
        Object message2 = hint2 == null ? "WebSocket SSL is disabled" : "WebSocket SSL is enabled: " + hint2;
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(HttpWsServerBuilder.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        Logger logger = LoggerKt.Logger((String)string);
        Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)((Function0)new Function0<String>((String)message2){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$message;
            }
        }), (int)1, null);
        return wsServer2;
    }
}

