/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.websocket;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.java_websocket.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.server.core.websocket.HttpWsClient;
import org.jetbrains.projector.server.core.websocket.WsTransportBuilder;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/projector/server/core/websocket/HttpWsClientBuilder;", "Lorg/jetbrains/projector/server/core/websocket/WsTransportBuilder;", "relayUrl", "", "serverId", "(Ljava/lang/String;Ljava/lang/String;)V", "build", "Lorg/jetbrains/projector/server/core/websocket/HttpWsClient;", "projector-server-core"})
public final class HttpWsClientBuilder
extends WsTransportBuilder {
    @NotNull
    private final String relayUrl;
    @NotNull
    private final String serverId;

    public HttpWsClientBuilder(@NotNull String relayUrl, @NotNull String serverId) {
        Intrinsics.checkNotNullParameter((Object)relayUrl, (String)"relayUrl");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        this.relayUrl = relayUrl;
        this.serverId = serverId;
    }

    @Override
    @NotNull
    public HttpWsClient build() {
        String string = this.relayUrl;
        String string2 = this.serverId;
        return new HttpWsClient(this, string, string2){
            final /* synthetic */ HttpWsClientBuilder this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void onError(@Nullable WebSocket connection, @NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getOnError().invoke((Object)connection, (Object)e);
            }

            public void onWsOpen(@NotNull WebSocket connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                this.this$0.getOnWsOpen().invoke((Object)connection);
            }

            public void onWsClose(@NotNull WebSocket connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                this.this$0.getOnWsClose().invoke((Object)connection);
            }

            public void onWsMessage(@NotNull WebSocket connection, @NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.this$0.getOnWsMessageString().invoke((Object)connection, (Object)message2);
            }

            public void onWsMessage(@NotNull WebSocket connection, @NotNull ByteBuffer message2) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.this$0.getOnWsMessageByteBuffer().invoke((Object)connection, (Object)message2);
            }
        };
    }
}

