/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.image.PGraphicsDevice;
import org.jetbrains.projector.awt.image.PGraphicsEnvironment;
import org.jetbrains.projector.awt.image.PVolatileImage;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/projector/awt/image/PGraphicsConfiguration;", "Ljava/awt/GraphicsConfiguration;", "device", "Lorg/jetbrains/projector/awt/image/PGraphicsDevice;", "(Lorg/jetbrains/projector/awt/image/PGraphicsDevice;)V", "createCompatibleVolatileImage", "Ljava/awt/image/VolatileImage;", "width", "", "height", "caps", "Ljava/awt/ImageCapabilities;", "transparency", "getBounds", "Ljava/awt/Rectangle;", "getColorModel", "Ljava/awt/image/ColorModel;", "getDefaultTransform", "Ljava/awt/geom/AffineTransform;", "getDevice", "Ljava/awt/GraphicsDevice;", "getNormalizingTransform", "projector-awt"})
public final class PGraphicsConfiguration
extends GraphicsConfiguration {
    @NotNull
    private final PGraphicsDevice device;

    public PGraphicsConfiguration(@NotNull PGraphicsDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.device = device;
    }

    @Override
    @NotNull
    public GraphicsDevice getDevice() {
        return this.device;
    }

    @Override
    @Nullable
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    @Nullable
    public ColorModel getColorModel(int transparency) {
        return this.getColorModel();
    }

    @Override
    @NotNull
    public AffineTransform getDefaultTransform() {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.device.getScaleFactor(), this.device.getScaleFactor());
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getScaleInstance(device.scaleFactor, device.scaleFactor)");
        return affineTransform;
    }

    @Override
    @NotNull
    public AffineTransform getNormalizingTransform() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.projector.awt.image.PGraphicsEnvironment");
        }
        PGraphicsEnvironment ge = (PGraphicsEnvironment)graphicsEnvironment;
        double xScale = ge.getXResolution() / 72.0;
        double yScale = ge.getYResolution() / 72.0;
        return new AffineTransform(xScale, 0.0, 0.0, yScale, 0.0, 0.0);
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return new Rectangle(this.device.getClientScreenBounds());
    }

    @Override
    @NotNull
    public VolatileImage createCompatibleVolatileImage(int width, int height, @Nullable ImageCapabilities caps, int transparency) {
        return new PVolatileImage(width, height, transparency, caps);
    }
}

