/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.client.common.canvas.buffering;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.client.common.canvas.Canvas;
import org.jetbrains.projector.client.common.canvas.CanvasFactory;
import org.jetbrains.projector.client.common.canvas.Context2d;
import org.jetbrains.projector.client.common.canvas.Context2dStateOperations;
import org.jetbrains.projector.client.common.canvas.Extensions;
import org.jetbrains.projector.client.common.canvas.PaintColor;
import org.jetbrains.projector.client.common.canvas.buffering.DoubleBufferedRenderingSurface;
import org.jetbrains.projector.client.common.canvas.buffering.RenderingSurface;
import org.jetbrains.projector.common.protocol.data.PathSegment;
import org.jetbrains.projector.common.protocol.data.Point;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/projector/client/common/canvas/buffering/DoubleBufferedRenderingSurface;", "Lorg/jetbrains/projector/client/common/canvas/buffering/RenderingSurface;", "bufferCanvasFactory", "Lorg/jetbrains/projector/client/common/canvas/CanvasFactory;", "target", "Lorg/jetbrains/projector/client/common/canvas/Canvas;", "(Lorg/jetbrains/projector/client/common/canvas/CanvasFactory;Lorg/jetbrains/projector/client/common/canvas/Canvas;)V", "buffer", "Lorg/jetbrains/projector/client/common/canvas/buffering/DoubleBufferedRenderingSurface$Buffer;", "canvas", "getCanvas", "()Lorg/jetbrains/projector/client/common/canvas/Canvas;", "scalingRatio", "", "getScalingRatio", "()D", "setScalingRatio", "(D)V", "flush", "", "setBounds", "width", "", "height", "Buffer", "projector-client-common"})
public final class DoubleBufferedRenderingSurface
implements RenderingSurface {
    @NotNull
    private final Canvas target;
    private double scalingRatio;
    @NotNull
    private final Buffer buffer;

    public DoubleBufferedRenderingSurface(@NotNull CanvasFactory bufferCanvasFactory, @NotNull Canvas target) {
        Intrinsics.checkNotNullParameter((Object)bufferCanvasFactory, (String)"bufferCanvasFactory");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
        this.scalingRatio = 1.0;
        this.buffer = new Buffer(bufferCanvasFactory, this.target.getWidth(), this.target.getHeight());
    }

    @Override
    public double getScalingRatio() {
        return this.scalingRatio;
    }

    @Override
    public void setScalingRatio(double d) {
        this.scalingRatio = d;
    }

    @Override
    @NotNull
    public Canvas getCanvas() {
        return this.buffer;
    }

    @Override
    public void setBounds(int width, int height) {
        Extensions.INSTANCE.resizeSavingImage(this.buffer, width, height);
        Extensions.INSTANCE.resizeSavingImage(this.target, width, height);
    }

    @Override
    public void flush() {
        if (this.buffer.getWidth() == 0 || this.buffer.getHeight() == 0) {
            return;
        }
        if (this.buffer.getChanged()) {
            this.buffer.resetChanged();
            this.target.getContext2d().drawImage(this.buffer.getImageSource(), 0.0, 0.0);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020 J\b\u0010\"\u001a\u00020#H\u0016J\"\u0010$\u001a\u00020 2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020 0&\u00a2\u0006\u0002\b'H\u0082\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0014\"\u0004\b\u001e\u0010\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/projector/client/common/canvas/buffering/DoubleBufferedRenderingSurface$Buffer;", "Lorg/jetbrains/projector/client/common/canvas/Canvas;", "bufferCanvasFactory", "Lorg/jetbrains/projector/client/common/canvas/CanvasFactory;", "width", "", "height", "(Lorg/jetbrains/projector/client/common/canvas/CanvasFactory;II)V", "<set-?>", "", "changed", "getChanged", "()Z", "context2d", "Lorg/jetbrains/projector/client/common/canvas/Context2d;", "getContext2d", "()Lorg/jetbrains/projector/client/common/canvas/Context2d;", "delegate", "value", "getHeight", "()I", "setHeight", "(I)V", "imageSource", "Lorg/jetbrains/projector/client/common/canvas/Canvas$ImageSource;", "getImageSource", "()Lorg/jetbrains/projector/client/common/canvas/Canvas$ImageSource;", "imageSource$delegate", "Lkotlin/reflect/KProperty0;", "getWidth", "setWidth", "change", "", "resetChanged", "takeSnapshot", "Lorg/jetbrains/projector/client/common/canvas/Canvas$Snapshot;", "withChange", "operation", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "projector-client-common"})
    private static final class Buffer
    implements Canvas {
        @NotNull
        private final Canvas delegate;
        @NotNull
        private final KProperty0 imageSource$delegate;
        private boolean changed;
        @NotNull
        private final Context2d context2d;

        /*
         * WARNING - void declaration
         */
        public Buffer(@NotNull CanvasFactory bufferCanvasFactory, int width, int height) {
            void it;
            Intrinsics.checkNotNullParameter((Object)bufferCanvasFactory, (String)"bufferCanvasFactory");
            Canvas canvas = bufferCanvasFactory.create();
            boolean bl = false;
            boolean bl2 = false;
            Canvas canvas2 = canvas;
            Buffer buffer = this;
            boolean bl3 = false;
            it.setWidth(width);
            it.setHeight(height);
            Unit unit = Unit.INSTANCE;
            buffer.delegate = canvas;
            this.imageSource$delegate = (KProperty0)new PropertyReference0Impl(this.delegate){

                @Nullable
                public Object get() {
                    return ((Canvas)this.receiver).getImageSource();
                }
            };
            this.context2d = (Context2d)new Context2dStateOperations(this){
                private final /* synthetic */ Context2d $$delegate_0;
                final /* synthetic */ Buffer this$0;
                {
                    this.this$0 = $receiver;
                    this.$$delegate_0 = Buffer.access$getDelegate$p(this.this$0).getContext2d();
                }

                public void beginPath() {
                    this.$$delegate_0.beginPath();
                }

                public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
                    this.$$delegate_0.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
                }

                public void clip(@Nullable Context2d.FillRule fillRule) {
                    this.$$delegate_0.clip(fillRule);
                }

                public void closePath() {
                    this.$$delegate_0.closePath();
                }

                @NotNull
                public PaintColor.Gradient createLinearGradient(double x0, double y0, double x1, double y1) {
                    return this.$$delegate_0.createLinearGradient(x0, y0, x1, y1);
                }

                public void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
                    this.$$delegate_0.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
                }

                @NotNull
                public Context2d.Matrix getTransform() {
                    return this.$$delegate_0.getTransform();
                }

                public void lineTo(double x, double y) {
                    this.$$delegate_0.lineTo(x, y);
                }

                @NotNull
                public Point measureText(@NotNull String str) {
                    Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                    return this.$$delegate_0.measureText(str);
                }

                public void moveByPoints(@NotNull List<Point> points) {
                    Intrinsics.checkNotNullParameter(points, (String)"points");
                    this.$$delegate_0.moveByPoints(points);
                }

                public void moveBySegments(@NotNull List<? extends PathSegment> segments) {
                    Intrinsics.checkNotNullParameter(segments, (String)"segments");
                    this.$$delegate_0.moveBySegments(segments);
                }

                public void moveTo(double x, double y) {
                    this.$$delegate_0.moveTo(x, y);
                }

                public void quadraticCurveTo(double cpx, double cpy, double x, double y) {
                    this.$$delegate_0.quadraticCurveTo(cpx, cpy, x, y);
                }

                public void rect(double x, double y, double w, double h) {
                    this.$$delegate_0.rect(x, y, w, h);
                }

                public void restore() {
                    this.$$delegate_0.restore();
                }

                public void rotate(double angle) {
                    this.$$delegate_0.rotate(angle);
                }

                public void roundedRect(double x, double y, double w, double h, double r1, double r2) {
                    this.$$delegate_0.roundedRect(x, y, w, h, r1, r2);
                }

                public void save() {
                    this.$$delegate_0.save();
                }

                public void scale(double x, double y) {
                    this.$$delegate_0.scale(x, y);
                }

                public void setFillStyle(@Nullable PaintColor color) {
                    this.$$delegate_0.setFillStyle(color);
                }

                public void setFont(@NotNull String f) {
                    Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                    this.$$delegate_0.setFont(f);
                }

                public void setGlobalAlpha(double alpha) {
                    this.$$delegate_0.setGlobalAlpha(alpha);
                }

                public void setGlobalCompositeOperation(@NotNull Context2d.CompositeOperationType type) {
                    Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                    this.$$delegate_0.setGlobalCompositeOperation(type);
                }

                public void setLineCap(@NotNull Context2d.LineCap lineCap) {
                    Intrinsics.checkNotNullParameter((Object)((Object)lineCap), (String)"lineCap");
                    this.$$delegate_0.setLineCap(lineCap);
                }

                public void setLineDash(@NotNull double[] lineDash) {
                    Intrinsics.checkNotNullParameter((Object)lineDash, (String)"lineDash");
                    this.$$delegate_0.setLineDash(lineDash);
                }

                public void setLineDashOffset(double offset) {
                    this.$$delegate_0.setLineDashOffset(offset);
                }

                public void setLineJoin(@NotNull Context2d.LineJoin lineJoin) {
                    Intrinsics.checkNotNullParameter((Object)((Object)lineJoin), (String)"lineJoin");
                    this.$$delegate_0.setLineJoin(lineJoin);
                }

                public void setLineWidth(double lineWidth) {
                    this.$$delegate_0.setLineWidth(lineWidth);
                }

                public void setMiterLimit(double limit) {
                    this.$$delegate_0.setMiterLimit(limit);
                }

                public void setStrokeStyle(@Nullable PaintColor color) {
                    this.$$delegate_0.setStrokeStyle(color);
                }

                public void setTextAlign(@NotNull Context2d.TextAlign align) {
                    Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
                    this.$$delegate_0.setTextAlign(align);
                }

                public void setTextBaseline(@NotNull Context2d.TextBaseline baseline) {
                    Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
                    this.$$delegate_0.setTextBaseline(baseline);
                }

                public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
                    this.$$delegate_0.setTransform(m11, m12, m21, m22, dx, dy);
                }

                public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
                    this.$$delegate_0.transform(m11, m12, m21, m22, dx, dy);
                }

                public void translate(double x, double y) {
                    this.$$delegate_0.translate(x, y);
                }

                private final void withChange2d(Function1<? super Context2d, Unit> operation) {
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this.this$0);
                    operation.invoke((Object)Buffer.access$getDelegate$p(this.this$0).getContext2d());
                }

                public void clearRect(double x, double y, double w, double h) {
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$clearRect_u24lambda_u2d0 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$clearRect_u24lambda_u2d0.clearRect(x, y, w, h);
                }

                public void drawImage(@NotNull Canvas.ImageSource imageSource2, double x, double y) {
                    Intrinsics.checkNotNullParameter((Object)imageSource2, (String)"imageSource");
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$drawImage_u24lambda_u2d1 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$drawImage_u24lambda_u2d1.drawImage(imageSource2, x, y);
                }

                public void drawImage(@NotNull Canvas.ImageSource imageSource2, double x, double y, double dw, double dh) {
                    Intrinsics.checkNotNullParameter((Object)imageSource2, (String)"imageSource");
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$drawImage_u24lambda_u2d2 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$drawImage_u24lambda_u2d2.drawImage(imageSource2, x, y, dw, dh);
                }

                public void drawImage(@NotNull Canvas.ImageSource imageSource2, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
                    Intrinsics.checkNotNullParameter((Object)imageSource2, (String)"imageSource");
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$drawImage_u24lambda_u2d3 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$drawImage_u24lambda_u2d3.drawImage(imageSource2, sx, sy, sw, sh, dx, dy, dw, dh);
                }

                public void stroke() {
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$stroke_u24lambda_u2d4 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$stroke_u24lambda_u2d4.stroke();
                }

                public void fill(@NotNull Context2d.FillRule fillRule) {
                    Intrinsics.checkNotNullParameter((Object)((Object)fillRule), (String)"fillRule");
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$fill_u24lambda_u2d5 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$fill_u24lambda_u2d5.fill(fillRule);
                }

                public void fillRect(double x, double y, double w, double h) {
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$fillRect_u24lambda_u2d6 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$fillRect_u24lambda_u2d6.fillRect(x, y, w, h);
                }

                public void strokeRect(double x, double y, double w, double h) {
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$strokeRect_u24lambda_u2d7 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$strokeRect_u24lambda_u2d7.strokeRect(x, y, w, h);
                }

                public void strokeText(@NotNull String text, double x, double y) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$strokeText_u24lambda_u2d8 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$strokeText_u24lambda_u2d8.strokeText(text, x, y);
                }

                public void fillText(@NotNull String text, double x, double y) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    context2d.1 this_$iv = this;
                    boolean $i$f$withChange2d = false;
                    Buffer.access$change(this_$iv.this$0);
                    Context2d $this$fillText_u24lambda_u2d9 = Buffer.access$getDelegate$p(this_$iv.this$0).getContext2d();
                    boolean bl = false;
                    $this$fillText_u24lambda_u2d9.fillText(text, x, y);
                }
            };
        }

        @Override
        @NotNull
        public Canvas.ImageSource getImageSource() {
            KProperty0 kProperty0 = this.imageSource$delegate;
            boolean bl = false;
            return (Canvas.ImageSource)kProperty0.get();
        }

        @Override
        @NotNull
        public Canvas.Snapshot takeSnapshot() {
            return this.delegate.takeSnapshot();
        }

        public final boolean getChanged() {
            return this.changed;
        }

        public final void resetChanged() {
            this.changed = false;
        }

        private final void change() {
            this.changed = true;
        }

        private final void withChange(Function1<? super Canvas, Unit> operation) {
            boolean $i$f$withChange = false;
            this.change();
            operation.invoke((Object)this.delegate);
        }

        @Override
        public int getWidth() {
            return this.delegate.getWidth();
        }

        @Override
        public void setWidth(int value) {
            Buffer this_$iv = this;
            boolean $i$f$withChange = false;
            this_$iv.change();
            Canvas $this$_set_width__u24lambda_u2d1 = this_$iv.delegate;
            boolean bl = false;
            $this$_set_width__u24lambda_u2d1.setWidth(value);
        }

        @Override
        public int getHeight() {
            return this.delegate.getHeight();
        }

        @Override
        public void setHeight(int value) {
            Buffer this_$iv = this;
            boolean $i$f$withChange = false;
            this_$iv.change();
            Canvas $this$_set_height__u24lambda_u2d2 = this_$iv.delegate;
            boolean bl = false;
            $this$_set_height__u24lambda_u2d2.setHeight(value);
        }

        @Override
        @NotNull
        public Context2d getContext2d() {
            return this.context2d;
        }

        @Override
        @NotNull
        public String getFontVariantLigatures() {
            return Canvas.DefaultImpls.getFontVariantLigatures(this);
        }

        @Override
        public void setFontVariantLigatures(@NotNull String value) {
            Canvas.DefaultImpls.setFontVariantLigatures(this, value);
        }
    }
}

