/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.table;

import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.datavis.r.inlays.dataframe.DataFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\bJ\b\u0010\u0017\u001a\u00020\bH\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/intellij/datavis/r/inlays/table/PagingTableModel;", "Ljavax/swing/table/AbstractTableModel;", "dataFrame", "Lorg/intellij/datavis/r/inlays/dataframe/DataFrame;", "(Lorg/intellij/datavis/r/inlays/dataframe/DataFrame;)V", "getDataFrame", "()Lorg/intellij/datavis/r/inlays/dataframe/DataFrame;", "value", "", "pageOffset", "getPageOffset", "()I", "setPageOffset", "(I)V", "pageSize", "getPageSize", "setPageSize", "getColumnCount", "getColumnName", "", "columnIndex", "getPageCount", "getRealRowCount", "getRowCount", "getValueAt", "", "rowIndex", "intellij.notebooks.visualization"})
public final class PagingTableModel
extends AbstractTableModel {
    private int pageSize;
    private int pageOffset;
    @NotNull
    private final DataFrame dataFrame;

    public final int getPageSize() {
        return this.pageSize;
    }

    public final void setPageSize(int value) {
        if (value == this.pageSize) {
            return;
        }
        int oldPageSize = this.pageSize;
        this.pageSize = value;
        this.setPageOffset(oldPageSize * this.pageOffset / this.pageSize);
        this.fireTableDataChanged();
    }

    public final int getPageOffset() {
        return this.pageOffset;
    }

    public final void setPageOffset(int value) {
        this.pageOffset = value < 0 ? 0 : (value >= this.getPageCount() ? this.getPageCount() - 1 : value);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        int n = this.dataFrame.getDim().height - this.pageOffset * this.pageSize;
        int n2 = this.pageSize;
        boolean bl = false;
        return Math.min(n, n2);
    }

    @Override
    public int getColumnCount() {
        return this.dataFrame.getDim().width;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        int realRow = rowIndex + this.pageOffset * this.pageSize;
        return this.dataFrame.get(columnIndex).toList().get(realRow);
    }

    @Override
    @NotNull
    public String getColumnName(int columnIndex) {
        return this.dataFrame.get(columnIndex).getName();
    }

    public final int getPageCount() {
        double d = (double)this.dataFrame.getDim().height / (double)this.pageSize;
        boolean bl = false;
        return (int)Math.ceil(d);
    }

    public final int getRealRowCount() {
        return this.dataFrame.getDim().height;
    }

    @NotNull
    public final DataFrame getDataFrame() {
        return this.dataFrame;
    }

    public PagingTableModel(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        this.dataFrame = dataFrame;
        this.pageSize = 10;
    }
}

