/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.composite.IncludedRootBuild;
import org.gradle.plugins.ide.internal.tooling.model.BasicGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleBuild;
import org.gradle.plugins.ide.internal.tooling.model.PartialBasicGradleProject;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class GradleBuildBuilder
implements ToolingModelBuilder {
    @Override
    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.gradle.GradleBuild");
    }

    @Override
    public DefaultGradleBuild buildAll(String modelName, Project target) {
        Gradle gradle = target.getGradle();
        return this.convert(gradle, null, new LinkedHashMap<Gradle, DefaultGradleBuild>());
    }

    private DefaultGradleBuild convert(Gradle gradle, DefaultGradleBuild rootBuild, Map<Gradle, DefaultGradleBuild> all) {
        DefaultGradleBuild model = new DefaultGradleBuild();
        LinkedHashMap<Project, BasicGradleProject> convertedProjects = new LinkedHashMap<Project, BasicGradleProject>();
        if (rootBuild == null) {
            rootBuild = model;
        }
        Project rootProject = gradle.getRootProject();
        BasicGradleProject convertedRootProject = this.convert(rootProject, convertedProjects);
        model.setRootProject(convertedRootProject);
        for (Project project : rootProject.getAllprojects()) {
            model.addProject((PartialBasicGradleProject)convertedProjects.get(project));
        }
        if (gradle.getParent() != null) {
            all.put(gradle, model);
        }
        for (IncludedBuild includedBuild : gradle.getIncludedBuilds()) {
            if (includedBuild instanceof IncludedBuildState) {
                GradleInternal includedGradle = ((IncludedBuildState)((Object)includedBuild)).getConfiguredBuild();
                DefaultGradleBuild convertedIncludedBuild = all.get(includedGradle);
                if (convertedIncludedBuild == null) {
                    convertedIncludedBuild = this.convert(includedGradle, rootBuild, all);
                }
                model.addIncludedBuild(convertedIncludedBuild);
                continue;
            }
            if (includedBuild instanceof IncludedRootBuild) {
                model.addIncludedBuild(rootBuild);
                continue;
            }
            throw new IllegalStateException("Unknown build type: " + includedBuild.getClass().getName());
        }
        if (gradle.getParent() == null) {
            model.addBuilds(all.values());
        }
        return model;
    }

    private BasicGradleProject convert(Project project, Map<Project, BasicGradleProject> convertedProjects) {
        DefaultProjectIdentifier id = new DefaultProjectIdentifier(project.getRootDir(), project.getPath());
        BasicGradleProject converted = new BasicGradleProject().setName(project.getName()).setProjectIdentifier(id);
        converted.setProjectDirectory(project.getProjectDir());
        if (project.getParent() != null) {
            converted.setParent(convertedProjects.get(project.getParent()));
        }
        convertedProjects.put(project, converted);
        for (Project child : project.getChildProjects().values()) {
            converted.addChild(this.convert(child, convertedProjects));
        }
        return converted;
    }
}

