/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.internal.precompiled;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.resource.TextFileResourceLoader;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.internal.precompiled.CompileGroovyScriptPluginsTask;
import org.gradle.plugin.devel.internal.precompiled.ExtractPluginRequestsTask;
import org.gradle.plugin.devel.internal.precompiled.GeneratePluginAdaptersTask;
import org.gradle.plugin.devel.internal.precompiled.PrecompiledGroovyScript;
import org.gradle.plugin.devel.plugins.JavaGradlePluginPlugin;

public abstract class PrecompiledGroovyPluginsPlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(GroovyBasePlugin.class);
        project.getPluginManager().apply(JavaGradlePluginPlugin.class);
        project.afterEvaluate(this::exposeScriptsAsPlugins);
    }

    @Inject
    protected abstract TextFileResourceLoader getTextFileResourceLoader();

    private void exposeScriptsAsPlugins(Project project) {
        GradlePluginDevelopmentExtension pluginExtension = project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
        SourceSet pluginSourceSet = pluginExtension.getPluginSourceSet();
        FileTree scriptPluginFiles = pluginSourceSet.getAllSource().matching(PrecompiledGroovyScript::filterPluginFiles);
        List<PrecompiledGroovyScript> scriptPlugins = scriptPluginFiles.getFiles().stream().map(file -> new PrecompiledGroovyScript((File)file, this.getTextFileResourceLoader())).collect(Collectors.toList());
        this.declarePluginMetadata(pluginExtension, scriptPlugins);
        DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
        TaskContainer tasks = project.getTasks();
        NamedDomainObjectProvider extractPluginRequests = tasks.register("extractPluginRequests", ExtractPluginRequestsTask.class, task -> {
            task.getScriptPlugins().convention(scriptPlugins);
            task.getScriptFiles().from(scriptPluginFiles.getFiles());
            task.getExtractedPluginRequestsClassesDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/plugin-requests"));
            task.getExtractedPluginRequestsClassesStagingDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/plugin-requests-staging"));
        });
        NamedDomainObjectProvider generatePluginAdapters = tasks.register("generatePluginAdapters", GeneratePluginAdaptersTask.class, arg_0 -> PrecompiledGroovyPluginsPlugin.lambda$exposeScriptsAsPlugins$2(scriptPlugins, (TaskProvider)extractPluginRequests, buildDir, arg_0));
        NamedDomainObjectProvider precompilePlugins = tasks.register("compileGroovyPlugins", CompileGroovyScriptPluginsTask.class, task -> {
            task.getScriptPlugins().convention(scriptPlugins);
            task.getScriptFiles().from(scriptPluginFiles.getFiles());
            task.getPrecompiledGroovyScriptsOutputDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/plugin-classes"));
            SourceDirectorySet javaSource = pluginSourceSet.getJava();
            SourceDirectorySet groovySource = pluginSourceSet.getExtensions().getByType(GroovySourceDirectorySet.class);
            task.getClasspath().from(pluginSourceSet.getCompileClasspath(), javaSource.getClassesDirectory(), groovySource.getClassesDirectory());
        });
        pluginSourceSet.getJava().srcDir(generatePluginAdapters.flatMap(GeneratePluginAdaptersTask::getPluginAdapterSourcesOutputDirectory));
        pluginSourceSet.getOutput().dir(precompilePlugins.flatMap(CompileGroovyScriptPluginsTask::getPrecompiledGroovyScriptsOutputDirectory));
        pluginSourceSet.getOutput().dir(extractPluginRequests.flatMap(ExtractPluginRequestsTask::getExtractedPluginRequestsClassesStagingDirectory));
    }

    private void declarePluginMetadata(GradlePluginDevelopmentExtension pluginExtension, List<PrecompiledGroovyScript> scriptPlugins) {
        pluginExtension.plugins(pluginDeclarations -> scriptPlugins.forEach(scriptPlugin -> pluginDeclarations.create(scriptPlugin.getId(), scriptPlugin::declarePlugin)));
    }

    private static /* synthetic */ void lambda$exposeScriptsAsPlugins$2(List scriptPlugins, TaskProvider extractPluginRequests, DirectoryProperty buildDir, GeneratePluginAdaptersTask task) {
        task.getScriptPlugins().convention((Iterable)scriptPlugins);
        task.getExtractedPluginRequestsClassesDirectory().convention(extractPluginRequests.flatMap(ExtractPluginRequestsTask::getExtractedPluginRequestsClassesDirectory));
        task.getPluginAdapterSourcesOutputDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/adapter-src"));
    }
}

