/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp.version;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.gson.stream.JsonReader;
import org.gradle.internal.io.NullOutputStream;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.AbstractVisualStudioVersionLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualCppInstallCandidate;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualCppMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioInstallCandidate;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetadataBuilder;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioVersionLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VswhereVersionLocator;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.internal.VersionNumber;

public class CommandLineToolVersionLocator
extends AbstractVisualStudioVersionLocator
implements VisualStudioVersionLocator {
    private static final Logger LOGGER = Logging.getLogger(CommandLineToolVersionLocator.class);
    private final ExecActionFactory execActionFactory;
    private final VisualCppMetadataProvider visualCppMetadataProvider;
    private final VswhereVersionLocator vswhereLocator;
    private static final String INSTALLATION_PATH_KEY = "installationPath";
    private static final String INSTALLATION_VERSION_KEY = "installationVersion";

    public CommandLineToolVersionLocator(ExecActionFactory execActionFactory, VisualCppMetadataProvider visualCppMetadataProvider, VswhereVersionLocator vswhereLocator) {
        this.execActionFactory = execActionFactory;
        this.visualCppMetadataProvider = visualCppMetadataProvider;
        this.vswhereLocator = vswhereLocator;
    }

    @Override
    protected List<VisualStudioInstallCandidate> locateInstalls() {
        ArrayList installs = Lists.newArrayList();
        File vswhereBinary = this.vswhereLocator.getVswhereInstall();
        if (vswhereBinary != null) {
            ArrayList args = Lists.newArrayList((Object[])new String[]{"-all", "-legacy", "-format", "json", "-utf8"});
            String json = this.getVswhereOutput(vswhereBinary, args);
            installs.addAll(this.parseJson(json));
        }
        return installs;
    }

    @Override
    public String getSource() {
        return "command line tool";
    }

    private String getVswhereOutput(File vswhereBinary, List<String> args) {
        ExecAction exec = this.execActionFactory.newExecAction();
        exec.args(args);
        exec.executable(vswhereBinary.getAbsolutePath());
        exec.setWorkingDir(vswhereBinary.getParentFile());
        StreamByteBuffer buffer = new StreamByteBuffer();
        exec.setStandardOutput(buffer.getOutputStream());
        exec.setErrorOutput(NullOutputStream.INSTANCE);
        exec.setIgnoreExitValue(true);
        ExecResult result = exec.execute();
        int exitValue = result.getExitValue();
        if (exitValue == 0) {
            return buffer.readAsString("UTF-8");
        }
        LOGGER.debug("vswhere.exe returned a non-zero exit value ({}) - ignoring", result.getExitValue());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VisualStudioInstallCandidate> parseJson(String json) {
        ArrayList installs = Lists.newArrayList();
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        try {
            try {
                reader.beginArray();
                while (reader.hasNext()) {
                    VisualStudioInstallCandidate candidate = this.readInstall(reader);
                    if (candidate == null) continue;
                    installs.add(candidate);
                }
                reader.endArray();
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        return installs;
    }

    private VisualStudioInstallCandidate readInstall(JsonReader reader) throws IOException {
        String visualStudioInstallPath = null;
        String visualStudioVersion = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            if (key.equals(INSTALLATION_PATH_KEY)) {
                visualStudioInstallPath = reader.nextString();
                continue;
            }
            if (key.equals(INSTALLATION_VERSION_KEY)) {
                visualStudioVersion = reader.nextString();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        File visualStudioInstallDir = new File(visualStudioInstallPath);
        VisualCppInstallCandidate visualCppMetadata = this.findVisualCppMetadata(visualStudioInstallDir, visualStudioVersion);
        if (visualCppMetadata == null) {
            LOGGER.debug("Ignoring candidate Visual Studio version " + visualStudioVersion + " at " + visualStudioInstallPath + " because it does not appear to be a valid installation");
            return null;
        }
        return new VisualStudioMetadataBuilder().installDir(visualStudioInstallDir).visualCppDir(visualCppMetadata.getVisualCppDir()).version(VersionNumber.parse(visualStudioVersion)).visualCppVersion(visualCppMetadata.getVersion()).build();
    }

    private VisualCppInstallCandidate findVisualCppMetadata(File installDir, String version) {
        if (VersionNumber.parse(version).getMajor() >= 15) {
            return this.visualCppMetadataProvider.getVisualCppFromMetadataFile(installDir);
        }
        return this.visualCppMetadataProvider.getVisualCppFromRegistry(version);
    }
}

