/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionResult;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.impl.OutputSnapshotUtil;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.CurrentSnapshotResult;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class CaptureStateAfterExecutionStep<C extends BeforeExecutionContext>
extends BuildOperationStep<C, CurrentSnapshotResult> {
    private final UniqueId buildInvocationScopeId;
    private final OutputSnapshotter outputSnapshotter;
    private final Step<? super C, ? extends Result> delegate;

    public CaptureStateAfterExecutionStep(BuildOperationExecutor buildOperationExecutor, UniqueId buildInvocationScopeId, OutputSnapshotter outputSnapshotter, Step<? super C, ? extends Result> delegate) {
        super(buildOperationExecutor);
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.outputSnapshotter = outputSnapshotter;
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(UnitOfWork work, C context) {
        final Result result = this.delegate.execute(work, context);
        final ImmutableSortedMap outputFilesProduceByWork = this.operation(operationContext -> {
            ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots = this.captureOutputs(work, (BeforeExecutionContext)context);
            operationContext.setResult(Operation.Result.INSTANCE);
            return outputSnapshots;
        }, BuildOperationDescriptor.displayName("Snapshot outputs after executing " + work.getDisplayName()).details(Operation.Details.INSTANCE));
        final OriginMetadata originMetadata = new OriginMetadata(this.buildInvocationScopeId.asString(), work.markExecutionTime());
        return new CurrentSnapshotResult(){

            @Override
            public ImmutableSortedMap<String, FileSystemSnapshot> getOutputFilesProduceByWork() {
                return outputFilesProduceByWork;
            }

            @Override
            public OriginMetadata getOriginMetadata() {
                return originMetadata;
            }

            @Override
            public Try<ExecutionResult> getExecutionResult() {
                return result.getExecutionResult();
            }

            @Override
            public boolean isReused() {
                return false;
            }
        };
    }

    private ImmutableSortedMap<String, FileSystemSnapshot> captureOutputs(UnitOfWork work, BeforeExecutionContext context) {
        boolean hasDetectedOverlappingOutputs = context.getBeforeExecutionState().flatMap(BeforeExecutionState::getDetectedOverlappingOutputs).isPresent();
        ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshotsAfterExecution = this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
        if (hasDetectedOverlappingOutputs) {
            ImmutableSortedMap previousExecutionOutputSnapshots = context.getAfterPreviousExecutionState().map(AfterPreviousExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
            ImmutableSortedMap unfilteredOutputSnapshotsBeforeExecution = context.getBeforeExecutionState().map(BeforeExecutionState::getOutputFileLocationSnapshots).orElse(ImmutableSortedMap.of());
            return OutputSnapshotUtil.filterOutputsAfterExecution((ImmutableSortedMap<String, FileSystemSnapshot>)previousExecutionOutputSnapshots, (ImmutableSortedMap<String, FileSystemSnapshot>)unfilteredOutputSnapshotsBeforeExecution, unfilteredOutputSnapshotsAfterExecution);
        }
        return unfilteredOutputSnapshotsAfterExecution;
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

