/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.fingerprint.impl;

import java.util.Objects;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.execution.fingerprint.DirectorySensitiveNormalizer;
import org.gradle.internal.execution.fingerprint.FileNormalizationSpec;
import org.gradle.internal.fingerprint.DirectorySensitivity;

public class DefaultFileNormalizationSpec
implements FileNormalizationSpec {
    private final Class<? extends FileNormalizer> normalizer;
    private final DirectorySensitivity directorySensitivity;

    private DefaultFileNormalizationSpec(Class<? extends FileNormalizer> normalizer, DirectorySensitivity directorySensitivity) {
        this.normalizer = normalizer;
        this.directorySensitivity = directorySensitivity;
    }

    @Override
    public Class<? extends FileNormalizer> getNormalizer() {
        return this.normalizer;
    }

    @Override
    public DirectorySensitivity getDirectorySensitivity() {
        return this.directorySensitivity;
    }

    public static FileNormalizationSpec from(Class<? extends FileNormalizer> normalizer, DirectorySensitivity directorySensitivity) {
        if (DirectorySensitiveNormalizer.class.isAssignableFrom(normalizer)) {
            return new DefaultFileNormalizationSpec(normalizer, directorySensitivity);
        }
        return new DefaultFileNormalizationSpec(normalizer, DirectorySensitivity.DEFAULT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileNormalizationSpec that = (DefaultFileNormalizationSpec)o;
        return this.normalizer.equals(that.normalizer) && this.directorySensitivity == that.directorySensitivity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.normalizer, this.directorySensitivity});
    }
}

