/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.internal.InternalBuildFinishedListener;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.DefaultBuildLifecycleController;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.scopes.BuildScopeListenerManagerAction;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.invocation.DefaultGradle;

public class DefaultBuildLifecycleControllerFactory
implements BuildLifecycleControllerFactory {
    @Override
    public BuildLifecycleController newInstance(BuildDefinition buildDefinition, BuildState owner, @Nullable GradleInternal parentModel, BuildScopeServices buildScopeServices) {
        File customBuildFile;
        StartParameterInternal startParameter = buildDefinition.getStartParameter();
        buildScopeServices.add(BuildDefinition.class, buildDefinition);
        buildScopeServices.add(BuildState.class, owner);
        buildScopeServices.addProvider(new GradleModelProvider(parentModel, startParameter));
        ListenerManager listenerManager = buildScopeServices.get(ListenerManager.class);
        for (Action action : buildScopeServices.getAll(BuildScopeListenerManagerAction.class)) {
            action.execute(listenerManager);
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener(usageLocationReporter);
        ShowStacktrace showStacktrace = startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(false);
            }
        }
        DeprecationLogger.init(usageLocationReporter, startParameter.getWarningMode(), buildScopeServices.get(BuildOperationProgressEventEmitter.class));
        File customSettingsFile = startParameter.getSettingsFile();
        if (customSettingsFile != null) {
            DeprecationLogger.deprecateAction("Specifying custom settings file location").willBeRemovedInGradle8().withUpgradeGuideSection(7, "configuring_custom_build_layout").nagUser();
        }
        if ((customBuildFile = startParameter.getBuildFile()) != null) {
            DeprecationLogger.deprecateAction("Specifying custom build file location").willBeRemovedInGradle8().withUpgradeGuideSection(7, "configuring_custom_build_layout").nagUser();
        }
        GradleInternal gradle = buildScopeServices.get(GradleInternal.class);
        BuildModelController buildModelController = buildScopeServices.get(BuildModelController.class);
        return new DefaultBuildLifecycleController(gradle, buildModelController, buildScopeServices.get(ExceptionAnalyser.class), gradle.getBuildListenerBroadcaster(), listenerManager.getBroadcaster(BuildCompletionListener.class), listenerManager.getBroadcaster(InternalBuildFinishedListener.class), gradle.getServices().get(BuildWorkExecutor.class), buildScopeServices);
    }

    private static class GradleModelProvider {
        @Nullable
        private final GradleInternal parentModel;
        private final StartParameter startParameter;

        private GradleModelProvider(@Nullable GradleInternal parentModel, StartParameter startParameter) {
            this.parentModel = parentModel;
            this.startParameter = startParameter;
        }

        GradleInternal createGradleModel(Instantiator instantiator, ServiceRegistryFactory serviceRegistryFactory) {
            return instantiator.newInstance(DefaultGradle.class, this.parentModel, this.startParameter, serviceRegistryFactory);
        }
    }
}

