/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import org.gradle.api.Describable;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class Describables {
    private Describables() {
    }

    public static DisplayName of(Object displayName) {
        if (displayName instanceof DisplayName) {
            return (DisplayName)displayName;
        }
        return new FixedDescribable(displayName);
    }

    public static DisplayName of(Object part1, Object part2) {
        return new TwoPartDescribable(part1, part2);
    }

    public static DisplayName of(Object part1, Object part2, Object part3) {
        return new ThreePartDescribable(part1, part2, part3);
    }

    public static DisplayName quoted(final Object description, final Object value) {
        return new AbstractDescribable(){

            @Override
            public String getCapitalizedDisplayName() {
                StringBuilder builder = new StringBuilder(64);
                Describables.appendCapDisplayName(description, builder);
                builder.append(" '");
                Describables.appendDisplayName(value, builder);
                builder.append('\'');
                return builder.toString();
            }

            @Override
            public String getDisplayName() {
                StringBuilder builder = new StringBuilder(64);
                Describables.appendDisplayName(description, builder);
                builder.append(" '");
                Describables.appendDisplayName(value, builder);
                builder.append('\'');
                return builder.toString();
            }
        };
    }

    public static DisplayName withTypeAndName(final Object type, final String name) {
        return new AbstractDescribable(){

            @Override
            public String getCapitalizedDisplayName() {
                StringBuilder result = this.asMutable();
                result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
                return result.toString();
            }

            @Override
            public String getDisplayName() {
                return this.asMutable().toString();
            }

            private StringBuilder asMutable() {
                String typeStr = type.toString();
                StringBuilder result = new StringBuilder(typeStr.length() + name.length() + 3);
                result.append(typeStr);
                result.append(" '");
                result.append(name);
                result.append('\'');
                return result;
            }
        };
    }

    public static DisplayName memoize(Describable describable) {
        return new MemoizingDescribable(describable);
    }

    private static void appendDisplayName(Object src, StringBuilder stringBuilder) {
        if (src instanceof Describable) {
            Describable describable = (Describable)src;
            stringBuilder.append(describable.getDisplayName());
        } else {
            stringBuilder.append(src.toString());
        }
    }

    private static void appendCapDisplayName(Object src, StringBuilder stringBuilder) {
        if (src instanceof DisplayName) {
            DisplayName displayName = (DisplayName)src;
            stringBuilder.append(displayName.getCapitalizedDisplayName());
        } else {
            int pos = stringBuilder.length();
            if (src instanceof Describable) {
                Describable describable = (Describable)src;
                stringBuilder.append(describable.getDisplayName());
            } else {
                stringBuilder.append(src.toString());
            }
            stringBuilder.setCharAt(pos, Character.toUpperCase(stringBuilder.charAt(pos)));
        }
    }

    private static class MemoizingDescribable
    extends AbstractDescribable {
        private Describable describable;
        private String displayName;
        private String capDisplayName;

        MemoizingDescribable(Describable describable) {
            this.describable = describable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getCapitalizedDisplayName() {
            MemoizingDescribable memoizingDescribable = this;
            synchronized (memoizingDescribable) {
                if (this.capDisplayName == null) {
                    String string2 = this.capDisplayName = this.describable instanceof DisplayName ? ((DisplayName)this.describable).getCapitalizedDisplayName() : StringUtils.capitalize((String)this.getDisplayName());
                    if (this.displayName != null) {
                        this.describable = null;
                    }
                }
                return this.capDisplayName;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDisplayName() {
            MemoizingDescribable memoizingDescribable = this;
            synchronized (memoizingDescribable) {
                if (this.displayName == null) {
                    this.displayName = this.describable.getDisplayName();
                    if (this.capDisplayName != null || !(this.describable instanceof DisplayName)) {
                        this.describable = null;
                    }
                }
                return this.displayName;
            }
        }
    }

    private static class ThreePartDescribable
    extends AbstractDescribable {
        private final Object part1;
        private final Object part2;
        private final Object part3;

        ThreePartDescribable(Object part1, Object part2, Object part3) {
            this.part1 = part1;
            this.part2 = part2;
            this.part3 = part3;
        }

        @Override
        public String getDisplayName() {
            StringBuilder builder = new StringBuilder(64);
            Describables.appendDisplayName(this.part1, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part2, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part3, builder);
            return builder.toString();
        }

        @Override
        public String getCapitalizedDisplayName() {
            StringBuilder builder = new StringBuilder(64);
            Describables.appendCapDisplayName(this.part1, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part2, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part3, builder);
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThreePartDescribable that = (ThreePartDescribable)o;
            return Objects.equal((Object)this.part1, (Object)that.part1) && Objects.equal((Object)this.part2, (Object)that.part2) && Objects.equal((Object)this.part3, (Object)that.part3);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.part1, this.part2, this.part3});
        }
    }

    private static class TwoPartDescribable
    extends AbstractDescribable {
        private final Object part1;
        private final Object part2;

        TwoPartDescribable(Object part1, Object part2) {
            this.part1 = part1;
            this.part2 = part2;
        }

        @Override
        public String getDisplayName() {
            StringBuilder builder = new StringBuilder(48);
            Describables.appendDisplayName(this.part1, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part2, builder);
            return builder.toString();
        }

        @Override
        public String getCapitalizedDisplayName() {
            StringBuilder builder = new StringBuilder(48);
            Describables.appendCapDisplayName(this.part1, builder);
            builder.append(' ');
            Describables.appendDisplayName(this.part2, builder);
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwoPartDescribable that = (TwoPartDescribable)o;
            return Objects.equal((Object)this.part1, (Object)that.part1) && Objects.equal((Object)this.part2, (Object)that.part2);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.part1, this.part2});
        }
    }

    private static class FixedDescribable
    extends AbstractDescribable {
        private final Object displayName;

        FixedDescribable(Object displayName) {
            this.displayName = displayName;
        }

        @Override
        public String getDisplayName() {
            if (this.displayName instanceof CharSequence) {
                return this.displayName.toString();
            }
            StringBuilder builder = new StringBuilder(32);
            Describables.appendDisplayName(this.displayName, builder);
            return builder.toString();
        }

        @Override
        public String getCapitalizedDisplayName() {
            StringBuilder builder = new StringBuilder();
            Describables.appendCapDisplayName(this.displayName, builder);
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixedDescribable that = (FixedDescribable)o;
            return Objects.equal((Object)this.displayName, (Object)that.displayName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.displayName});
        }
    }

    private static abstract class AbstractDescribable
    implements DisplayName {
        private AbstractDescribable() {
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

