/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.exception;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
public interface ExceptionAnalyser {
    public RuntimeException transform(Throwable var1);

    @Nullable
    default public RuntimeException transform(List<Throwable> failures) {
        if (failures.isEmpty()) {
            return null;
        }
        ArrayList<? extends Throwable> unpacked = new ArrayList<Throwable>(failures.size());
        for (Throwable failure : failures) {
            if (failure instanceof MultipleBuildFailures) {
                unpacked.addAll(((MultipleBuildFailures)failure).getCauses());
                continue;
            }
            unpacked.add(failure);
        }
        if (unpacked.size() == 1) {
            return this.transform((Throwable)unpacked.get(0));
        }
        return this.transform(new MultipleBuildFailures(unpacked));
    }
}

