/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.internal.build.BuildModelController;

public class VintageBuildModelController
implements BuildModelController {
    private final ProjectsPreparer projectsPreparer;
    private final GradleInternal gradle;
    private final SettingsPreparer settingsPreparer;
    private final TaskExecutionPreparer taskExecutionPreparer;
    private Stage stage = Stage.Created;

    public VintageBuildModelController(GradleInternal gradle, ProjectsPreparer projectsPreparer, SettingsPreparer settingsPreparer, TaskExecutionPreparer taskExecutionPreparer) {
        this.gradle = gradle;
        this.projectsPreparer = projectsPreparer;
        this.settingsPreparer = settingsPreparer;
        this.taskExecutionPreparer = taskExecutionPreparer;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        this.doBuildStages(Stage.LoadSettings);
        return this.gradle.getSettings();
    }

    @Override
    public GradleInternal getConfiguredModel() {
        this.doBuildStages(Stage.Configure);
        return this.gradle;
    }

    @Override
    public void scheduleRequestedTasks() {
        this.doBuildStages(Stage.TaskGraph);
    }

    private void doBuildStages(Stage upTo) {
        this.prepareSettings();
        if (upTo == Stage.LoadSettings) {
            return;
        }
        this.prepareProjects();
        if (upTo == Stage.Configure) {
            return;
        }
        this.prepareTaskExecution();
    }

    private void prepareSettings() {
        if (this.stage == Stage.Created) {
            this.settingsPreparer.prepareSettings(this.gradle);
            this.stage = Stage.LoadSettings;
        }
    }

    private void prepareProjects() {
        if (this.stage == Stage.LoadSettings) {
            this.projectsPreparer.prepareProjects(this.gradle);
            this.stage = Stage.Configure;
        }
    }

    private void prepareTaskExecution() {
        if (this.stage == Stage.Configure) {
            this.taskExecutionPreparer.prepareForTaskExecution(this.gradle);
            this.stage = Stage.TaskGraph;
        }
    }

    @Override
    public void scheduleTasks(Iterable<String> taskPaths) {
        boolean added = this.getConfiguredModel().getStartParameter().addTaskNames(taskPaths);
        if (!added) {
            return;
        }
        this.stage = Stage.Configure;
        this.doBuildStages(Stage.TaskGraph);
    }

    private static enum Stage {
        Created,
        LoadSettings,
        Configure,
        TaskGraph;

    }
}

