/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configurationcache.SystemPropertyAccessListenerKt;
import org.gradle.configurationcache.UndeclaredBuildInputListener;
import org.gradle.configurationcache.problems.DocumentationSection;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.PropertyProblemKt;
import org.gradle.configurationcache.problems.PropertyTrace;
import org.gradle.configurationcache.problems.StructuredMessage;
import org.gradle.configurationcache.serialization.Workarounds;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.org.jetbrains.annotations.NotNull;
import org.gradle.internal.impldep.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gradle/configurationcache/SystemPropertyAccessListener;", "Lorg/gradle/internal/classpath/Instrumented$Listener;", "problems", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "userCodeContext", "Lorg/gradle/configuration/internal/UserCodeApplicationContext;", "listenerManager", "Lorg/gradle/internal/event/ListenerManager;", "(Lorg/gradle/configurationcache/problems/ProblemsListener;Lorg/gradle/configuration/internal/UserCodeApplicationContext;Lorg/gradle/internal/event/ListenerManager;)V", "broadcast", "Lorg/gradle/configurationcache/UndeclaredBuildInputListener;", "kotlin.jvm.PlatformType", "nullProperties", "", "", "systemPropertyQueried", "", "key", "value", "", "consumer", "configuration-cache"})
public final class SystemPropertyAccessListener
implements Instrumented.Listener {
    private final UndeclaredBuildInputListener broadcast;
    private final Set<String> nullProperties;
    private final ProblemsListener problems;
    private final UserCodeApplicationContext userCodeContext;

    @Override
    public void systemPropertyQueried(@NotNull String key, @Nullable Object value, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (SystemPropertyAccessListenerKt.access$getAllowedProperties$p().contains(key) || Workarounds.INSTANCE.canReadSystemProperty(consumer)) {
            return;
        }
        if (value == null) {
            if (this.nullProperties.add(key)) {
                this.broadcast.systemPropertyRead(key);
            }
            return;
        }
        StructuredMessage message2 = StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(key){
            final /* synthetic */ String $key;

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$receiver");
                $this$build.text("read system property ");
                $this$build.reference(this.$key);
            }
            {
                this.$key = string2;
                super(1);
            }
        }));
        PropertyTrace location = PropertyProblemKt.location(this.userCodeContext, consumer);
        InvalidUserCodeException exception = new InvalidUserCodeException(StringsKt.capitalize((String)message2.toString()));
        this.problems.onProblem(new PropertyProblem(location, message2, exception, DocumentationSection.RequirementsUndeclaredSysPropRead));
    }

    public SystemPropertyAccessListener(@NotNull ProblemsListener problems, @NotNull UserCodeApplicationContext userCodeContext, @NotNull ListenerManager listenerManager) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)userCodeContext, (String)"userCodeContext");
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        this.problems = problems;
        this.userCodeContext = userCodeContext;
        this.broadcast = listenerManager.getBroadcaster(UndeclaredBuildInputListener.class);
        boolean bl = false;
        this.nullProperties = new LinkedHashSet();
    }
}

