/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.TreeMultimap;
import org.gradle.util.Path;

public class AggregateMultiProjectTaskReportModel
implements TaskReportModel {
    private final List<TaskReportModel> projects = new ArrayList<TaskReportModel>();
    private SetMultimap<String, TaskDetails> groups;
    private final boolean mergeTasksWithSameName;
    private final boolean detail;
    private final String group;

    public AggregateMultiProjectTaskReportModel(boolean mergeTasksWithSameName, boolean detail, String group) {
        this.mergeTasksWithSameName = mergeTasksWithSameName;
        this.detail = detail;
        this.group = Strings.isNullOrEmpty((String)group) ? null : group.toLowerCase();
    }

    public void add(TaskReportModel project) {
        this.projects.add(project);
    }

    public void build() {
        this.groups = TreeMultimap.create(String::compareToIgnoreCase, Comparator.comparing(TaskDetails::getPath));
        for (TaskReportModel project : this.projects) {
            for (String group : project.getGroups()) {
                if (!this.isVisible(group)) continue;
                for (TaskDetails task : project.getTasksForGroup(group)) {
                    this.groups.put((Object)group, (Object)(this.mergeTasksWithSameName ? this.mergedTaskDetails(task) : task));
                }
            }
        }
    }

    private TaskDetails mergedTaskDetails(TaskDetails task) {
        return TaskDetails.of(Path.path(task.getPath().getName()), task.getDescription());
    }

    private boolean isVisible(String group) {
        if (Strings.isNullOrEmpty((String)group)) {
            return this.detail;
        }
        return this.group == null || group.toLowerCase().equals(this.group);
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String group) {
        return this.groups.get((Object)group);
    }
}

