/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.internal.Cast;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.watch.vfs.WatchMode;

public class StartParameterInternal
extends StartParameter {
    private WatchMode watchFileSystemMode = WatchMode.DEFAULT;
    private boolean watchFileSystemDebugLogging;
    private boolean vfsVerboseLogging;
    private BuildOption.Value<Boolean> configurationCache = BuildOption.Value.defaultValue(false);
    private BuildOption.Value<Boolean> isolatedProjects = BuildOption.Value.defaultValue(false);
    private StartParameterBuildOptions.ConfigurationCacheProblemsOption.Value configurationCacheProblems = StartParameterBuildOptions.ConfigurationCacheProblemsOption.Value.FAIL;
    private int configurationCacheMaxProblems = 512;
    private boolean configurationCacheRecreateCache;
    private boolean configurationCacheQuiet;
    private boolean searchUpwards = true;
    private boolean useEmptySettings = false;

    public StartParameterInternal() {
    }

    protected StartParameterInternal(BuildLayoutParameters layoutParameters) {
        super(layoutParameters);
    }

    @Override
    public StartParameterInternal newInstance() {
        return (StartParameterInternal)this.prepareNewInstance(new StartParameterInternal());
    }

    @Override
    public StartParameterInternal newBuild() {
        return this.prepareNewBuild(new StartParameterInternal());
    }

    @Override
    protected StartParameterInternal prepareNewBuild(StartParameter startParameter) {
        StartParameterInternal p = (StartParameterInternal)super.prepareNewBuild(startParameter);
        p.watchFileSystemMode = this.watchFileSystemMode;
        p.watchFileSystemDebugLogging = this.watchFileSystemDebugLogging;
        p.vfsVerboseLogging = this.vfsVerboseLogging;
        p.configurationCache = this.configurationCache;
        p.isolatedProjects = this.isolatedProjects;
        p.configurationCacheProblems = this.configurationCacheProblems;
        p.configurationCacheMaxProblems = this.configurationCacheMaxProblems;
        p.configurationCacheRecreateCache = this.configurationCacheRecreateCache;
        p.configurationCacheQuiet = this.configurationCacheQuiet;
        p.searchUpwards = this.searchUpwards;
        p.useEmptySettings = this.useEmptySettings;
        return p;
    }

    public File getGradleHomeDir() {
        return this.gradleHomeDir;
    }

    public void setGradleHomeDir(File gradleHomeDir) {
        this.gradleHomeDir = gradleHomeDir;
    }

    public boolean isSearchUpwards() {
        return this.searchUpwards && !StartParameterInternal.useLocationAsProjectRoot(this.getProjectDir(), this.getTaskNames());
    }

    public void doNotSearchUpwards() {
        this.searchUpwards = false;
    }

    public boolean isUseEmptySettings() {
        return this.useEmptySettings;
    }

    public void useEmptySettings() {
        this.useEmptySettings = true;
    }

    public WatchMode getWatchFileSystemMode() {
        return this.watchFileSystemMode;
    }

    public void setWatchFileSystemMode(WatchMode watchFileSystemMode) {
        this.watchFileSystemMode = watchFileSystemMode;
    }

    public boolean isWatchFileSystemDebugLogging() {
        return this.watchFileSystemDebugLogging;
    }

    public void setWatchFileSystemDebugLogging(boolean watchFileSystemDebugLogging) {
        this.watchFileSystemDebugLogging = watchFileSystemDebugLogging;
    }

    public boolean isVfsVerboseLogging() {
        return this.vfsVerboseLogging;
    }

    public void setVfsVerboseLogging(boolean vfsVerboseLogging) {
        this.vfsVerboseLogging = vfsVerboseLogging;
    }

    @Deprecated
    public boolean isConfigurationCache() {
        return this.getConfigurationCache().get();
    }

    public BuildOption.Value<Boolean> getConfigurationCache() {
        return this.configurationCache;
    }

    public void setConfigurationCache(BuildOption.Value<Boolean> configurationCache) {
        this.configurationCache = configurationCache;
    }

    public BuildOption.Value<Boolean> getIsolatedProjects() {
        return this.isolatedProjects;
    }

    public void setIsolatedProjects(BuildOption.Value<Boolean> isolatedProjects) {
        this.isolatedProjects = isolatedProjects;
    }

    public StartParameterBuildOptions.ConfigurationCacheProblemsOption.Value getConfigurationCacheProblems() {
        return this.configurationCacheProblems;
    }

    public void setConfigurationCacheProblems(StartParameterBuildOptions.ConfigurationCacheProblemsOption.Value configurationCacheProblems) {
        this.configurationCacheProblems = configurationCacheProblems;
    }

    public int getConfigurationCacheMaxProblems() {
        return this.configurationCacheMaxProblems;
    }

    public void setConfigurationCacheMaxProblems(int configurationCacheMaxProblems) {
        this.configurationCacheMaxProblems = configurationCacheMaxProblems;
    }

    public boolean isConfigurationCacheRecreateCache() {
        return this.configurationCacheRecreateCache;
    }

    public void setConfigurationCacheRecreateCache(boolean configurationCacheRecreateCache) {
        this.configurationCacheRecreateCache = configurationCacheRecreateCache;
    }

    public boolean isConfigurationCacheQuiet() {
        return this.configurationCacheQuiet;
    }

    public void setConfigurationCacheQuiet(boolean configurationCacheQuiet) {
        this.configurationCacheQuiet = configurationCacheQuiet;
    }

    public boolean addTaskNames(Iterable<String> taskPaths) {
        LinkedHashSet allTasks = Sets.newLinkedHashSet(this.getTaskNames());
        boolean added = allTasks.addAll(taskPaths instanceof Collection ? (Collection)Cast.uncheckedCast(taskPaths) : Lists.newArrayList(taskPaths));
        if (added) {
            this.setTaskNames(allTasks);
        }
        return added;
    }

    public static boolean useLocationAsProjectRoot(@Nullable File potentialProjectLocation, List<String> requestedTaskNames2) {
        return requestedTaskNames2.contains("init") || potentialProjectLocation != null && potentialProjectLocation.getName().equals("buildSrc");
    }
}

