/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.plugins.pipelines.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/space/plugins/pipelines/utils/DslFileFinder;", "", "()V", "checkFileNameIsApplicable", "", "name", "", "find", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "baseDirFile", "intellij.space"})
public final class DslFileFinder {
    @NotNull
    public static final DslFileFinder INSTANCE;

    @Nullable
    public final VirtualFile find(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getBasePath();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.basePath ?: return null");
        String basePath = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(basePath);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026(basePath) ?: return null");
        VirtualFile baseDirFile = virtualFile;
        return this.find(baseDirFile);
    }

    public final boolean checkFileNameIsApplicable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.equals((String)".space.kts", (String)name, (boolean)true);
    }

    private final VirtualFile find(VirtualFile baseDirFile) {
        VirtualFile virtualFile;
        block1: {
            VirtualFile[] virtualFileArray = baseDirFile.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"baseDirFile.children");
            VirtualFile[] $this$firstOrNull$iv = virtualFileArray;
            boolean $i$f$firstOrNull = false;
            VirtualFile[] virtualFileArray2 = $this$firstOrNull$iv;
            int n = virtualFileArray2.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = virtualFileArray2[i];
                boolean bl = false;
                VirtualFile virtualFile2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                String string = virtualFile2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (!INSTANCE.checkFileNameIsApplicable(string)) continue;
                virtualFile = element$iv;
                break block1;
            }
            virtualFile = null;
        }
        return virtualFile;
    }

    private DslFileFinder() {
    }

    static {
        DslFileFinder dslFileFinder;
        INSTANCE = dslFileFinder = new DslFileFinder();
    }
}

