/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.internal.statistic.FeaturedPluginsInfoProvider;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.TimeoutCachedValue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000e\u001a\u0012\u0010\u0014\u001a\u00020\u00012\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000e\u001a\u000e\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u001a\u0010\u0010\u001e\u001a\u00020\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\f\u001a\u0014\u0010 \u001a\u00020!2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002\u001a\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001aH\u0002\u001a\u001e\u0010$\u001a\u00020!2\b\u0010\u001f\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\u001a\u001a\u0010%\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0003\"\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u000f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0003\u00a8\u0006&"}, d2={"builtFromSources", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "getBuiltFromSources", "()Lcom/intellij/internal/statistic/utils/PluginInfo;", "jvmCore", "getJvmCore", "notListedPlugin", "platformPlugin", "getPlatformPlugin", "pluginIdsFromOfficialJbPluginRepo", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/extensions/PluginId;", "tbePluginId", "", "unknownPlugin", "getUnknownPlugin", "findPluginTypeByValue", "Lcom/intellij/internal/statistic/utils/PluginType;", "value", "getPluginInfo", "clazz", "Ljava/lang/Class;", "className", "getPluginInfoByDescriptor", "plugin", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getPluginInfoByDescriptorWithFeaturedPlugins", "featuredPlugins", "Lcom/intellij/internal/statistic/FeaturedPluginsInfoProvider;", "getPluginInfoById", "pluginId", "isClassFromCoreOrJetBrainsPlugin", "", "isCoreOrJetBrainsPlugin", "descriptor", "isPluginFromOfficialJbPluginRepo", "isSafeToReportFrom", "intellij.platform.statistics"})
public final class PluginInfoDetectorKt {
    private static final String tbePluginId = "org.jetbrains.toolbox-enterprise-client";
    @NotNull
    private static final PluginInfo jvmCore = new PluginInfo(PluginType.JVM_CORE, null, null);
    @NotNull
    private static final PluginInfo platformPlugin = new PluginInfo(PluginType.PLATFORM, null, null);
    @NotNull
    private static final PluginInfo unknownPlugin = new PluginInfo(PluginType.UNKNOWN, null, null);
    private static final PluginInfo notListedPlugin = new PluginInfo(PluginType.NOT_LISTED, null, null);
    @NotNull
    private static final PluginInfo builtFromSources = new PluginInfo(PluginType.FROM_SOURCES, null, null);
    private static final Supplier<Set<PluginId>> pluginIdsFromOfficialJbPluginRepo = (Supplier)new TimeoutCachedValue(1L, TimeUnit.HOURS, (Supplier)pluginIdsFromOfficialJbPluginRepo.1.INSTANCE);

    @NotNull
    public static final PluginInfo getPluginInfo(@NotNull Class<?> clazz) {
        PluginInfo pluginInfo;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof PluginAwareClassLoader) {
            PluginDescriptor pluginDescriptor = ((PluginAwareClassLoader)classLoader).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"classLoader.pluginDescriptor");
            pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor(pluginDescriptor);
        } else if (PluginManagerCore.isRunningFromSources() && !PluginManagerCore.isUnitTestMode) {
            pluginInfo = builtFromSources;
        } else {
            String string = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name");
            pluginInfo = PluginInfoDetectorKt.getPluginInfo(string);
        }
        return pluginInfo;
    }

    @NotNull
    public static final PluginInfo getPluginInfo(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (StringsKt.startsWith$default((String)className, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"javax.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"groovy.", (boolean)false, (int)2, null)) {
            return jvmCore;
        }
        PluginDescriptor pluginDescriptor = PluginManagerCore.getPluginDescriptorOrPlatformByClassName((String)className);
        if (pluginDescriptor == null) {
            return unknownPlugin;
        }
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"PluginManagerCore.getPlu\u2026) ?: return unknownPlugin");
        PluginDescriptor plugin = pluginDescriptor;
        return PluginInfoDetectorKt.getPluginInfoByDescriptor(plugin);
    }

    @NotNull
    public static final PluginInfo getPluginInfoById(@Nullable PluginId pluginId) {
        if (pluginId == null) {
            return unknownPlugin;
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId);
        if (plugin == null) {
            return PluginInfoDetectorKt.isPluginFromOfficialJbPluginRepo$default(pluginId, null, 2, null) ? new PluginInfo(PluginType.LISTED, pluginId.getIdString(), null) : unknownPlugin;
        }
        return PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)plugin);
    }

    @NotNull
    public static final PluginInfo getPluginInfoByDescriptor(@NotNull PluginDescriptor plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        return PluginInfoDetectorKt.getPluginInfoByDescriptorWithFeaturedPlugins(plugin, null);
    }

    @NotNull
    public static final PluginInfo getPluginInfoByDescriptorWithFeaturedPlugins(@NotNull PluginDescriptor plugin, @Nullable FeaturedPluginsInfoProvider featuredPlugins) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)plugin.getPluginId())) {
            return platformPlugin;
        }
        PluginId pluginId = plugin.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"plugin.pluginId");
        String string = pluginId.getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.pluginId.idString");
        String id = string;
        String version = plugin.getVersion();
        if (PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)plugin)) {
            PluginType pluginType = plugin.isBundled() ? PluginType.JB_BUNDLED : (PluginManagerCore.isUpdatedBundledPlugin((PluginDescriptor)plugin) ? PluginType.JB_UPDATED_BUNDLED : PluginType.JB_NOT_BUNDLED);
            return new PluginInfo(pluginType, id, version);
        }
        boolean listed = !plugin.isBundled() && !PluginManagerCore.isUpdatedBundledPlugin((PluginDescriptor)plugin) && PluginInfoDetectorKt.isSafeToReportFrom(plugin, featuredPlugins);
        return listed ? new PluginInfo(PluginType.LISTED, id, version) : notListedPlugin;
    }

    @Nullable
    public static final PluginType findPluginTypeByValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        for (PluginType type : PluginType.values()) {
            if (!Intrinsics.areEqual((Object)type.name(), (Object)value)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static final PluginInfo getJvmCore() {
        return jvmCore;
    }

    @NotNull
    public static final PluginInfo getPlatformPlugin() {
        return platformPlugin;
    }

    @NotNull
    public static final PluginInfo getUnknownPlugin() {
        return unknownPlugin;
    }

    @NotNull
    public static final PluginInfo getBuiltFromSources() {
        return builtFromSources;
    }

    private static final boolean isSafeToReportFrom(PluginDescriptor descriptor, FeaturedPluginsInfoProvider featuredPlugins) {
        boolean bl;
        if (PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)descriptor)) {
            bl = true;
        } else if (descriptor.isBundled()) {
            bl = false;
        } else {
            Boolean bl2;
            PluginId pluginId = descriptor.getPluginId();
            if (pluginId != null) {
                PluginId pluginId2 = pluginId;
                boolean bl3 = false;
                boolean bl4 = false;
                PluginId it = pluginId2;
                boolean bl5 = false;
                bl2 = PluginInfoDetectorKt.isPluginFromOfficialJbPluginRepo(it, featuredPlugins);
            } else {
                bl2 = null;
            }
            bl = bl2;
        }
        return bl;
    }

    private static final boolean isPluginFromOfficialJbPluginRepo(PluginId pluginId, FeaturedPluginsInfoProvider featuredPlugins) {
        if (ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository()) {
            if (featuredPlugins != null && PluginInfoDetectorKt.isClassFromCoreOrJetBrainsPlugin(featuredPlugins.getClass()) && CollectionsKt.contains((Iterable)featuredPlugins.getFeaturedPluginsFromMarketplace(), (Object)pluginId)) {
                return true;
            }
            Set<PluginId> set = pluginIdsFromOfficialJbPluginRepo.get();
            Intrinsics.checkNotNullExpressionValue(set, (String)"pluginIdsFromOfficialJbPluginRepo.get()");
            return CollectionsKt.contains((Iterable)set, (Object)pluginId);
        }
        return false;
    }

    static /* synthetic */ boolean isPluginFromOfficialJbPluginRepo$default(PluginId pluginId, FeaturedPluginsInfoProvider featuredPluginsInfoProvider, int n, Object object) {
        if ((n & 2) != 0) {
            featuredPluginsInfoProvider = null;
        }
        return PluginInfoDetectorKt.isPluginFromOfficialJbPluginRepo(pluginId, featuredPluginsInfoProvider);
    }

    private static final boolean isClassFromCoreOrJetBrainsPlugin(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader instanceof PluginAwareClassLoader) {
            PluginDescriptor pluginDescriptor = ((PluginAwareClassLoader)loader).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"(loader as PluginAwareCl\u2026sLoader).pluginDescriptor");
            return PluginInfoDetectorKt.isCoreOrJetBrainsPlugin(pluginDescriptor);
        }
        PluginDescriptor descriptor = PluginManagerCore.getPluginDescriptorOrPlatformByClassName((String)clazz.getName());
        return descriptor != null && PluginInfoDetectorKt.isCoreOrJetBrainsPlugin(descriptor);
    }

    private static final boolean isCoreOrJetBrainsPlugin(PluginDescriptor descriptor) {
        return Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)descriptor.getPluginId()) || PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)descriptor);
    }
}

