/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class StatisticsStateCollectorsScheduler
implements ApplicationInitializedListener {
    public static final int LOG_APPLICATION_STATES_INITIAL_DELAY_IN_MIN = 10;
    public static final int LOG_APPLICATION_STATES_DELAY_IN_MIN = 1440;
    public static final int LOG_PROJECTS_STATES_INITIAL_DELAY_IN_MIN = 15;
    public static final int LOG_PROJECTS_STATES_DELAY_IN_MIN = 720;
    private static final Map<Project, Future<?>> myPersistStatisticsSessionsMap = Collections.synchronizedMap(new HashMap());

    public void componentsInitialized() {
        StatisticsStateCollectorsScheduler.runStatesLogging();
    }

    private static void runStatesLogging() {
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logApplicationStates(), 10L, 1440L, TimeUnit.MINUTES);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().schedule(() -> DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    ScheduledFuture<?> future = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logProjectStates(project, (ProgressIndicator)new EmptyProgressIndicator()), 0L, 720L, TimeUnit.MINUTES);
                    myPersistStatisticsSessionsMap.put(project, future);
                }), 15L, TimeUnit.MINUTES);
                myPersistStatisticsSessionsMap.put(project, scheduledFuture);
            }

            public void projectClosed(@NotNull Project project) {
                Future<?> future;
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((future = myPersistStatisticsSessionsMap.remove(project)) != null) {
                    future.cancel(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/internal/statistic/updater/StatisticsStateCollectorsScheduler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

