/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceIdManager {
    private static final Logger LOG = Logger.getInstance(DeviceIdManager.class);
    private static final String UNDEFINED = "UNDEFINED";
    private static final String DEVICE_ID_SHARED_FILE = "PermanentDeviceId";
    private static final String DEVICE_ID_PREFERENCE_KEY = "device_id";

    @Deprecated
    public static String getOrGenerateId() {
        try {
            return DeviceIdManager.getOrGenerateId(null, UNDEFINED);
        }
        catch (InvalidDeviceIdTokenException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    public static String getOrGenerateId(@Nullable DeviceIdToken token, @NotNull String recorderId) throws InvalidDeviceIdTokenException {
        if (recorderId == null) {
            DeviceIdManager.$$$reportNull$$$0(0);
        }
        DeviceIdManager.assertAllowed(token, recorderId);
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        Preferences prefs = DeviceIdManager.getPreferences(appInfo);
        String preferenceKey = DeviceIdManager.getPreferenceKey(recorderId);
        String deviceId = prefs.get(preferenceKey, null);
        if (StringUtil.isEmptyOrSpaces((String)deviceId)) {
            deviceId = DeviceIdManager.generateId(Calendar.getInstance(Locale.ENGLISH), DeviceIdManager.getOSChar());
            prefs.put(preferenceKey, deviceId);
            LOG.info("Generating new Device ID for '" + recorderId + "'");
        }
        if (appInfo.isVendorJetBrains() && SystemInfo.isWindows) {
            if (DeviceIdManager.isBaseRecorder(recorderId)) {
                deviceId = DeviceIdManager.syncWithSharedFile(DEVICE_ID_SHARED_FILE, deviceId, prefs, preferenceKey);
            } else {
                DeviceIdManager.deleteLegacySharedFile(recorderId + "_PermanentDeviceId");
            }
        }
        return deviceId;
    }

    private static void assertAllowed(@Nullable DeviceIdToken token, @NotNull String recorderId) throws InvalidDeviceIdTokenException {
        if (recorderId == null) {
            DeviceIdManager.$$$reportNull$$$0(1);
        }
        if (DeviceIdManager.isBaseRecorder(recorderId)) {
            if (token == null) {
                throw new InvalidDeviceIdTokenException("Cannot access base device id from unknown class");
            }
            if (!PluginInfoDetectorKt.getPluginInfo(token.getClass()).getType().isPlatformOrJetBrainsBundled()) {
                throw new InvalidDeviceIdTokenException("Cannot access base device id from " + token.getClass().getName());
            }
        } else if (!DeviceIdManager.isUndefinedRecorder(recorderId) && token == null) {
            throw new InvalidDeviceIdTokenException("Cannot access device id from unknown class");
        }
    }

    @NotNull
    private static String getPreferenceKey(@NotNull String recorderId) {
        if (recorderId == null) {
            DeviceIdManager.$$$reportNull$$$0(2);
        }
        Object object = DeviceIdManager.isBaseRecorder(recorderId) ? DEVICE_ID_PREFERENCE_KEY : StringUtil.toLowerCase((String)recorderId) + "_device_id";
        if (object == null) {
            DeviceIdManager.$$$reportNull$$$0(3);
        }
        return object;
    }

    private static boolean isBaseRecorder(@NotNull String recorderId) {
        if (recorderId == null) {
            DeviceIdManager.$$$reportNull$$$0(4);
        }
        return "FUS".equals(recorderId);
    }

    private static boolean isUndefinedRecorder(@NotNull String recorderId) {
        if (recorderId == null) {
            DeviceIdManager.$$$reportNull$$$0(5);
        }
        return UNDEFINED.equals(recorderId);
    }

    @NotNull
    private static String syncWithSharedFile(@NotNull String fileName, @NotNull String installationId, @NotNull Preferences prefs, @NotNull String prefsKey) {
        File dir;
        String appdata;
        if (fileName == null) {
            DeviceIdManager.$$$reportNull$$$0(6);
        }
        if (installationId == null) {
            DeviceIdManager.$$$reportNull$$$0(7);
        }
        if (prefs == null) {
            DeviceIdManager.$$$reportNull$$$0(8);
        }
        if (prefsKey == null) {
            DeviceIdManager.$$$reportNull$$$0(9);
        }
        if ((appdata = System.getenv("APPDATA")) != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
            File permanentIdFile = new File(dir, fileName);
            try {
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    fromFile = DeviceIdManager.loadFromFile(permanentIdFile).trim();
                }
                if (!fromFile.isEmpty()) {
                    if (!fromFile.equals(installationId)) {
                        installationId = fromFile;
                        prefs.put(prefsKey, installationId);
                    }
                } else {
                    DeviceIdManager.writeToFile(permanentIdFile, installationId);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = installationId;
        if (string == null) {
            DeviceIdManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void deleteLegacySharedFile(@NotNull String fileName) {
        if (fileName == null) {
            DeviceIdManager.$$$reportNull$$$0(11);
        }
        try {
            File permanentIdFile;
            File dir;
            String appdata = System.getenv("APPDATA");
            if (appdata != null && (dir = new File(appdata, "JetBrains")).exists() && (permanentIdFile = new File(dir, fileName)).exists()) {
                permanentIdFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    private static String loadFromFile(@NotNull File file) throws IOException {
        if (file == null) {
            DeviceIdManager.$$$reportNull$$$0(12);
        }
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = FileUtilRt.loadBytes((InputStream)is);
        int offset = CharsetToolkit.hasUTF8Bom((byte[])bytes) ? CharsetToolkit.UTF8_BOM.length : 0;
        String string = new String(bytes, offset, bytes.length - offset, StandardCharsets.UTF_8);
        String string2 = string;
        if (string2 == null) {
            DeviceIdManager.$$$reportNull$$$0(13);
        }
        return string2;
        finally {
            is.close();
        }
    }

    private static void writeToFile(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            DeviceIdManager.$$$reportNull$$$0(14);
        }
        if (text == null) {
            DeviceIdManager.$$$reportNull$$$0(15);
        }
        try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file));){
            stream.write(text.getBytes(StandardCharsets.UTF_8));
        }
    }

    @NotNull
    private static Preferences getPreferences(@NotNull ApplicationInfoEx appInfo) {
        String companyName;
        if (appInfo == null) {
            DeviceIdManager.$$$reportNull$$$0(16);
        }
        String name = StringUtil.isEmptyOrSpaces((String)(companyName = appInfo.getShortCompanyName())) ? "jetbrains" : companyName.toLowerCase(Locale.US);
        Preferences preferences = Preferences.userRoot().node(name);
        if (preferences == null) {
            DeviceIdManager.$$$reportNull$$$0(17);
        }
        return preferences;
    }

    public static String generateId(@NotNull Calendar calendar, char OSChar) {
        int year;
        if (calendar == null) {
            DeviceIdManager.$$$reportNull$$$0(18);
        }
        if ((year = calendar.get(1)) < 2000) {
            year = 2000;
        }
        if (year > 2099) {
            year = 2099;
        }
        calendar.set(1, year);
        return new SimpleDateFormat("ddMMyy", Locale.ENGLISH).format(calendar.getTime()) + OSChar + UUID.randomUUID().toString();
    }

    private static char getOSChar() {
        if (SystemInfo.isWindows) {
            return '1';
        }
        if (SystemInfo.isMac) {
            return '2';
        }
        if (SystemInfo.isLinux) {
            return '3';
        }
        return '0';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/DeviceIdManager";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installationId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefsKey";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calendar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/DeviceIdManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferenceKey";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "syncWithSharedFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrGenerateId";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assertAllowed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPreferenceKey";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isBaseRecorder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUndefinedRecorder";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "syncWithSharedFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteLegacySharedFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPreferences";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InvalidDeviceIdTokenException
    extends Exception {
        private InvalidDeviceIdTokenException(String message) {
            super(message);
        }
    }

    public static interface DeviceIdToken {
    }
}

