/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionInfoCache {
    private final ConcurrentMap<String, ClassResolveInfo> myCache;
    private final Project myProject;
    private final GlobalSearchScope mySearchScope;

    @Deprecated
    public ExceptionInfoCache(@NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            ExceptionInfoCache.$$$reportNull$$$0(0);
        }
        this(Objects.requireNonNull(searchScope.getProject()), searchScope);
    }

    public ExceptionInfoCache(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            ExceptionInfoCache.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            ExceptionInfoCache.$$$reportNull$$$0(2);
        }
        this.myCache = ContainerUtil.createConcurrentSoftValueMap();
        this.myProject = project;
        this.mySearchScope = searchScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExceptionInfoCache.$$$reportNull$$$0(3);
        }
        return project;
    }

    private PsiClass @NotNull [] findClassesPreferringMyScope(String className) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(this.myProject);
        PsiClass[] result = psiFacade.findClasses(className, this.mySearchScope);
        PsiClass[] psiClassArray = result.length != 0 ? result : psiFacade.findClasses(className, GlobalSearchScope.allScope((Project)this.myProject));
        if (psiClassArray == null) {
            ExceptionInfoCache.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @NotNull
    public ClassResolveInfo resolveClassOrFile(String className, @Nullable String fileName) {
        ClassResolveInfo info = this.resolveClass(className);
        if (info.myClasses.isEmpty() && fileName != null) {
            String id = "file://" + fileName;
            ClassResolveInfo cached = (ClassResolveInfo)this.myCache.get(id);
            if (cached != null) {
                ClassResolveInfo classResolveInfo = cached;
                if (classResolveInfo == null) {
                    ExceptionInfoCache.$$$reportNull$$$0(5);
                }
                return classResolveInfo;
            }
            PsiFile[] files = PsiShortNamesCache.getInstance(this.myProject).getFilesByName(fileName);
            info = ClassResolveInfo.create(this.myProject, (PsiElement[])files);
            this.myCache.put(id, info);
        }
        ClassResolveInfo classResolveInfo = info;
        if (classResolveInfo == null) {
            ExceptionInfoCache.$$$reportNull$$$0(6);
        }
        return classResolveInfo;
    }

    @NotNull
    ClassResolveInfo resolveClass(String className) {
        int dollarIndex;
        ClassResolveInfo cached = (ClassResolveInfo)this.myCache.get(className);
        if (cached != null && cached.isValid()) {
            ClassResolveInfo classResolveInfo = cached;
            if (classResolveInfo == null) {
                ExceptionInfoCache.$$$reportNull$$$0(7);
            }
            return classResolveInfo;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            ClassResolveInfo classResolveInfo = ClassResolveInfo.EMPTY;
            if (classResolveInfo == null) {
                ExceptionInfoCache.$$$reportNull$$$0(8);
            }
            return classResolveInfo;
        }
        PsiElement[] classes = this.findClassesPreferringMyScope(className);
        if (classes.length == 0 && (dollarIndex = className.indexOf(36)) >= 0) {
            classes = this.findClassesPreferringMyScope(className.substring(0, dollarIndex));
        }
        ClassResolveInfo result = ClassResolveInfo.create(this.myProject, classes);
        this.myCache.put(className, result);
        ClassResolveInfo classResolveInfo = result;
        if (classResolveInfo == null) {
            ExceptionInfoCache.$$$reportNull$$$0(9);
        }
        return classResolveInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/ExceptionInfoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/ExceptionInfoCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesPreferringMyScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClassOrFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClassResolveInfo {
        static final ClassResolveInfo EMPTY = new ClassResolveInfo(Collections.emptyMap(), false);
        private final Map<VirtualFile, PsiElement> myClasses;
        private final boolean myInLibrary;
        private volatile List<PsiClass> myExceptionClasses;

        ClassResolveInfo(Map<VirtualFile, PsiElement> classes, boolean library) {
            this.myClasses = classes;
            this.myInLibrary = library;
        }

        List<PsiClass> getExceptionClasses() {
            List<PsiClass> exceptionClasses = this.myExceptionClasses;
            if (exceptionClasses == null) {
                exceptionClasses = new ArrayList<PsiClass>();
                for (PsiElement value2 : this.myClasses.values()) {
                    PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)value2, PsiClass.class);
                    if (psiClass == null || !InheritanceUtil.isInheritor(psiClass, "java.lang.Throwable")) continue;
                    exceptionClasses.add(psiClass);
                }
                this.myExceptionClasses = exceptionClasses;
            }
            return this.myExceptionClasses;
        }

        boolean isValid() {
            return ContainerUtil.and(this.myClasses.values(), PsiElement::isValid) && (this.myExceptionClasses == null || ContainerUtil.and(this.myExceptionClasses, PsiElement::isValid));
        }

        public Map<VirtualFile, PsiElement> getClasses() {
            return this.myClasses;
        }

        public boolean isInLibrary() {
            return this.myInLibrary;
        }

        @NotNull
        static ClassResolveInfo create(Project project, PsiElement[] elements) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            LinkedHashMap<VirtualFile, PsiElement> result = new LinkedHashMap<VirtualFile, PsiElement>();
            boolean library = true;
            for (PsiElement element : elements) {
                PsiFile file = (element = element.getNavigationElement()).getContainingFile();
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) continue;
                if (index.isInContent(virtualFile)) {
                    if (library) {
                        library = false;
                        result.clear();
                    }
                } else if (!library) continue;
                result.put(virtualFile, element);
            }
            return new ClassResolveInfo(result, library);
        }
    }
}

