/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionFilterFactory;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionLineParser;
import com.intellij.execution.filters.ExceptionLineParserFactory;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExceptionExFilterFactory
implements ExceptionFilterFactory {
    @Override
    @NotNull
    public Filter create(@NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            ExceptionExFilterFactory.$$$reportNull$$$0(0);
        }
        return new MyFilter(Objects.requireNonNull(searchScope.getProject()), searchScope);
    }

    @Override
    public Filter create(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            ExceptionExFilterFactory.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            ExceptionExFilterFactory.$$$reportNull$$$0(2);
        }
        return new MyFilter(project, searchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "searchScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/filters/ExceptionExFilterFactory";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyFilter
    implements Filter,
    FilterMixin {
        private final ExceptionInfoCache myCache;
        private final ExceptionLineParserFactory myFactory;

        MyFilter(@NotNull Project project, @NotNull GlobalSearchScope scope) {
            if (project == null) {
                MyFilter.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                MyFilter.$$$reportNull$$$0(1);
            }
            this.myFactory = ExceptionLineParserFactory.getInstance();
            this.myCache = new ExceptionInfoCache(project, scope);
        }

        public Filter.Result applyFilter(@NotNull String line, int textEndOffset) {
            if (line == null) {
                MyFilter.$$$reportNull$$$0(2);
            }
            return null;
        }

        public boolean shouldRunHeavy() {
            return true;
        }

        public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<? super FilterMixin.AdditionalHighlight> consumer) {
            if (copiedFragment == null) {
                MyFilter.$$$reportNull$$$0(3);
            }
            if (consumer == null) {
                MyFilter.$$$reportNull$$$0(4);
            }
            HashMap<String, ExceptionWorker.ParsedLine> visited = new HashMap<String, ExceptionWorker.ParsedLine>();
            ExceptionWorker.ParsedLine emptyInfo = new ExceptionWorker.ParsedLine(TextRange.EMPTY_RANGE, TextRange.EMPTY_RANGE, TextRange.EMPTY_RANGE, null, -1);
            ExceptionLineParser worker = this.myFactory.create(this.myCache);
            for (int i = 0; i < copiedFragment.getLineCount(); ++i) {
                ExceptionWorker.ParsedLine info;
                int lineEndOffset;
                int lineStartOffset = copiedFragment.getLineStartOffset(i);
                String lineText = copiedFragment.getText(new TextRange(lineStartOffset, lineEndOffset = copiedFragment.getLineEndOffset(i)));
                if (!lineText.contains(".java:") || (info = (ExceptionWorker.ParsedLine)visited.get(lineText)) == emptyInfo) continue;
                if (info == null) {
                    info = (ExceptionWorker.ParsedLine)ReadAction.compute(() -> DumbService.isDumb((Project)worker.getProject()) ? null : MyFilter.doParse(worker, lineEndOffset, lineText));
                    visited.put(lineText, info == null ? emptyInfo : info);
                    if (info == null) continue;
                }
                int off = startOffset + lineStartOffset;
                final Color color = UIUtil.getInactiveTextColor();
                consumer.consume((Object)new FilterMixin.AdditionalHighlight(off + info.classFqnRange.getStartOffset(), off + info.methodNameRange.getEndOffset()){

                    @NotNull
                    public TextAttributes getTextAttributes(@Nullable TextAttributes source) {
                        return new TextAttributes(null, null, color, EffectType.BOLD_DOTTED_LINE, 0);
                    }
                });
            }
        }

        private static ExceptionWorker.ParsedLine doParse(@NotNull ExceptionLineParser worker, int lineEndOffset, @NotNull String lineText) {
            PsiCodeBlock tryBlock;
            Filter.Result result;
            if (worker == null) {
                MyFilter.$$$reportNull$$$0(5);
            }
            if (lineText == null) {
                MyFilter.$$$reportNull$$$0(6);
            }
            if ((result = worker.execute(lineText, lineEndOffset)) == null) {
                return null;
            }
            HyperlinkInfo hyperlinkInfo = result.getHyperlinkInfo();
            if (!(hyperlinkInfo instanceof FileHyperlinkInfo)) {
                return null;
            }
            OpenFileDescriptor descriptor = ((FileHyperlinkInfo)hyperlinkInfo).getDescriptor();
            if (descriptor == null) {
                return null;
            }
            PsiFile psiFile = worker.getFile();
            if (psiFile == null || psiFile instanceof PsiCompiledFile) {
                return null;
            }
            int offset = descriptor.getOffset();
            if (offset <= 0) {
                return null;
            }
            PsiElement element = psiFile.findElementAt(offset);
            PsiTryStatement parent = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            PsiCodeBlock psiCodeBlock = tryBlock = parent != null ? parent.getTryBlock() : null;
            if (tryBlock == null || !tryBlock.getTextRange().contains(offset)) {
                return null;
            }
            return worker.getInfo();
        }

        @NotNull
        public String getUpdateMessage() {
            String string = JavaAnalysisBundle.message("highlighting.try.blocks", new Object[0]);
            if (string == null) {
                MyFilter.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copiedFragment";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "worker";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineText";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpdateMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFilter";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyHeavyFilter";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doParse";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

