/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.api;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.IdeSharedIndexesState;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.platform.impl.SharedIndexInfrastructure;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.FileBasedIndexVersionInfo;
import com.intellij.util.indexing.IndexInfrastructureVersionBase;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedIndexInfrastructureVersion
extends IndexInfrastructureVersionBase {
    public static final String SHARED_INDEXES_VERSIONS_FORMAT_VERSION = String.valueOf(SharedIndexInfrastructure.SHARED_INDEX_INFRASTRUCTURE_VERSION);
    private final SortedMap<IndexInfrastructureCapability, Map<String, String>> myCapabilities;
    private final SortedSet<IndexInfrastructureOs> mySupportedOs;
    private final SortedMap<String, String> myHashProviderVersions;

    public SharedIndexInfrastructureVersion(@NotNull Map<IndexInfrastructureCapability, Map<String, String>> capabilities, @NotNull Set<IndexInfrastructureOs> supportedOs, @NotNull Map<String, String> baseIndexes, @NotNull Map<String, FileBasedIndexVersionInfo> fileBasedIndexVersions, @NotNull Map<String, String> stubIndexVersions, @NotNull Map<String, String> stubFileElementTypeVersions, @NotNull Map<String, String> compositeBinaryStubFileBuilderVersions, @NotNull Map<String, String> hashProviderVersions) {
        if (capabilities == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(0);
        }
        if (supportedOs == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(1);
        }
        if (baseIndexes == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(2);
        }
        if (fileBasedIndexVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(3);
        }
        if (stubIndexVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(4);
        }
        if (stubFileElementTypeVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(5);
        }
        if (compositeBinaryStubFileBuilderVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(6);
        }
        if (hashProviderVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(7);
        }
        super(baseIndexes, fileBasedIndexVersions, stubIndexVersions, stubFileElementTypeVersions, compositeBinaryStubFileBuilderVersions);
        this.mySupportedOs = ImmutableSortedSet.copyOf(supportedOs);
        this.myHashProviderVersions = ImmutableSortedMap.copyOf(hashProviderVersions);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<IndexInfrastructureCapability, Map<String, String>> entry : capabilities.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)ImmutableSortedMap.copyOf(entry.getValue()));
        }
        this.myCapabilities = builder.build();
    }

    @NotNull
    public static SharedIndexInfrastructureVersion getIdeVersion() {
        SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = new IdeSharedIndexesState().getIndexVersion();
        if (sharedIndexInfrastructureVersion == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(8);
        }
        return sharedIndexInfrastructureVersion;
    }

    public String toString() {
        return "IndexInfrastructureVersion{base=" + this.myBaseIndexes + ", capabilities=" + this.myCapabilities + ", fileIndex=" + this.myFileBasedIndexVersions + ", stubIndex=" + this.myStubIndexVersions + ", stubFilesElementTypeVersions=" + this.myStubFileElementTypeVersions + ", compositeBinaryStubFileBuilderVersions=" + this.myCompositeBinaryStubFileBuilderVersions + ", supportedOs=" + this.mySupportedOs + "}";
    }

    @NotNull
    public String getWeakVersionHash() {
        return SharedIndexInfrastructureVersion.computeWeakHash(Arrays.asList(this.getBaseIndexes(), this.getFileBasedIndexVersions(), this.getStubIndexVersions(), this.getStubFileElementTypeVersions(), this.getCompositeBinaryStubFileBuilderVersions()));
    }

    @NotNull
    public String getWeakBaseVersionHash() {
        return SharedIndexInfrastructureVersion.computeWeakHash(Collections.singletonList(this.myBaseIndexes));
    }

    @NotNull
    private static String computeWeakHash(@NotNull List<Map<String, String>> maps) {
        if (maps == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(9);
        }
        Hasher hasher = Hashing.sha256().newHasher();
        for (Map<String, String> versions : maps) {
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(versions).entrySet()) {
                hasher.putString((CharSequence)entry.getKey(), StandardCharsets.UTF_8);
                hasher.putString((CharSequence)entry.getValue(), StandardCharsets.UTF_8);
            }
        }
        String string = StringUtil.first((String)hasher.hash().toString(), (int)12, (boolean)false);
        if (string == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public Map<String, String> getBaseIndexes() {
        SortedMap sortedMap = this.myBaseIndexes;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(11);
        }
        return sortedMap;
    }

    @NotNull
    public Map<String, String> getFileBasedIndexVersions() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry e : this.myFileBasedIndexVersions.entrySet()) {
            builder.put((Object)((String)e.getKey()), (Object)((FileBasedIndexVersionInfo)e.getValue()).getVersion());
        }
        ImmutableSortedMap immutableSortedMap = builder.build();
        if (immutableSortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(12);
        }
        return immutableSortedMap;
    }

    @NotNull
    public Map<String, Boolean> getFileBasedIndexThatNeedsForwardIndex() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry e : this.myFileBasedIndexVersions.entrySet()) {
            builder.put((Object)((String)e.getKey()), (Object)((FileBasedIndexVersionInfo)e.getValue()).getNeedsForwardIndex());
        }
        ImmutableSortedMap immutableSortedMap = builder.build();
        if (immutableSortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(13);
        }
        return immutableSortedMap;
    }

    @NotNull
    public Map<String, FileBasedIndexVersionInfo> getFileBasedIndexVersionInfos() {
        SortedMap sortedMap = this.myFileBasedIndexVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(14);
        }
        return sortedMap;
    }

    @NotNull
    public Map<String, String> getStubIndexVersions() {
        SortedMap sortedMap = this.myStubIndexVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(15);
        }
        return sortedMap;
    }

    @NotNull
    public Map<String, String> getStubFileElementTypeVersions() {
        SortedMap sortedMap = this.myStubFileElementTypeVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(16);
        }
        return sortedMap;
    }

    @NotNull
    public SortedMap<String, String> getCompositeBinaryStubFileBuilderVersions() {
        SortedMap sortedMap = this.myCompositeBinaryStubFileBuilderVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(17);
        }
        return sortedMap;
    }

    @NotNull
    public Map<IndexInfrastructureCapability, Map<String, String>> getCapabilities() {
        SortedMap<IndexInfrastructureCapability, Map<String, String>> sortedMap = this.myCapabilities;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(18);
        }
        return sortedMap;
    }

    @NotNull
    public Set<IndexInfrastructureOs> getSupportedOs() {
        SortedSet<IndexInfrastructureOs> sortedSet = this.mySupportedOs;
        if (sortedSet == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(19);
        }
        return sortedSet;
    }

    @NotNull
    public Map<String, String> getHashProviderVersions() {
        SortedMap<String, String> sortedMap = this.myHashProviderVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(20);
        }
        return sortedMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SharedIndexInfrastructureVersion version = (SharedIndexInfrastructureVersion)((Object)o);
        return this.myBaseIndexes.equals(version.myBaseIndexes) && this.myFileBasedIndexVersions.equals(version.myFileBasedIndexVersions) && this.myStubIndexVersions.equals(version.myStubIndexVersions) && this.myStubFileElementTypeVersions.equals(version.myStubFileElementTypeVersions) && this.myCompositeBinaryStubFileBuilderVersions.equals(version.myCompositeBinaryStubFileBuilderVersions) && this.myCapabilities.equals(version.myCapabilities) && this.mySupportedOs.equals(version.mySupportedOs);
    }

    public int hashCode() {
        return Objects.hash(this.myBaseIndexes, this.myFileBasedIndexVersions, this.myStubIndexVersions, this.myCapabilities, this.mySupportedOs, this.myStubFileElementTypeVersions, this.myCompositeBinaryStubFileBuilderVersions);
    }

    public boolean isSuitableMetadata(@NotNull SharedIndexMetadata metadata) {
        if (metadata == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(21);
        }
        return this.pickBestSuitableMetadata(Collections.singletonList(metadata)) == metadata;
    }

    @Nullable
    public SharedIndexMetadata pickBestSuitableMetadata(@NotNull Collection<SharedIndexMetadata> metadataCollection) {
        if (metadataCollection == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(22);
        }
        int bestScore = -1;
        SharedIndexMetadata bestMetadata = null;
        for (SharedIndexMetadata metadata : metadataCollection) {
            int commonFileBasedIndexesCount;
            SharedIndexInfrastructureVersion version = metadata.getIndexInfrastructureVersion();
            if (!version.getSupportedOs().containsAll(this.getSupportedOs()) || !version.getBaseIndexes().equals(this.getBaseIndexes()) || (commonFileBasedIndexesCount = Sets.intersection(version.getFileBasedIndexVersions().entrySet(), this.getFileBasedIndexVersions().entrySet()).size()) < 3) continue;
            int fileBasedIndexScore = 0;
            for (Map.Entry<String, String> entry : this.getFileBasedIndexVersions().entrySet()) {
                String fbiName = entry.getKey();
                String versionInfo = version.getFileBasedIndexVersions().get(fbiName);
                Integer usages = (Integer)metadata.getGenerationStatistics().getFileBasedIndexUsages().get(fbiName);
                if (versionInfo == null || usages == null || !versionInfo.equals(entry.getValue())) continue;
                fileBasedIndexScore += usages.intValue();
            }
            int stubFileElementsScore = 0;
            for (Map.Entry<String, String> entry3 : this.getStubFileElementTypeVersions().entrySet()) {
                String elementType = entry3.getKey();
                String versionInfo = version.getStubFileElementTypeVersions().get(elementType);
                Integer usages = (Integer)metadata.getGenerationStatistics().getStubFileElementTypeUsages().get(elementType);
                if (versionInfo == null || usages == null || !versionInfo.equals(entry3.getValue())) continue;
                stubFileElementsScore += usages.intValue();
            }
            int n = fileBasedIndexScore + stubFileElementsScore;
            if (bestScore >= n) continue;
            bestScore = n;
            bestMetadata = metadata;
        }
        return bestMetadata;
    }

    public boolean isStubIndexVersionMatch(@NotNull SharedIndexInfrastructureVersion version) {
        boolean hasMismatchingStubIndexVersions;
        if (version == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(23);
        }
        boolean bl = hasMismatchingStubIndexVersions = !Maps.difference(version.getStubIndexVersions(), this.getStubIndexVersions()).entriesDiffering().isEmpty();
        return !hasMismatchingStubIndexVersions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capabilities";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedOs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndexes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndexVersions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexVersions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubFileElementTypeVersions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeBinaryStubFileBuilderVersions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashProviderVersions";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maps";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataCollection";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWeakHash";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIndexes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexVersions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexThatNeedsForwardIndex";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexVersionInfos";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIndexVersions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubFileElementTypeVersions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeBinaryStubFileBuilderVersions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapabilities";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedOs";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashProviderVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeWeakHash";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableMetadata";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "pickBestSuitableMetadata";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isStubIndexVersionMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

