/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSortedMap;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.metadata.SharedIndexGenerationStatistics;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.indexing.FileBasedIndexVersionInfo;
import com.intellij.util.text.StringKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB=\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "", "indexName", "", "indexKind", "indexInfrastructureVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "sharedIndexInfo", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "generationStatistics", "Lcom/intellij/indexing/shared/metadata/SharedIndexGenerationStatistics;", "generationTime", "Ljava/time/ZonedDateTime;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;Lcom/intellij/indexing/shared/metadata/SharedIndexGenerationStatistics;Ljava/time/ZonedDateTime;)V", "getGenerationStatistics", "()Lcom/intellij/indexing/shared/metadata/SharedIndexGenerationStatistics;", "getGenerationTime", "()Ljava/time/ZonedDateTime;", "getIndexInfrastructureVersion", "()Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "getIndexKind", "()Ljava/lang/String;", "getIndexName", "getSharedIndexInfo", "()Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.indexing.shared"})
public final class SharedIndexMetadata {
    @NotNull
    private final String indexName;
    @NotNull
    private final String indexKind;
    @NotNull
    private final SharedIndexInfrastructureVersion indexInfrastructureVersion;
    @NotNull
    private final SharedIndexMetadataInfo sharedIndexInfo;
    @NotNull
    private final SharedIndexGenerationStatistics generationStatistics;
    @NotNull
    private final ZonedDateTime generationTime;
    @NotNull
    public static final String METADATA_VERSION = "6";
    private static final Companion.TextValue.1 TextValue;
    private static final Companion.BooleanValue.1 BooleanValue;
    private static final Companion.IntValue.1 IntValue;
    private static final Companion.FiledBasedIndexInfoValue.1 FiledBasedIndexInfoValue;
    @NotNull
    public static final Companion Companion;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SharedIndexMetadata)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.indexName, (Object)((SharedIndexMetadata)other).indexName) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.indexKind, (Object)((SharedIndexMetadata)other).indexKind) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.sharedIndexInfo, (Object)((SharedIndexMetadata)other).sharedIndexInfo) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)((Object)this.indexInfrastructureVersion), (Object)((Object)((SharedIndexMetadata)other).indexInfrastructureVersion)) ^ true);
    }

    public int hashCode() {
        int result2 = this.indexName.hashCode();
        result2 = 31 * result2 + this.indexKind.hashCode();
        result2 = 31 * result2 + this.sharedIndexInfo.hashCode();
        result2 = 31 * result2 + this.indexInfrastructureVersion.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "SharedIndexMetadata(" + this.indexName + ", " + this.indexKind + "', indexInfrastructureVersion, " + this.sharedIndexInfo + ')';
    }

    @NotNull
    public final String getIndexName() {
        return this.indexName;
    }

    @NotNull
    public final String getIndexKind() {
        return this.indexKind;
    }

    @NotNull
    public final SharedIndexInfrastructureVersion getIndexInfrastructureVersion() {
        return this.indexInfrastructureVersion;
    }

    @NotNull
    public final SharedIndexMetadataInfo getSharedIndexInfo() {
        return this.sharedIndexInfo;
    }

    @NotNull
    public final SharedIndexGenerationStatistics getGenerationStatistics() {
        return this.generationStatistics;
    }

    @NotNull
    public final ZonedDateTime getGenerationTime() {
        return this.generationTime;
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexInfrastructureVersion indexInfrastructureVersion, @NotNull SharedIndexMetadataInfo sharedIndexInfo, @NotNull SharedIndexGenerationStatistics generationStatistics, @NotNull ZonedDateTime generationTime) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)indexKind, (String)"indexKind");
        Intrinsics.checkNotNullParameter((Object)((Object)indexInfrastructureVersion), (String)"indexInfrastructureVersion");
        Intrinsics.checkNotNullParameter((Object)sharedIndexInfo, (String)"sharedIndexInfo");
        Intrinsics.checkNotNullParameter((Object)generationStatistics, (String)"generationStatistics");
        Intrinsics.checkNotNullParameter((Object)generationTime, (String)"generationTime");
        this.indexName = indexName;
        this.indexKind = indexKind;
        this.indexInfrastructureVersion = indexInfrastructureVersion;
        this.sharedIndexInfo = sharedIndexInfo;
        this.generationStatistics = generationStatistics;
        this.generationTime = generationTime;
    }

    public /* synthetic */ SharedIndexMetadata(String string, String string2, SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion, SharedIndexMetadataInfo sharedIndexMetadataInfo, SharedIndexGenerationStatistics sharedIndexGenerationStatistics, ZonedDateTime zonedDateTime, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sharedIndexMetadataInfo = new SharedIndexMetadataInfo(null, null, null, null, null, null, null, null, 255, null);
        }
        if ((n & 0x10) != 0) {
            sharedIndexGenerationStatistics = new SharedIndexGenerationStatistics(MapsKt.sortedMapOf((Pair[])new Pair[0]), MapsKt.sortedMapOf((Pair[])new Pair[0]));
        }
        if ((n & 0x20) != 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now().withNano(0);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"ZonedDateTime.now().withNano(0)");
            zonedDateTime = zonedDateTime2;
        }
        this(string, string2, sharedIndexInfrastructureVersion, sharedIndexMetadataInfo, sharedIndexGenerationStatistics, zonedDateTime);
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexInfrastructureVersion indexInfrastructureVersion, @NotNull SharedIndexMetadataInfo sharedIndexInfo, @NotNull SharedIndexGenerationStatistics generationStatistics) {
        this(indexName, indexKind, indexInfrastructureVersion, sharedIndexInfo, generationStatistics, null, 32, null);
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexInfrastructureVersion indexInfrastructureVersion, @NotNull SharedIndexMetadataInfo sharedIndexInfo) {
        this(indexName, indexKind, indexInfrastructureVersion, sharedIndexInfo, null, null, 48, null);
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexInfrastructureVersion indexInfrastructureVersion) {
        this(indexName, indexKind, indexInfrastructureVersion, null, null, null, 56, null);
    }

    static {
        Companion = new Companion(null);
        TextValue = new Companion.LoadSaveValue<String>(){

            @Nullable
            public String loadValue(@Nullable JsonNode node) {
                JsonNode jsonNode = node;
                return jsonNode != null ? jsonNode.asText() : null;
            }

            public void saveValue(@NotNull ObjectNode node, @NotNull String key, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                node.put(key, value);
            }
        };
        BooleanValue = new Companion.LoadSaveValue<Boolean>(){

            @Nullable
            public Boolean loadValue(@Nullable JsonNode node) {
                JsonNode jsonNode = node;
                return jsonNode != null ? Boolean.valueOf(jsonNode.asBoolean()) : null;
            }

            public void saveValue(@NotNull ObjectNode node, @NotNull String key, boolean value) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                node.put(key, value);
            }
        };
        IntValue = new Companion.LoadSaveValue<Integer>(){

            @Nullable
            public Integer loadValue(@Nullable JsonNode node) {
                JsonNode jsonNode = node;
                return jsonNode != null ? Integer.valueOf(jsonNode.asInt()) : null;
            }

            public void saveValue(@NotNull ObjectNode node, @NotNull String key, int value) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                node.put(key, value);
            }
        };
        FiledBasedIndexInfoValue = new Companion.LoadSaveValue<FileBasedIndexVersionInfo>(){

            @Nullable
            public FileBasedIndexVersionInfo loadValue(@Nullable JsonNode node) {
                if (!(node instanceof ObjectNode)) {
                    return null;
                }
                String string = SharedIndexMetadata.access$getTextValue$cp().loadValue(node.get("version"));
                if (string == null) {
                    return null;
                }
                String version = string;
                Boolean bl = SharedIndexMetadata.access$getBooleanValue$cp().loadValue(node.get("needs_forward_index"));
                if (bl == null) {
                    return null;
                }
                boolean needsForwardIndex = bl;
                return new FileBasedIndexVersionInfo(version, needsForwardIndex);
            }

            public void saveValue(@NotNull ObjectNode node, @NotNull String key, @NotNull FileBasedIndexVersionInfo value) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ObjectNode objectNode = node.putObject(key);
                boolean bl = false;
                boolean bl2 = false;
                ObjectNode $this$apply = objectNode;
                boolean bl3 = false;
                Companion.TextValue.1 v0 = SharedIndexMetadata.access$getTextValue$cp();
                ObjectNode objectNode2 = $this$apply;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"this");
                v0.saveValue(objectNode2, "version", value.getVersion());
                SharedIndexMetadata.access$getBooleanValue$cp().saveValue($this$apply, "needs_forward_index", value.getNeedsForwardIndex());
            }
        };
    }

    public static final /* synthetic */ Companion.BooleanValue.1 access$getBooleanValue$cp() {
        return BooleanValue;
    }

    @JvmStatic
    @NotNull
    public static final Path getMetadataPath(@NotNull Path chunkRootPath) {
        return Companion.getMetadataPath(chunkRootPath);
    }

    @JvmStatic
    @NotNull
    public static final String getMetadataPath() {
        return Companion.getMetadataPath();
    }

    @JvmStatic
    @NotNull
    public static final byte[] writeIndexMetadata(@NotNull SharedIndexMetadata metadata) {
        return Companion.writeIndexMetadata(metadata);
    }

    @JvmStatic
    @Nullable
    public static final SharedIndexMetadata readSharedIndexMetadata(@NotNull Path chunkRoot) throws IOException {
        return Companion.readSharedIndexMetadata(chunkRoot);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005*\u0004\u0004\u0007\n\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001CB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0017H\u0007J\u001d\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001a0%H\u0082\bJ\u001e\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u001e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020'0*J\u0010\u0010+\u001a\u0004\u0018\u00010\u001e2\u0006\u0010,\u001a\u00020\u001cJ\u0010\u0010-\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020\u001cJ\u0012\u0010-\u001a\u0004\u0018\u00010 2\b\u0010.\u001a\u0004\u0018\u00010#J\u0010\u0010/\u001a\u00020#2\u0006\u0010.\u001a\u00020 H\u0007J\u000e\u00100\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001eJK\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H3\u0018\u000102\"\b\b\u0000\u00103*\u00020\u0001*\u00020\u001c2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H3052\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001207\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u00108J3\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u000102*\u00020\u001c2\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001207\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u00109J3\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020;\u0018\u000102*\u00020\u001c2\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001207\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u00109J(\u0010<\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010=\u001a\u00020\u00122\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020;0?H\u0002J@\u0010@\u001a\u00020\u001a\"\b\b\u0000\u00103*\u00020\u0001*\u00020\u001c2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H3052\u0006\u0010=\u001a\u00020\u00122\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H30?H\u0002J(\u0010@\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010=\u001a\u00020\u00122\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120?H\u0003J\u001a\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u000102*\u00020\u001cH\u0002J2\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H3\u0018\u000102\"\b\b\u0000\u00103*\u00020\u0001*\u00020\u001c2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H305H\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001c\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006D"}, d2={"Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion;", "", "()V", "BooleanValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$BooleanValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$BooleanValue$1;", "FiledBasedIndexInfoValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$FiledBasedIndexInfoValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$FiledBasedIndexInfoValue$1;", "IntValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$IntValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$IntValue$1;", "METADATA_DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getMETADATA_DATE_FORMAT", "()Ljava/time/format/DateTimeFormatter;", "METADATA_VERSION", "", "TextValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$TextValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$TextValue$1;", "getMetadataPath", "Ljava/nio/file/Path;", "chunkRootPath", "putIndexesVersion", "", "root", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "infrastructureVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "readSharedIndexMetadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "chunkRoot", "renderJson", "", "builder", "Lkotlin/Function1;", "selectBestSuitableIndex", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "ideVersion", "candidates", "", "tryReadInfrastructureVersionOnly", "node", "tryReadSharedIndexMetadata", "metadata", "writeIndexMetadata", "writeVersionInfo", "mapFromPath", "Ljava/util/SortedMap;", "Y", "loadValue", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$LoadSaveValue;", "path", "", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$LoadSaveValue;[Ljava/lang/String;)Ljava/util/SortedMap;", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;[Ljava/lang/String;)Ljava/util/SortedMap;", "mapIntFromPath", "", "putIntObjectFromMap", "name", "map", "", "putObjectFromMap", "saveValue", "toMap", "LoadSaveValue", "intellij.indexing.shared"})
    public static final class Companion {
        private final DateTimeFormatter getMETADATA_DATE_FORMAT() {
            return DateTimeFormatter.ISO_DATE_TIME.withLocale(Locale.US);
        }

        @Nullable
        public final SharedIndexInfrastructureVersion tryReadInfrastructureVersionOnly(@NotNull ObjectNode node) {
            Object object;
            SortedMap<String, String> hashProviderVersions;
            SortedMap<String, String> compositeBinaryStubFileBuilderVersions;
            SortedMap<String, String> stubFileElementTypeVersions;
            SortedMap<String, String> stubIndexVersions;
            SortedMap fileIndexVersions;
            SortedMap<String, String> baseVersions;
            Map caps;
            block21: {
                block20: {
                    boolean bl;
                    Object it$iv$iv;
                    Object object2;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    Object element$iv$iv;
                    Object element$iv$iv$iv;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Object object3;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    JsonNode jsonNode = node.get("indexes");
                    if (!(jsonNode instanceof ObjectNode)) {
                        jsonNode = null;
                    }
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    if (objectNode == null) {
                        return null;
                    }
                    ObjectNode indexesNode = objectNode;
                    boolean bl5 = false;
                    caps = new LinkedHashMap();
                    JsonNode jsonNode2 = indexesNode.get("capabilities");
                    if (!(jsonNode2 instanceof ObjectNode)) {
                        jsonNode2 = null;
                    }
                    ObjectNode objectNode2 = (ObjectNode)jsonNode2;
                    if (objectNode2 != null) {
                        ObjectNode objectNode3 = objectNode2;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        ObjectNode capabilitiesNode = objectNode3;
                        boolean bl8 = false;
                        Iterator iterator = capabilitiesNode.fieldNames();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"capabilitiesNode.fieldNames()");
                        Iterator iterator2 = iterator;
                        boolean bl9 = false;
                        object3 = iterator2;
                        while (object3.hasNext()) {
                            Object object4;
                            IndexInfrastructureCapability cap;
                            String capName = (String)object3.next();
                            if (IndexInfrastructureCapability.find(capName) == null) {
                                continue;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)cap, (String)"IndexInfrastructureCapab\u2026find(capName) ?: continue");
                            JsonNode jsonNode3 = capabilitiesNode.get(capName);
                            if (!(jsonNode3 instanceof ObjectNode)) {
                                jsonNode3 = null;
                            }
                            if ((object4 = (ObjectNode)jsonNode3) == null || (object4 = Companion.toMap((ObjectNode)object4)) == null) {
                                continue;
                            }
                            Object data = object4;
                            caps.put(cap, data);
                        }
                    }
                    SortedMap<String, String> sortedMap = this.mapFromPath(indexesNode, "base_versions");
                    if (sortedMap == null) {
                        return null;
                    }
                    baseVersions = sortedMap;
                    SortedMap sortedMap2 = this.mapFromPath(indexesNode, FiledBasedIndexInfoValue, "file_index_versions");
                    if (sortedMap2 == null) {
                        return null;
                    }
                    fileIndexVersions = sortedMap2;
                    SortedMap<String, String> sortedMap3 = this.mapFromPath(indexesNode, "stub_index_versions");
                    if (sortedMap3 == null) {
                        return null;
                    }
                    stubIndexVersions = sortedMap3;
                    SortedMap<String, String> sortedMap4 = this.mapFromPath(indexesNode, "stub_file_element_type_versions");
                    if (sortedMap4 == null) {
                        return null;
                    }
                    stubFileElementTypeVersions = sortedMap4;
                    SortedMap<String, String> sortedMap5 = this.mapFromPath(indexesNode, "composite_binary_stub_file_builder_versions");
                    if (sortedMap5 == null) {
                        return null;
                    }
                    compositeBinaryStubFileBuilderVersions = sortedMap5;
                    SortedMap<String, String> sortedMap6 = this.mapFromPath(indexesNode, "hash_provider_versions");
                    if (sortedMap6 == null) {
                        return null;
                    }
                    hashProviderVersions = sortedMap6;
                    JsonNode jsonNode4 = indexesNode.get("os");
                    if (!(jsonNode4 instanceof ArrayNode)) {
                        jsonNode4 = null;
                    }
                    if ((object = (ArrayNode)jsonNode4) == null) break block20;
                    object3 = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    void var13_22 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        JsonNode it = (JsonNode)element$iv$iv;
                        boolean bl10 = false;
                        if (it.asText() == null) continue;
                        bl3 = false;
                        bl2 = false;
                        it$iv$iv = object2;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    object = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
                    if (object == null) break block20;
                    $this$mapNotNull$iv = (Iterable)object;
                    $i$f$mapNotNull = false;
                    $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        String p1 = (String)element$iv$iv;
                        boolean bl11 = false;
                        if (IndexInfrastructureOs.find(p1) == null) continue;
                        bl3 = false;
                        bl2 = false;
                        it$iv$iv = object2;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    if (object != null) break block21;
                }
                boolean bl = false;
                object = SetsKt.emptySet();
            }
            Object osNames = object;
            return new SharedIndexInfrastructureVersion(caps, (Set<IndexInfrastructureOs>)osNames, (Map<String, String>)baseVersions, fileIndexVersions, (Map<String, String>)stubIndexVersions, (Map<String, String>)stubFileElementTypeVersions, (Map<String, String>)compositeBinaryStubFileBuilderVersions, (Map<String, String>)hashProviderVersions);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SharedIndexMetadata tryReadSharedIndexMetadata(@NotNull ObjectNode node) {
            Object object;
            Object object2;
            String string;
            String string2;
            String string3;
            Iterator iterator;
            Object object3;
            String string4;
            SharedIndexLineup lineup;
            ZonedDateTime generated;
            Object indexName;
            Object indexKind;
            block37: {
                block36: {
                    JsonNode jsonNode;
                    Object object4;
                    String string5;
                    String string6;
                    String string7;
                    List list;
                    boolean bl;
                    String it$iv$iv;
                    boolean bl2;
                    boolean bl3;
                    String string8;
                    JsonNode it;
                    boolean bl4;
                    Object element$iv$iv;
                    Object element$iv$iv$iv;
                    boolean $i$f$forEach;
                    Iterable $this$forEach$iv$iv$iv;
                    boolean $i$f$mapNotNullTo;
                    String string9;
                    ObjectNode sources;
                    block35: {
                        block34: {
                            Object object5;
                            block33: {
                                block32: {
                                    void $this$mapNotNullTo$iv$iv;
                                    void $this$mapNotNull$iv;
                                    SharedIndexLineup sharedIndexLineup;
                                    Object object6;
                                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                                    JsonNode jsonNode2 = node.get("metadata_version");
                                    if (Intrinsics.areEqual((Object)(jsonNode2 != null ? jsonNode2.asText() : null), (Object)SharedIndexMetadata.METADATA_VERSION) ^ true) {
                                        return null;
                                    }
                                    JsonNode jsonNode3 = node.get("sources");
                                    if (!(jsonNode3 instanceof ObjectNode)) {
                                        jsonNode3 = null;
                                    }
                                    ObjectNode objectNode = (ObjectNode)jsonNode3;
                                    if (objectNode == null) {
                                        return null;
                                    }
                                    sources = objectNode;
                                    Object object7 = sources.get("kind");
                                    if (object7 == null || (object7 = object7.asText()) == null) {
                                        return null;
                                    }
                                    indexKind = object7;
                                    Object object8 = sources.get("name");
                                    if (object8 == null || (object8 = object8.asText()) == null) {
                                        return null;
                                    }
                                    indexName = object8;
                                    Companion companion = this;
                                    boolean bl5 = false;
                                    try {
                                        object6 = Result.Companion;
                                        Object $this$runCatching = companion;
                                        boolean bl6 = false;
                                        Object object9 = sources.get("generated");
                                        if (object9 == null || (object9 = object9.asText()) == null) {
                                            return null;
                                        }
                                        $this$runCatching = ZonedDateTime.parse((CharSequence)object9, ((Companion)$this$runCatching).getMETADATA_DATE_FORMAT());
                                        bl6 = false;
                                        object6 = Result.constructor-impl((Object)$this$runCatching);
                                    }
                                    catch (Throwable $this$runCatching) {
                                        Result.Companion bl6 = Result.Companion;
                                        boolean bl7 = false;
                                        object6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
                                    }
                                    companion = object6;
                                    bl5 = false;
                                    boolean bl8 = false;
                                    Throwable throwable = Result.exceptionOrNull-impl((Object)companion);
                                    if (throwable != null) {
                                        Throwable it2 = throwable;
                                        boolean bl9 = false;
                                        return null;
                                    }
                                    generated = (ZonedDateTime)((Object)companion);
                                    JsonNode jsonNode4 = node.get("lineup");
                                    if (!(jsonNode4 instanceof ObjectNode)) {
                                        jsonNode4 = null;
                                    }
                                    ObjectNode objectNode2 = (ObjectNode)jsonNode4;
                                    if (objectNode2 != null) {
                                        ObjectNode objectNode3 = objectNode2;
                                        boolean bl10 = false;
                                        boolean it2 = false;
                                        ObjectNode it3 = objectNode3;
                                        boolean bl11 = false;
                                        sharedIndexLineup = SharedIndexLineup.Companion.tryReadLineup(it3);
                                    } else {
                                        sharedIndexLineup = null;
                                    }
                                    lineup = sharedIndexLineup;
                                    Object object10 = sources.get("jdk_hash");
                                    string4 = object10 != null && (object10 = object10.asText()) != null ? StringKt.nullize$default((String)object10, (boolean)false, (int)1, null) : null;
                                    JsonNode jsonNode5 = sources.get("jdk_aliases");
                                    if (!(jsonNode5 instanceof ArrayNode)) {
                                        jsonNode5 = null;
                                    }
                                    if ((object3 = (ArrayNode)jsonNode5) == null) break block32;
                                    Iterable iterable = (Iterable)object3;
                                    string9 = string4;
                                    boolean $i$f$mapNotNull = false;
                                    void it3 = $this$mapNotNull$iv;
                                    Collection destination$iv$iv = new ArrayList();
                                    $i$f$mapNotNullTo = false;
                                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                    $i$f$forEach = false;
                                    iterator = $this$forEach$iv$iv$iv.iterator();
                                    while (iterator.hasNext()) {
                                        element$iv$iv = element$iv$iv$iv = iterator.next();
                                        bl4 = false;
                                        it = (JsonNode)element$iv$iv;
                                        boolean bl12 = false;
                                        Object object11 = it;
                                        if ((object11 != null && (object11 = object11.asText()) != null ? StringKt.nullize$default((String)object11, (boolean)false, (int)1, null) : null) == null) continue;
                                        string8 = string8;
                                        bl3 = false;
                                        bl2 = false;
                                        it$iv$iv = string8;
                                        bl = false;
                                        destination$iv$iv.add(it$iv$iv);
                                    }
                                    list = (List)destination$iv$iv;
                                    string4 = string9;
                                    object3 = CollectionsKt.distinct((Iterable)list);
                                    if (object3 != null) break block33;
                                }
                                boolean $this$mapNotNull$iv = false;
                                object3 = CollectionsKt.emptyList();
                            }
                            string3 = (object5 = sources.get("project_id")) != null && (object5 = object5.asText()) != null ? StringKt.nullize$default((String)object5, (boolean)false, (int)1, null) : null;
                            Object object12 = sources.get("project_vcs_commit_id");
                            string2 = object12 != null && (object12 = object12.asText()) != null ? StringKt.nullize$default((String)object12, (boolean)false, (int)1, null) : null;
                            Object object13 = sources.get("maven_package");
                            string = object13 != null && (object13 = object13.asText()) != null ? StringKt.nullize$default((String)object13, (boolean)false, (int)1, null) : null;
                            JsonNode jsonNode6 = sources.get("maven_included_packages");
                            if (!(jsonNode6 instanceof ArrayNode)) {
                                jsonNode6 = null;
                            }
                            if ((object2 = (ArrayNode)jsonNode6) == null) break block34;
                            Iterable $this$mapNotNull$iv = (Iterable)object2;
                            string7 = string;
                            string6 = string2;
                            string5 = string3;
                            list = object3;
                            string9 = string4;
                            boolean $i$f$mapNotNull = false;
                            Iterable $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList();
                            $i$f$mapNotNullTo = false;
                            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            $i$f$forEach = false;
                            iterator = $this$forEach$iv$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                element$iv$iv = element$iv$iv$iv = iterator.next();
                                bl4 = false;
                                it = (JsonNode)element$iv$iv;
                                boolean bl13 = false;
                                Object object14 = it;
                                if ((object14 != null && (object14 = object14.asText()) != null ? StringKt.nullize$default((String)object14, (boolean)false, (int)1, null) : null) == null) continue;
                                string8 = string8;
                                bl3 = false;
                                bl2 = false;
                                it$iv$iv = string8;
                                bl = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            object4 = (List)destination$iv$iv;
                            string4 = string9;
                            object3 = list;
                            string3 = string5;
                            string2 = string6;
                            string = string7;
                            object2 = CollectionsKt.toSet((Iterable)((Iterable)object4));
                            if (object2 != null) break block35;
                        }
                        boolean $this$mapNotNull$iv = false;
                        object2 = SetsKt.emptySet();
                    }
                    if (!((jsonNode = sources.get("generic_jar_names")) instanceof ArrayNode)) {
                        jsonNode = null;
                    }
                    if ((object = (ArrayNode)jsonNode) == null) break block36;
                    Iterable $this$mapNotNull$iv = (Iterable)object;
                    object4 = object2;
                    string7 = string;
                    string6 = string2;
                    string5 = string3;
                    list = object3;
                    string9 = string4;
                    boolean $i$f$mapNotNull = false;
                    Iterable $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        it = (JsonNode)element$iv$iv;
                        boolean bl14 = false;
                        Object object15 = it;
                        if ((object15 != null && (object15 = object15.asText()) != null ? StringKt.nullize$default((String)object15, (boolean)false, (int)1, null) : null) == null) continue;
                        string8 = string8;
                        bl3 = false;
                        bl2 = false;
                        it$iv$iv = string8;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    string4 = string9;
                    object3 = list;
                    string3 = string5;
                    string2 = string6;
                    string = string7;
                    object2 = object4;
                    object = CollectionsKt.toSet((Iterable)list2);
                    if (object != null) break block37;
                }
                boolean $this$mapNotNull$iv = false;
                object = SetsKt.emptySet();
            }
            SharedIndexLineup $this$mapNotNull$iv = lineup;
            Object $i$f$mapNotNull = object;
            Object $this$mapNotNullTo$iv$iv = object2;
            String destination$iv$iv = string;
            String $i$f$mapNotNullTo = string2;
            String string10 = string3;
            Object object16 = object3;
            iterator = string4;
            SharedIndexLineup sharedIndexLineup = $this$mapNotNull$iv;
            Object object17 = $i$f$mapNotNull;
            Object object18 = $this$mapNotNullTo$iv$iv;
            String string11 = destination$iv$iv;
            String string12 = $i$f$mapNotNullTo;
            String string13 = string10;
            Iterator iterator2 = iterator;
            Object object19 = object16;
            SharedIndexMetadataInfo metadataInfo = new SharedIndexMetadataInfo((List<String>)object19, (String)((Object)iterator2), string13, string12, string11, (Set<String>)object18, (Set<String>)object17, sharedIndexLineup);
            JsonNode jsonNode = node.get("generation_statistics");
            if (!(jsonNode instanceof ObjectNode)) {
                jsonNode = null;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode == null) {
                return null;
            }
            ObjectNode nodeGenerationStatistics = objectNode;
            SortedMap<String, Integer> sortedMap = this.mapIntFromPath(nodeGenerationStatistics, "file_index_usages");
            if (sortedMap == null) {
                return null;
            }
            SortedMap<String, Integer> fileBasedIndexUsages = sortedMap;
            SortedMap<String, Integer> sortedMap2 = this.mapIntFromPath(nodeGenerationStatistics, "stub_file_element_type_usages");
            if (sortedMap2 == null) {
                return null;
            }
            SortedMap<String, Integer> stubFileElementTypeUsages = sortedMap2;
            SharedIndexGenerationStatistics generationStatistics = new SharedIndexGenerationStatistics(fileBasedIndexUsages, stubFileElementTypeUsages);
            SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = this.tryReadInfrastructureVersionOnly(node);
            if (sharedIndexInfrastructureVersion == null) {
                return null;
            }
            SharedIndexInfrastructureVersion indexVersions = sharedIndexInfrastructureVersion;
            ZonedDateTime zonedDateTime = generated;
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"generated");
            return new SharedIndexMetadata((String)indexName, (String)indexKind, indexVersions, metadataInfo, generationStatistics, zonedDateTime);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SharedIndexLookupResult selectBestSuitableIndex(@NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull List<SharedIndexLookupResult> candidates) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            Iterable $this$groupBy$iv = candidates;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                SharedIndexLookupResult it = (SharedIndexLookupResult)element$iv$iv;
                boolean bl = false;
                SharedIndexMetadata key$iv$iv = it.getSharedIndexMetadata();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map nodes = destination$iv$iv;
            SharedIndexMetadata sharedIndexMetadata = ideVersion.pickBestSuitableMetadata(nodes.keySet());
            if (sharedIndexMetadata == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sharedIndexMetadata, (String)"ideVersion.pickBestSuita\u2026odes.keys) ?: return null");
            SharedIndexMetadata best = sharedIndexMetadata;
            List list = (List)nodes.get(best);
            return list != null ? (SharedIndexLookupResult)CollectionsKt.firstOrNull((List)list) : null;
        }

        private final byte[] renderJson(Function1<? super ObjectNode, Unit> builder) {
            int $i$f$renderJson = 0;
            try {
                ObjectMapper om = new ObjectMapper();
                ObjectNode root = om.createObjectNode();
                root.put("metadata_version", SharedIndexMetadata.METADATA_VERSION);
                ObjectNode objectNode = root;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"root");
                builder.invoke((Object)objectNode);
                byte[] byArray = om.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"om.writerWithDefaultPret\u2026).writeValueAsBytes(root)");
                return byArray;
            }
            catch (Throwable t) {
                throw (Throwable)new RuntimeException("Failed to generate shared index metadata JSON. " + t.getMessage(), t);
            }
        }

        @JvmStatic
        @NotNull
        public final Path getMetadataPath(@NotNull Path chunkRootPath) {
            Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
            Path path = chunkRootPath.resolve(this.getMetadataPath());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"chunkRootPath.resolve(getMetadataPath())");
            return path;
        }

        @JvmStatic
        @NotNull
        public final String getMetadataPath() {
            return "metadata.json";
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final byte[] writeIndexMetadata(@NotNull SharedIndexMetadata metadata) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Companion this_$iv = this;
            boolean $i$f$renderJson = false;
            try {
                Object object;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                ObjectNode objectNode;
                ObjectNode objectNode2;
                ObjectNode objectNode3;
                Unit unit;
                boolean $i$f$forEach2;
                Iterable $this$forEach$iv2;
                IdeaPluginDescriptor it;
                Iterable $this$mapTo$iv$iv;
                Collection destination$iv$iv;
                boolean bl;
                boolean bl2;
                ArrayNode arrayNode;
                Object object2;
                ObjectNode objectNode4;
                Object it2;
                boolean bl3;
                boolean bl4;
                Object object3;
                ObjectMapper om$iv = new ObjectMapper();
                ObjectNode root$iv = om$iv.createObjectNode();
                root$iv.put("metadata_version", SharedIndexMetadata.METADATA_VERSION);
                ObjectNode objectNode5 = root$iv;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode5, (String)"root");
                ObjectNode root = objectNode5;
                boolean bl5 = false;
                SharedIndexMetadataInfo addon = metadata.getSharedIndexInfo();
                Object object4 = root.putObject("sources");
                boolean bl6 = false;
                boolean bl7 = false;
                ObjectNode sources = object4;
                boolean bl8 = false;
                sources.put("generated", metadata.getGenerationTime().format(Companion.getMETADATA_DATE_FORMAT()));
                IndexInfrastructureOs indexInfrastructureOs = IndexInfrastructureOs.getOs();
                Intrinsics.checkNotNullExpressionValue((Object)indexInfrastructureOs, (String)"IndexInfrastructureOs.getOs()");
                sources.put("os", indexInfrastructureOs.getOsName());
                sources.put("os_name", SystemInfo.getOsNameAndVersion());
                sources.put("kind", metadata.getIndexKind());
                sources.put("name", metadata.getIndexName());
                String string = addon.getJdkHash();
                if (string != null) {
                    object3 = string;
                    bl4 = false;
                    bl3 = false;
                    it2 = object3;
                    boolean bl9 = false;
                    objectNode4 = sources.put("jdk_hash", (String)it2);
                } else {
                    objectNode4 = null;
                }
                object3 = addon.getJdkAliases();
                bl4 = false;
                if (object3.isEmpty()) {
                    boolean bl10 = false;
                    object2 = null;
                } else {
                    object2 = object3;
                }
                List list = (List)object2;
                if (list != null) {
                    object3 = list;
                    bl4 = false;
                    bl3 = false;
                    Object aliases = object3;
                    boolean bl11 = false;
                    arrayNode = sources.putArray("jdk_aliases");
                    bl2 = false;
                    bl = false;
                    ArrayNode aliasesNode = arrayNode;
                    boolean bl12 = false;
                    Iterable $this$map$iv = (Iterable)aliases;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv$iv = iterator.next();
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl13 = false;
                        String string3 = it;
                        boolean bl14 = false;
                        void v6 = string3;
                        if (v6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = v6.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                        string3 = string4;
                        bl14 = false;
                        String string5 = string3;
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string6 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                        collection.add(string6);
                    }
                    $this$forEach$iv2 = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
                    $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        String it3 = (String)element$iv;
                        boolean bl15 = false;
                        aliasesNode.add(it3);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                String string7 = addon.getProjectId();
                if (string7 != null) {
                    object3 = string7;
                    bl4 = false;
                    bl3 = false;
                    it2 = object3;
                    boolean bl16 = false;
                    objectNode3 = sources.put("project_id", (String)it2);
                } else {
                    objectNode3 = null;
                }
                String string8 = addon.getProjectVcsCommitId();
                if (string8 != null) {
                    object3 = string8;
                    bl4 = false;
                    bl3 = false;
                    it2 = object3;
                    boolean bl17 = false;
                    objectNode2 = sources.put("project_vcs_commit_id", (String)it2);
                } else {
                    objectNode2 = null;
                }
                String string9 = addon.getMavenPackage();
                if (string9 != null) {
                    object3 = string9;
                    bl4 = false;
                    bl3 = false;
                    it2 = object3;
                    boolean bl18 = false;
                    objectNode = sources.put("maven_package", (String)it2);
                } else {
                    objectNode = null;
                }
                object3 = addon.getMavenIncludedPackages();
                bl4 = false;
                if (!object3.isEmpty()) {
                    object3 = sources.putArray("maven_included_packages");
                    bl4 = false;
                    bl3 = false;
                    it2 = object3;
                    boolean bl19 = false;
                    $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)addon.getMavenIncludedPackages());
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String pkg = (String)element$iv;
                        boolean bl20 = false;
                        it2.add(pkg);
                    }
                }
                object3 = addon.getGenericJarNames();
                bl4 = false;
                if (!object3.isEmpty()) {
                    object3 = sources.putArray("generic_jar_names");
                    bl4 = false;
                    bl3 = false;
                    it2 = object3;
                    boolean bl21 = false;
                    $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)addon.getGenericJarNames());
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String name = (String)element$iv;
                        boolean bl22 = false;
                        it2.add(name);
                    }
                }
                object4 = root.putObject("generation_statistics");
                bl6 = false;
                bl7 = false;
                ObjectNode statisticsNode = object4;
                boolean bl23 = false;
                ObjectNode objectNode6 = statisticsNode;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode6, (String)"statisticsNode");
                Companion.putIntObjectFromMap(objectNode6, "file_index_usages", (Map<String, Integer>)metadata.getGenerationStatistics().getFileBasedIndexUsages());
                Companion.putIntObjectFromMap(statisticsNode, "stub_file_element_type_usages", (Map<String, Integer>)metadata.getGenerationStatistics().getStubFileElementTypeUsages());
                SharedIndexLineup sharedIndexLineup = addon.getLineup();
                if (sharedIndexLineup != null) {
                    object4 = sharedIndexLineup;
                    bl6 = false;
                    bl7 = false;
                    Object it4 = object4;
                    boolean bl24 = false;
                    root.putObject("lineup").put("name", ((SharedIndexLineup)it4).getName()).put("creation_stamp", ((SharedIndexLineup)it4).getCreationStamp()).put("indexed_file_count", ((SharedIndexLineup)it4).getIndexedFileCount());
                    object = object4;
                } else {
                    object = null;
                }
                object4 = root.putObject("environment");
                bl6 = false;
                bl7 = false;
                Object build = object4;
                boolean bl25 = false;
                IndexInfrastructureOs indexInfrastructureOs2 = IndexInfrastructureOs.getOs();
                Intrinsics.checkNotNullExpressionValue((Object)indexInfrastructureOs2, (String)"IndexInfrastructureOs.getOs()");
                build.put("os", indexInfrastructureOs2.getOsName());
                build.put("os_name", SystemInfo.getOsNameAndVersion());
                object3 = build.putObject("intellij");
                bl4 = false;
                bl3 = false;
                Object ij = object3;
                boolean bl26 = false;
                ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                BuildNumber buildNumber = applicationInfo.getBuild();
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
                ij.put("product_code", buildNumber.getProductCode());
                ApplicationInfo applicationInfo2 = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo2, (String)"ApplicationInfo.getInstance()");
                ij.put("version", applicationInfo2.getFullVersion());
                ApplicationInfo applicationInfo3 = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo3, (String)"ApplicationInfo.getInstance()");
                ij.put("build", applicationInfo3.getBuild().toString());
                arrayNode = ij.putArray("non_bundled_plugins");
                bl2 = false;
                bl = false;
                ArrayNode it5 = arrayNode;
                boolean bl27 = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    MapsKt.mapOf((Pair)TuplesKt.to((Object)"somePlugin", (Object)"1.0"));
                } else {
                    Iterable $this$sortedBy$iv;
                    void $this$filterNotTo$iv$iv;
                    List list2 = PluginManagerCore.getLoadedPlugins();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"PluginManagerCore.getLoadedPlugins()");
                    Iterable $this$filterNot$iv = list2;
                    boolean $i$f$filterNot = false;
                    $this$mapTo$iv$iv = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        it = (IdeaPluginDescriptor)element$iv$iv;
                        boolean bl28 = false;
                        IdeaPluginDescriptor ideaPluginDescriptor = it;
                        Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"it");
                        if (ideaPluginDescriptor.isBundled()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterNot$iv = (List)destination$iv$iv;
                    boolean $i$f$sortedBy = false;
                    boolean bl29 = false;
                    $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            IdeaPluginDescriptor it = (IdeaPluginDescriptor)a;
                            boolean bl2 = false;
                            IdeaPluginDescriptor ideaPluginDescriptor = it;
                            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"it");
                            PluginId pluginId = ideaPluginDescriptor.getPluginId();
                            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"it.pluginId");
                            it = (IdeaPluginDescriptor)b;
                            Comparable comparable = (Comparable)((Object)pluginId.getIdString());
                            bl2 = false;
                            IdeaPluginDescriptor ideaPluginDescriptor2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor2, (String)"it");
                            PluginId pluginId2 = ideaPluginDescriptor2.getPluginId();
                            Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"it.pluginId");
                            String string = pluginId2.getIdString();
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                        }
                    });
                    $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        IdeaPluginDescriptor plugin = (IdeaPluginDescriptor)element$iv;
                        boolean bl30 = false;
                        ObjectNode objectNode7 = it5.addObject();
                        IdeaPluginDescriptor ideaPluginDescriptor = plugin;
                        Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"plugin");
                        PluginId pluginId = ideaPluginDescriptor.getPluginId();
                        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"plugin.pluginId");
                        objectNode7.put("id", pluginId.getIdString()).put("version", plugin.getVersion());
                    }
                }
                Companion.putIndexesVersion(root, metadata.getIndexInfrastructureVersion());
                byte[] byArray2 = om$iv.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root$iv);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"om.writerWithDefaultPret\u2026).writeValueAsBytes(root)");
            }
            catch (Throwable t$iv) {
                throw (Throwable)new RuntimeException("Failed to generate shared index metadata JSON. " + t$iv.getMessage(), t$iv);
            }
            return byArray;
        }

        @JvmStatic
        @Nullable
        public final SharedIndexMetadata readSharedIndexMetadata(@NotNull Path chunkRoot) throws IOException {
            Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
            Path metadataPath = this.getMetadataPath(chunkRoot);
            byte[] metadataBytes = Files.readAllBytes(metadataPath);
            return this.tryReadSharedIndexMetadata(metadataBytes);
        }

        @Nullable
        public final SharedIndexMetadata tryReadSharedIndexMetadata(@Nullable byte[] metadata) {
            if (metadata == null) {
                return null;
            }
            ObjectMapper om = new ObjectMapper();
            JsonNode jsonNode = om.readTree(metadata);
            if (!(jsonNode instanceof ObjectNode)) {
                jsonNode = null;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode == null) {
                return null;
            }
            ObjectNode root = objectNode;
            return this.tryReadSharedIndexMetadata(root);
        }

        @NotNull
        public final byte[] writeVersionInfo(@NotNull SharedIndexInfrastructureVersion infrastructureVersion) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)((Object)infrastructureVersion), (String)"infrastructureVersion");
            Companion this_$iv = this;
            boolean $i$f$renderJson = false;
            try {
                ObjectMapper om$iv = new ObjectMapper();
                ObjectNode root$iv = om$iv.createObjectNode();
                root$iv.put("metadata_version", SharedIndexMetadata.METADATA_VERSION);
                ObjectNode objectNode = root$iv;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"root");
                ObjectNode root = objectNode;
                boolean bl = false;
                Companion.putIndexesVersion(root, infrastructureVersion);
                byte[] byArray2 = om$iv.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root$iv);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"om.writerWithDefaultPret\u2026).writeValueAsBytes(root)");
            }
            catch (Throwable t$iv) {
                throw (Throwable)new RuntimeException("Failed to generate shared index metadata JSON. " + t$iv.getMessage(), t$iv);
            }
            return byArray;
        }

        /*
         * WARNING - void declaration
         */
        private final void putIndexesVersion(ObjectNode root, SharedIndexInfrastructureVersion infrastructureVersion) {
            void $this$mapTo$iv$iv;
            Iterator iterator;
            boolean bl;
            ObjectNode objectNode = root.putObject("indexes");
            boolean bl2 = false;
            boolean bl3 = false;
            ObjectNode indexes = objectNode;
            boolean bl4 = false;
            indexes.put("weak_hash", infrastructureVersion.getWeakVersionHash());
            indexes.put("weak_base_hash", infrastructureVersion.getWeakBaseVersionHash());
            ObjectNode objectNode2 = infrastructureVersion.getCapabilities();
            Intrinsics.checkNotNullExpressionValue(objectNode2, (String)"infrastructureVersion.capabilities");
            ObjectNode objectNode3 = objectNode2;
            boolean bl5 = false;
            if (!objectNode3.isEmpty()) {
                objectNode3 = indexes.putObject("capabilities");
                bl5 = false;
                bl = false;
                ObjectNode caps = objectNode3;
                boolean bl6 = false;
                Map<IndexInfrastructureCapability, Map<String, String>> map = infrastructureVersion.getCapabilities();
                Intrinsics.checkNotNullExpressionValue(map, (String)"infrastructureVersion.capabilities");
                Object object = map;
                boolean bl7 = false;
                iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    void cap;
                    Map.Entry entry;
                    Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                    boolean bl8 = false;
                    object = (IndexInfrastructureCapability)entry2.getKey();
                    entry2 = entry;
                    bl8 = false;
                    Map versions = (Map)entry2.getValue();
                    ObjectNode objectNode4 = caps;
                    Intrinsics.checkNotNullExpressionValue((Object)objectNode4, (String)"caps");
                    void v3 = cap;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"cap");
                    String string = v3.getCapabilityName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cap.capabilityName");
                    Map map2 = versions;
                    Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"versions");
                    Companion.putObjectFromMap(objectNode4, string, map2);
                }
            }
            objectNode3 = indexes.putArray("os");
            bl5 = false;
            bl = false;
            ObjectNode os = objectNode3;
            boolean bl9 = false;
            Set<IndexInfrastructureOs> set = infrastructureVersion.getSupportedOs();
            Intrinsics.checkNotNullExpressionValue(set, (String)"infrastructureVersion.supportedOs");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IndexInfrastructureOs indexInfrastructureOs = (IndexInfrastructureOs)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl10 = false;
                void v7 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
                String string = v7.getOsName();
                collection.add(string);
            }
            Iterable $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl11 = false;
                os.add(it);
            }
            ObjectNode objectNode5 = indexes;
            Intrinsics.checkNotNullExpressionValue((Object)objectNode5, (String)"indexes");
            Map<String, String> map = infrastructureVersion.getBaseIndexes();
            Intrinsics.checkNotNullExpressionValue(map, (String)"infrastructureVersion.baseIndexes");
            Companion.putObjectFromMap(objectNode5, "base_versions", map);
            LoadSaveValue loadSaveValue = FiledBasedIndexInfoValue;
            Map<String, FileBasedIndexVersionInfo> map3 = infrastructureVersion.getFileBasedIndexVersionInfos();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"infrastructureVersion.fileBasedIndexVersionInfos");
            Companion.putObjectFromMap(indexes, loadSaveValue, "file_index_versions", map3);
            Map<String, String> map4 = infrastructureVersion.getStubIndexVersions();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"infrastructureVersion.stubIndexVersions");
            Companion.putObjectFromMap(indexes, "stub_index_versions", map4);
            Map<String, String> map5 = infrastructureVersion.getStubFileElementTypeVersions();
            Intrinsics.checkNotNullExpressionValue(map5, (String)"infrastructureVersion.stubFileElementTypeVersions");
            Companion.putObjectFromMap(indexes, "stub_file_element_type_versions", map5);
            SortedMap<String, String> sortedMap = infrastructureVersion.getCompositeBinaryStubFileBuilderVersions();
            Intrinsics.checkNotNullExpressionValue(sortedMap, (String)"infrastructureVersion.co\u2026ryStubFileBuilderVersions");
            Companion.putObjectFromMap(indexes, "composite_binary_stub_file_builder_versions", (Map<String, String>)sortedMap);
            Map<String, String> map6 = infrastructureVersion.getHashProviderVersions();
            Intrinsics.checkNotNullExpressionValue(map6, (String)"infrastructureVersion.hashProviderVersions");
            Companion.putObjectFromMap(indexes, "hash_provider_versions", map6);
        }

        @JvmName(name="putObjectFromMap")
        private final void putObjectFromMap(ObjectNode $this$putObjectFromMap, String name, Map<String, String> map) {
            this.putObjectFromMap($this$putObjectFromMap, TextValue, name, map);
        }

        private final void putIntObjectFromMap(ObjectNode $this$putIntObjectFromMap, String name, Map<String, Integer> map) {
            this.putObjectFromMap($this$putIntObjectFromMap, IntValue, name, map);
        }

        /*
         * WARNING - void declaration
         */
        private final <Y> void putObjectFromMap(ObjectNode $this$putObjectFromMap, LoadSaveValue<Y> saveValue, String name, Map<String, ? extends Y> map) {
            void $this$forEach$iv;
            ObjectNode objectNode = $this$putObjectFromMap.putObject(name);
            boolean bl = false;
            boolean bl2 = false;
            ObjectNode obj = objectNode;
            boolean bl3 = false;
            Iterable $this$sortedBy$iv = map.entrySet();
            boolean $i$f$sortedBy = false;
            boolean bl4 = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)a;
                    boolean bl2 = false;
                    String string = (String)it.getKey();
                    boolean bl3 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    it = (Map.Entry)b;
                    Comparable comparable = (Comparable)((Object)string3);
                    bl2 = false;
                    string = (String)it.getKey();
                    bl3 = false;
                    String string4 = string;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                    String string6 = string5;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string6)));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void k;
                Map.Entry $dstr$k$v = (Map.Entry)element$iv;
                boolean bl5 = false;
                Map.Entry entry = $dstr$k$v;
                boolean bl6 = false;
                String string = (String)entry.getKey();
                entry = $dstr$k$v;
                bl6 = false;
                Object v = entry.getValue();
                ObjectNode objectNode2 = obj;
                Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"obj");
                saveValue.saveValue(objectNode2, (String)k, v);
            }
        }

        private final SortedMap<String, String> mapFromPath(ObjectNode $this$mapFromPath, String ... path) {
            return this.mapFromPath($this$mapFromPath, TextValue, Arrays.copyOf(path, path.length));
        }

        private final SortedMap<String, Integer> mapIntFromPath(ObjectNode $this$mapIntFromPath, String ... path) {
            return this.mapFromPath($this$mapIntFromPath, IntValue, Arrays.copyOf(path, path.length));
        }

        private final SortedMap<String, String> toMap(ObjectNode $this$toMap) {
            return this.toMap($this$toMap, TextValue);
        }

        private final <Y> SortedMap<String, Y> mapFromPath(ObjectNode $this$mapFromPath, LoadSaveValue<Y> loadValue, String ... path) {
            String[] stringArray = path;
            boolean bl = false;
            if (stringArray.length == 0) {
                return this.toMap($this$mapFromPath, loadValue);
            }
            String first = (String)ArraysKt.first((Object[])path);
            JsonNode jsonNode = $this$mapFromPath.get(first);
            if (!(jsonNode instanceof ObjectNode)) {
                jsonNode = null;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode == null) {
                return null;
            }
            ObjectNode child = objectNode;
            Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])path, (int)1);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return this.mapFromPath(child, loadValue, Arrays.copyOf(stringArray2, stringArray2.length));
        }

        private final <Y> SortedMap<String, Y> toMap(ObjectNode $this$toMap, LoadSaveValue<Y> loadValue) {
            HashMap result2 = new HashMap();
            Iterator iterator = $this$toMap.fieldNames();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"this.fieldNames()");
            Iterator iterator2 = iterator;
            boolean bl = false;
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Y value;
                String key = (String)iterator3.next();
                if (loadValue.loadValue($this$toMap.get(key)) == null) {
                    return null;
                }
                Map map = result2;
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                map.put(string, value);
            }
            return (SortedMap)ImmutableSortedMap.copyOf((Map)result2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bb\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00018\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a2\u0006\u0002\u0010\u0006J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$LoadSaveValue;", "Y", "", "loadValue", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Object;", "saveValue", "", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "key", "", "value", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/lang/String;Ljava/lang/Object;)V", "intellij.indexing.shared"})
        private static interface LoadSaveValue<Y> {
            @Nullable
            public Y loadValue(@Nullable JsonNode var1);

            public void saveValue(@NotNull ObjectNode var1, @NotNull String var2, @NotNull Y var3);
        }
    }
}

