/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.intellij.indexing.shared.download.DownloadTaskContext;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecision;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecisionKey;
import com.intellij.indexing.shared.download.IndexDownloadConsentService;
import com.intellij.indexing.shared.download.SharedIndexAuthLifetimeHolder;
import com.intellij.indexing.shared.download.SharedIndexConsentStoreKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtension;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtensionKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadConsentStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadExecutor;
import com.intellij.indexing.shared.download.SharedIndexDownloadHistoryStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadInfo;
import com.intellij.indexing.shared.download.SharedIndexDownloadNotifications;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.SharedIndexDownloadServiceKt;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.download.SharedIndexLookupResultKt;
import com.intellij.indexing.shared.download.SharedIndexPerProjectTaskExpiration;
import com.intellij.indexing.shared.download.SharedIndexSuggester;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.download.SharedIndexSuggestionKt;
import com.intellij.indexing.shared.download.SharedIndexSuggestionService;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.ChunkDescriptor;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.ChunkStorageOption;
import com.intellij.indexing.shared.platform.impl.DownloadIndexResult;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorForCollections;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J0\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u00140\u00112\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ4\u0010\u001d\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u00140\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ<\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110!2\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u00140\u0011H\u0002J0\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\b\b\u0002\u0010&\u001a\u00020'H\u0007J\u0006\u0010(\u001a\u00020\rJ$\u0010)\u001a\u00020\r*\u00020*2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J8\u0010,\u001a\u00020\r*\u00020*2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110!H\u0002J\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00120%H\u0002J$\u0010.\u001a\u00020\r*\u00020*2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadService;", "", "()V", "executor", "Lcom/intellij/indexing/shared/download/SharedIndexDownloadExecutor;", "getExecutor", "()Lcom/intellij/indexing/shared/download/SharedIndexDownloadExecutor;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "rescanningCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "applySuggestions", "", "project", "Lcom/intellij/openapi/project/Project;", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "collectRequests", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "collectSuggestionsSuitableForDownload", "getConsentDecision", "Lcom/intellij/indexing/shared/download/IndexDownloadConsentDecision;", "suggestionKind", "", "initiateAuthIfNeeded", "requests", "rescanNow", "resolveIndexes", "", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "suggestIndexes", "encodedSuggestions", "", "enableConsent", "", "waitRescanningCalmDown", "doDownloadSharedIndexes", "Lcom/intellij/indexing/shared/download/DownloadTaskContext;", "actualSuggestions", "downloadAndInstallIndexes", "mergeSameSuggestions", "processSuggestions", "LookupChunkDescriptor", "intellij.indexing.shared"})
public final class SharedIndexDownloadService {
    private final Logger log;
    private final AtomicInteger rescanningCounter;

    private final SharedIndexDownloadExecutor getExecutor() {
        boolean $i$f$service = false;
        Class<SharedIndexDownloadExecutor> serviceClass$iv = SharedIndexDownloadExecutor.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        return (SharedIndexDownloadExecutor)object;
    }

    public final void waitRescanningCalmDown() {
        int checkFrequencyInSec = SystemProperties.getIntProperty((String)"shared.index.check.frequency", (int)-1);
        int waitLimitInSec = SystemProperties.getIntProperty((String)"shared.index.wait.limit", (int)-1);
        int lastRescanningCount = -1;
        if (waitLimitInSec == -1 || checkFrequencyInSec == -1) {
            return;
        }
        long globalStart = System.nanoTime();
        do {
            int currentRescanningCount;
            if (lastRescanningCount == (currentRescanningCount = this.rescanningCounter.get())) {
                return;
            }
            lastRescanningCount = currentRescanningCount;
            long start = System.nanoTime();
            ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable)new ThrowableComputable(start, checkFrequencyInSec){
                final /* synthetic */ long $start;
                final /* synthetic */ int $checkFrequencyInSec;

                public final Boolean compute() {
                    return System.nanoTime() - this.$start > TimeUnit.SECONDS.toNanos(this.$checkFrequencyInSec);
                }
                {
                    this.$start = l;
                    this.$checkFrequencyInSec = n;
                }
            });
        } while (System.nanoTime() - globalStart <= TimeUnit.SECONDS.toNanos(waitLimitInSec));
        throw (Throwable)new Error("Rescanning calm down waiting limit (" + waitLimitInSec + " secs) exceeded");
    }

    public final void rescanNow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!SharedIndexDownloadServiceKt.access$isEnabled()) {
            return;
        }
        this.log.debug("Rescan");
        this.rescanningCounter.incrementAndGet();
        SharedIndexPerProjectTaskExpiration.Token expiration = SharedIndexPerProjectTaskExpiration.Companion.registerNewTask(project);
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)new Function1<DownloadTaskContext, Unit>(this, expiration, project){
            final /* synthetic */ SharedIndexDownloadService this$0;
            final /* synthetic */ SharedIndexPerProjectTaskExpiration.Token $expiration;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DownloadTaskContext $this$submitPreProgressSync) {
                boolean $i$f$service;
                List list;
                SharedIndexDownloadService sharedIndexDownloadService;
                Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$receiver");
                if (this.$expiration.isExpired()) {
                    SharedIndexDownloadService.access$getLog$p(this.this$0).debug("Expired");
                    return;
                }
                SharedIndexDownloadService sharedIndexDownloadService2 = this.this$0;
                try {
                    sharedIndexDownloadService = sharedIndexDownloadService2;
                    list = SharedIndexDownloadService.access$collectSuggestionsSuitableForDownload(this.this$0, this.$project);
                }
                catch (Throwable throwable) {
                    void t;
                    SharedIndexDownloadService sharedIndexDownloadService3 = sharedIndexDownloadService2;
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    SharedIndexDownloadService.access$getLog$p(this.this$0).warn("Failed to collect suggested shared indexes. " + t.getMessage(), (Throwable)t);
                    return;
                }
                List suggestions = SharedIndexDownloadService.access$mergeSameSuggestions(sharedIndexDownloadService, list);
                SharedIndexDownloadService.access$getLog$p(this.this$0).trace("All project suggestions: [" + suggestions + ']');
                if (suggestions.isEmpty()) {
                    return;
                }
                if (!ProjectUtil.isNotificationSilentMode((Project)this.$project)) {
                    Project $this$service$iv = this.$project;
                    $i$f$service = false;
                    Object object = $this$service$iv.getService(IndexDownloadConsentService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                    ((IndexDownloadConsentService)object).askForMoreDownloads(suggestions, this.$project);
                }
                $i$f$service = false;
                Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                List<SharedIndexSuggestion> allowedSuggestions = ((SharedIndexDownloadConsentStore)((Object)object)).filterAllowed(suggestions, this.$project);
                if (allowedSuggestions.isEmpty()) {
                    SharedIndexDownloadService.access$getLog$p(this.this$0).debug("All suggestions are not allowed");
                    return;
                }
                SharedIndexDownloadService.access$getLog$p(this.this$0).debug("Allowed suggestion: [" + suggestions + ']');
                $this$submitPreProgressSync.queueChildTask((Function0<Unit>)((Function0)new Function0<Unit>(this, allowedSuggestions){
                    final /* synthetic */ rescanNow.1 this$0;
                    final /* synthetic */ List $allowedSuggestions;

                    public final void invoke() {
                        this.this$0.this$0.applySuggestions(this.this$0.$project, this.$allowedSuggestions);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$allowedSuggestions = list;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = sharedIndexDownloadService;
                this.$expiration = token;
                this.$project = project;
                super(1);
            }
        }));
    }

    public final void applySuggestions(@Nullable Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions) {
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        if (!SharedIndexDownloadServiceKt.access$isEnabled() || suggestions.isEmpty()) {
            return;
        }
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)new Function1<DownloadTaskContext, Unit>(this, project, suggestions){
            final /* synthetic */ SharedIndexDownloadService this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $suggestions;

            public final void invoke(@NotNull DownloadTaskContext $this$submitPreProgressSync) {
                Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$receiver");
                SharedIndexDownloadService.access$doDownloadSharedIndexes(this.this$0, $this$submitPreProgressSync, this.$project, SharedIndexDownloadService.access$mergeSameSuggestions(this.this$0, this.$suggestions));
            }
            {
                this.this$0 = sharedIndexDownloadService;
                this.$project = project;
                this.$suggestions = list;
                super(1);
            }
        }));
    }

    @Nullable
    public final IndexDownloadConsentDecision getConsentDecision(@NotNull String suggestionKind) {
        IndexDownloadConsentDecision indexDownloadConsentDecision;
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        block4: {
            Intrinsics.checkNotNullParameter((Object)suggestionKind, (String)"suggestionKind");
            Object[] objectArray = SharedIndexSuggestionKt.getSharedIndexSuggesterEP().getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"sharedIndexSuggesterEP.extensions");
            object3 = objectArray;
            bl = false;
            Object[] objectArray2 = object3;
            boolean bl2 = false;
            for (Object object4 : objectArray2) {
                SharedIndexSuggester it = (SharedIndexSuggester)object4;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getKind(), (Object)suggestionKind)) continue;
                object2 = object4;
                break block4;
            }
            object2 = null;
        }
        if ((object = (SharedIndexSuggester)object2) != null && (object = object.getConsentKey()) != null) {
            object3 = object;
            bl = false;
            boolean bl4 = false;
            Object it = object3;
            boolean bl5 = false;
            boolean $i$f$service = false;
            Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
            Object object5 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object5 == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            indexDownloadConsentDecision = ((SharedIndexDownloadConsentStore)((Object)object5)).decisionFor((IndexDownloadConsentDecisionKey)it, null);
        } else {
            indexDownloadConsentDecision = null;
        }
        return indexDownloadConsentDecision;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    @JvmOverloads
    public final void suggestIndexes(@NotNull Project project, @NotNull String suggestionKind, @NotNull Collection<String> encodedSuggestions, boolean enableConsent) {
        void $this$flatMapTo$iv$iv;
        Collection $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestionKind, (String)"suggestionKind");
        Intrinsics.checkNotNullParameter(encodedSuggestions, (String)"encodedSuggestions");
        Object[] objectArray = SharedIndexSuggestionKt.getSharedIndexSuggesterEP().getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"sharedIndexSuggesterEP\n      .extensions");
        Object[] objectArray2 = objectArray;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            SharedIndexSuggester it = (SharedIndexSuggester)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)suggestionKind)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SharedIndexSuggester it = (SharedIndexSuggester)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.decodeSuggestions(project, encodedSuggestions);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List suggestions = (List)destination$iv$iv;
        $this$flatMap$iv = suggestions;
        $i$f$flatMap = false;
        if (!$this$flatMap$iv.isEmpty()) {
            this.log.info("Got suggestion to download shared indexes of type '" + suggestionKind + "' for " + CollectionsKt.joinToString$default((Iterable)encodedSuggestions, null, null, null, (int)0, null, null, (int)63, null) + '.');
            if (enableConsent) {
                boolean $i$f$service = false;
                Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                SharedIndexDownloadConsentStore consentStore = (SharedIndexDownloadConsentStore)((Object)object);
                for (SharedIndexSuggestion suggestion : suggestions) {
                    IndexDownloadConsentDecisionKey key = SharedIndexConsentStoreKt.toKey(suggestion);
                    if (consentStore.decisionFor(key, project) == IndexDownloadConsentDecision.DENIED) continue;
                    consentStore.setDecisionFor(key, IndexDownloadConsentDecision.ALLOWED);
                }
            }
            this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)new Function1<DownloadTaskContext, Unit>(this, suggestions, project){
                final /* synthetic */ SharedIndexDownloadService this$0;
                final /* synthetic */ List $suggestions;
                final /* synthetic */ Project $project;

                public final void invoke(@NotNull DownloadTaskContext $this$submitPreProgressSync) {
                    Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$receiver");
                    $this$submitPreProgressSync.queueChildTask((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ suggestIndexes.1 this$0;

                        public final void invoke() {
                            boolean $i$f$service = false;
                            Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
                            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                            if (object == null) {
                                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                            }
                            List<SharedIndexSuggestion> actualSuggestions = ((SharedIndexDownloadConsentStore)((Object)object)).filterAllowed(this.this$0.$suggestions, this.this$0.$project);
                            Collection collection = actualSuggestions;
                            boolean bl = false;
                            if (!collection.isEmpty()) {
                                this.this$0.this$0.applySuggestions(this.this$0.$project, actualSuggestions);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = sharedIndexDownloadService;
                    this.$suggestions = list;
                    this.$project = project;
                    super(1);
                }
            }));
        }
    }

    public static /* synthetic */ void suggestIndexes$default(SharedIndexDownloadService sharedIndexDownloadService, Project project, String string, Collection collection, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        sharedIndexDownloadService.suggestIndexes(project, string, collection, bl);
    }

    @ApiStatus.Experimental
    @JvmOverloads
    public final void suggestIndexes(@NotNull Project project, @NotNull String suggestionKind, @NotNull Collection<String> encodedSuggestions) {
        SharedIndexDownloadService.suggestIndexes$default(this, project, suggestionKind, encodedSuggestions, false, 8, null);
    }

    private final void doDownloadSharedIndexes(DownloadTaskContext $this$doDownloadSharedIndexes, Project project, List<? extends SharedIndexSuggestion> actualSuggestions) {
        this.processSuggestions($this$doDownloadSharedIndexes, project, actualSuggestions);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SharedIndexSuggestion> mergeSameSuggestions(Collection<? extends SharedIndexSuggestion> $this$mergeSameSuggestions) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = $this$mergeSameSuggestions;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            SharedIndexId sharedIndexId = it.getSharedIndexId();
            map.put(sharedIndexId, element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }

    /*
     * WARNING - void declaration
     */
    private final List<SharedIndexSuggestion> collectSuggestionsSuitableForDownload(Project project) {
        List list;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable $this$service$iv;
        boolean $i$f$service = false;
        Project serviceClass$iv = SharedIndexDownloadHistoryStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        SharedIndexDownloadHistoryStore history = (SharedIndexDownloadHistoryStore)((Object)object);
        serviceClass$iv = project;
        boolean $i$f$service2 = false;
        Object object2 = $this$service$iv.getService(SharedIndexSuggestionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
        $this$service$iv = ((SharedIndexSuggestionService)object2).resolveSuggestions();
        boolean $i$f$groupBy = false;
        void var6_8 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            SharedIndexSuggestion it = (SharedIndexSuggestion)element$iv$iv;
            boolean bl = false;
            Boolean key$iv$iv = SharedIndexDownloadHistoryStore.isDownloadMakeSenseFor$default(history, it.getSharedIndexId(), false, 2, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        Map allSuggestions = destination$iv$iv;
        List list2 = (List)allSuggestions.get(false);
        if (list2 != null) {
            List list3 = list2;
            boolean bl = false;
            boolean bl3 = false;
            List it = list3;
            boolean bl4 = false;
            String message = "There is no need to download shared indexes for " + CollectionsKt.joinToString$default((Iterable)it, null, null, null, (int)0, null, null, (int)63, null) + ". Similar compatible shared indexes are available locally.";
            if (this.log.isDebugEnabled()) {
                this.log.debug(message);
            } else {
                this.log.info(StringUtil.first((String)message, (int)300, (boolean)true));
            }
        }
        if ((list = (List)allSuggestions.get(true)) == null) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void processSuggestions(DownloadTaskContext $this$processSuggestions, Project project, List<? extends SharedIndexSuggestion> suggestions) {
        List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> requests = this.collectRequests($this$processSuggestions.getIndicator(), suggestions);
        if (requests.isEmpty()) {
            return;
        }
        this.initiateAuthIfNeeded(project, requests, $this$processSuggestions.getIndicator());
        Map<SharedIndexLookupResult, List<SharedIndexSuggestion>> indexes = this.resolveIndexes($this$processSuggestions.getIndicator(), requests);
        if (indexes.isEmpty()) {
            return;
        }
        $this$processSuggestions.showBackgroundableProgress();
        this.downloadAndInstallIndexes($this$processSuggestions, project, $this$processSuggestions.getIndicator(), indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> collectRequests(ProgressIndicator indicator, List<? extends SharedIndexSuggestion> suggestions) {
        indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.requests", new Object[0]));
        Collection $this$mapWithProgress$iv = suggestions;
        boolean $i$f$mapWithProgress = false;
        indicator.checkCanceled();
        boolean bl = false;
        List result$iv = new ArrayList();
        Collection $this$forEachWithProgress$iv$iv = $this$mapWithProgress$iv;
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv$iv = $this$withPushPop$iv$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv$iv.pushState();
        try {
            boolean bl2 = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv$iv = $this$forEachWithProgress$iv$iv.size();
            boolean bl3 = false;
            for (Object y$iv$iv : (Iterable)$this$forEachWithProgress$iv$iv) {
                Pair pair;
                Collection collection;
                String prevText2$iv$iv;
                String prevText$iv$iv;
                void i$iv$iv;
                block8: {
                    Pair pair2;
                    void it$iv;
                    indicator.checkCanceled();
                    double lowerBound$iv$iv = (double)i$iv$iv / size$iv$iv;
                    double upperBound$iv$iv = (double)(i$iv$iv + true) / size$iv$iv;
                    indicator.setFraction(lowerBound$iv$iv);
                    prevText$iv$iv = indicator.getText();
                    prevText2$iv$iv = indicator.getText2();
                    ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv$iv, (double)upperBound$iv$iv);
                    Object y$iv = y$iv$iv;
                    boolean bl4 = false;
                    collection = result$iv;
                    void var27_27 = it$iv;
                    SharedIndexSuggestion it = (SharedIndexSuggestion)y$iv;
                    boolean bl5 = false;
                    try {
                        void subIndicator;
                        SharedIndexLookupRequest request = it.resolveRequest((ProgressIndicator)subIndicator);
                        if (request == null) {
                            pair = null;
                            break block8;
                        }
                        pair2 = TuplesKt.to((Object)it, (Object)request);
                    }
                    catch (Throwable e) {
                        if (e instanceof ControlFlowException) {
                            throw e;
                        }
                        this.log.warn("Failed to create for shared index request for " + it + ". " + e.getMessage(), e);
                        pair2 = null;
                    }
                    pair = pair2;
                }
                Pair pair3 = pair;
                boolean bl6 = false;
                collection.add(pair3);
                indicator.setText(prevText$iv$iv);
                indicator.setText2(prevText2$iv$iv);
                ++i$iv$iv;
            }
            indicator.setFraction(1.0);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv$iv$iv.setIndeterminate(wasIndeterminate$iv$iv$iv);
            $this$withPushPop$iv$iv$iv.popState();
        }
        indicator.checkCanceled();
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.toList((Iterable)result$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void initiateAuthIfNeeded(Project project, List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>> requests, ProgressIndicator indicator) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Pair it$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        indicator.checkCanceled();
        Iterable iterable = requests;
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            SharedIndexDownloadAuthExtension auth;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((SharedIndexDownloadAuthExtensionKt.resolveIndexDownloadAuthExtension(((SharedIndexLookupRequest)it.getSecond()).getAuthId()) == null ? null : TuplesKt.to((Object)auth, (Object)it.getFirst())) == null) continue;
            pair = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-SharedIndexDownloadService$initiateAuthIfNeeded$auths$42 = false;
            SharedIndexDownloadAuthExtension key$iv$iv = (SharedIndexDownloadAuthExtension)it2.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-SharedIndexDownloadService$initiateAuthIfNeeded$auths$42 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)it.getSecond();
            list.add(sharedIndexSuggestion);
        }
        Object auths = destination$iv$iv;
        if (auths.isEmpty()) {
            return;
        }
        indicator.setText(SharedIndexesBundle.message("progress.text.auth", new Object[0]));
        Collection $this$forEachWithProgress$iv = auths.entrySet();
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv.pushState();
        try {
            boolean bl = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv = $this$forEachWithProgress$iv.size();
            boolean it = false;
            for (Object y$iv : (Iterable)$this$forEachWithProgress$iv) {
                void auth;
                void i$iv;
                indicator.checkCanceled();
                double lowerBound$iv = (double)i$iv / size$iv;
                double upperBound$iv = (double)(i$iv + true) / size$iv;
                indicator.setFraction(lowerBound$iv);
                String prevText$iv = indicator.getText();
                String prevText2$iv = indicator.getText2();
                it$iv$iv = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv, (double)upperBound$iv);
                Map.Entry $dstr$auth$suggestions = (Map.Entry)y$iv;
                boolean bl6 = false;
                Map.Entry entry = $dstr$auth$suggestions;
                boolean bl7 = false;
                SharedIndexDownloadAuthExtension sharedIndexDownloadAuthExtension = (SharedIndexDownloadAuthExtension)entry.getKey();
                entry = $dstr$auth$suggestions;
                bl7 = false;
                List suggestions = (List)entry.getValue();
                try {
                    void subProgress;
                    subProgress.setText2(auth.getPresentableName());
                    String string = SharedIndexesBundle.message("auth.presentable.text", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedIndexesBundle.mess\u2026(\"auth.presentable.text\")");
                    auth.checkAuthenticated(string, suggestions, (ProgressIndicator)subProgress, SharedIndexAuthLifetimeHolder.Companion.getNextDisposable(project), (Function0<Unit>)((Function0)new Function0<Unit>(suggestions, this, project){
                        final /* synthetic */ List $suggestions;
                        final /* synthetic */ SharedIndexDownloadService this$0;
                        final /* synthetic */ Project $project$inlined;
                        {
                            this.$suggestions = list;
                            this.this$0 = sharedIndexDownloadService;
                            this.$project$inlined = project;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.applySuggestions(this.$project$inlined, this.$suggestions);
                        }
                    }));
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    this.log.warn("Failed to check for authentication with " + auth + ". " + t.getMessage(), t);
                }
                indicator.setText(prevText$iv);
                indicator.setText2(prevText2$iv);
                ++i$iv;
            }
            indicator.setFraction(1.0);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
            $this$withPushPop$iv$iv.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<SharedIndexLookupResult, List<SharedIndexSuggestion>> resolveIndexes(ProgressIndicator indicator, List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>> requests) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object answer$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            SharedIndexLookupResult lookupResult;
            Iterable lookupRequest;
            List suggestions;
            SharedIndexSuggestion sharedIndexSuggestion;
            Object object;
            Object list$iv$iv;
            Object key$iv$iv2;
            Object element$iv$iv;
            void $this$groupByTo$iv$iv2;
            void $this$groupBy$iv2;
            boolean bl = false;
            SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = SharedIndexInfrastructureVersion.getIdeVersion();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sharedIndexInfrastructureVersion), (String)"SharedIndexInfrastructureVersion.getIdeVersion()");
            SharedIndexInfrastructureVersion ideVersion = sharedIndexInfrastructureVersion;
            indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.checking", new Object[0]));
            indicator.setIndeterminate(false);
            Iterable iterable = requests;
            boolean $i$f$groupBy = false;
            void var10_11 = $this$groupBy$iv2;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Object object2 = $this$groupByTo$iv$iv2.iterator();
            while (object2.hasNext()) {
                void it;
                Object object3;
                element$iv$iv = object2.next();
                Pair it2 = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-SharedIndexDownloadService$resolveIndexes$1$uniqueRequests$32 = false;
                key$iv$iv2 = (SharedIndexLookupRequest)it2.getSecond();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv2 = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv2);
                    object3 = answer$iv$iv$iv2;
                } else {
                    object3 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object3;
                Pair $i$a$-groupBy-SharedIndexDownloadService$resolveIndexes$1$uniqueRequests$32 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl3 = false;
                sharedIndexSuggestion = (SharedIndexSuggestion)it.getFirst();
                object.add(sharedIndexSuggestion);
            }
            Set uniqueRequests = destination$iv$iv.entrySet();
            boolean $i$f$service = false;
            Class<SharedIndexLookup> serviceClass$iv = SharedIndexLookup.class;
            Object object4 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object4 == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            SharedIndexLookup indexLookup = (SharedIndexLookup)object4;
            SetMultimap responses = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
            ArrayDeque basesToProcess = new ArrayDeque();
            double processed = 0.0;
            element$iv$iv = uniqueRequests.iterator();
            while (element$iv$iv.hasNext()) {
                void lookupRequest2;
                key$iv$iv2 = object2 = (Map.Entry)element$iv$iv.next();
                boolean $this$getOrPut$iv$iv$iv = false;
                list$iv$iv = (SharedIndexLookupRequest)key$iv$iv2.getKey();
                key$iv$iv2 = object2;
                $this$getOrPut$iv$iv$iv = false;
                suggestions = (List)key$iv$iv2.getValue();
                double d = processed;
                processed = d + 1.0;
                indicator.setFraction(d / (double)(basesToProcess.size() + uniqueRequests.size()));
                try {
                    SharedIndexLookupResult lookupResult2;
                    if (indexLookup.lookupSharedIndex((SharedIndexLookupRequest)lookupRequest2, ideVersion, indicator) == null) {
                        continue;
                    }
                    responses.putAll((Object)lookupResult2, (Iterable)suggestions);
                }
                catch (Throwable e) {
                    if (e instanceof ControlFlowException) {
                        throw e;
                    }
                    this.log.warn("Failed to lookup for shared index " + lookupRequest2 + " (" + suggestions + "). " + e.getMessage(), e);
                }
            }
            int totalItems = basesToProcess.size() + uniqueRequests.size();
            while (true) {
                element$iv$iv = (Collection)basesToProcess;
                boolean lookupRequest2 = false;
                if (!(!element$iv$iv.isEmpty())) break;
                double d = processed;
                processed = d + 1.0;
                indicator.setFraction(d / (double)totalItems);
                if ((Pair)basesToProcess.removeFirstOrNull() == null) {
                    break;
                }
                element$iv$iv = (SharedIndexLookupRequest)suggestions.component1();
                List suggestions2 = (List)suggestions.component2();
                if (indexLookup.lookupSharedIndex((SharedIndexLookupRequest)((Object)lookupRequest), ideVersion, indicator) == null) {
                    continue;
                }
                if (responses.containsKey((Object)lookupResult)) continue;
                responses.putAll((Object)lookupResult, (Iterable)suggestions2);
            }
            Set set = responses.entries();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"responses.entries()");
            lookupRequest = set;
            boolean $i$f$groupBy2 = false;
            lookupResult = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                void it;
                Object object5;
                Map.Entry it3 = (Map.Entry)element$iv$iv2;
                boolean $i$a$-groupBy-SharedIndexDownloadService$resolveIndexes$1$32 = false;
                key$iv$iv = (SharedIndexLookupResult)it3.getKey();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object5 = answer$iv$iv$iv;
                } else {
                    object5 = value$iv$iv$iv;
                }
                List list$iv$iv2 = (List)object5;
                Map.Entry $i$a$-groupBy-SharedIndexDownloadService$resolveIndexes$1$32 = (Map.Entry)element$iv$iv2;
                object = list$iv$iv2;
                boolean bl5 = false;
                sharedIndexSuggestion = (SharedIndexSuggestion)it.getValue();
                object.add(sharedIndexSuggestion);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv2;
                boolean bl6 = false;
                Object k = it$iv$iv.getKey();
                answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                sharedIndexSuggestion = k;
                object = map;
                boolean bl7 = false;
                List<SharedIndexSuggestion> list = this.mergeSameSuggestions((Collection)it.getValue());
                object.put(sharedIndexSuggestion, list);
            }
            Map map = destination$iv$iv2;
            return map;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    private final void downloadAndInstallIndexes(DownloadTaskContext $this$downloadAndInstallIndexes, Project project, ProgressIndicator indicator, Map<SharedIndexLookupResult, ? extends List<? extends SharedIndexSuggestion>> requests) {
        $this$downloadAndInstallIndexes.suspendIndexingIfNeeded((Function0)new Function0<Unit>(this, indicator, requests, project){
            final /* synthetic */ SharedIndexDownloadService this$0;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Map $requests;
            final /* synthetic */ Project $project;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                this.$indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.installing", new Object[0]));
                boolean bl = false;
                List infos = new ArrayList<E>();
                Iterable $this$sortedBy$iv = this.$requests.entrySet();
                boolean $i$f$sortedBy = false;
                boolean bl2 = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Map.Entry $dstr$lookupResult = (Map.Entry)a;
                        boolean bl2 = false;
                        Map.Entry entry = $dstr$lookupResult;
                        boolean bl3 = false;
                        SharedIndexLookupResult lookupResult = (SharedIndexLookupResult)entry.getKey();
                        $dstr$lookupResult = (Map.Entry)b;
                        Comparable comparable = Long.valueOf(lookupResult.getSize());
                        bl2 = false;
                        entry = $dstr$lookupResult;
                        bl3 = false;
                        lookupResult = (SharedIndexLookupResult)entry.getKey();
                        Long l = lookupResult.getSize();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
                    }
                });
                ProgressIndicator indicator$iv = this.$indicator;
                boolean $i$f$forEachWithProgress = false;
                ProgressIndicator $this$withPushPop$iv$iv = indicator$iv;
                boolean $i$f$withPushPop = false;
                boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
                $this$withPushPop$iv$iv.pushState();
                try {
                    void $this$forEachWithProgress$iv;
                    boolean bl3 = false;
                    indicator$iv.setIndeterminate(false);
                    indicator$iv.checkCanceled();
                    double size$iv = $this$forEachWithProgress$iv.size();
                    boolean bl4 = false;
                    for (T y$iv : (Iterable)$this$forEachWithProgress$iv) {
                        void lookupResult;
                        void i$iv;
                        indicator$iv.checkCanceled();
                        double lowerBound$iv = (double)i$iv / size$iv;
                        double upperBound$iv = (double)(i$iv + true) / size$iv;
                        indicator$iv.setFraction(lowerBound$iv);
                        String prevText$iv = indicator$iv.getText();
                        String prevText2$iv = indicator$iv.getText2();
                        ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator$iv, (double)lowerBound$iv, (double)upperBound$iv);
                        Map.Entry $dstr$lookupResult$suggestions = (Map.Entry)y$iv;
                        boolean bl5 = false;
                        Map.Entry entry = $dstr$lookupResult$suggestions;
                        boolean bl6 = false;
                        SharedIndexLookupResult sharedIndexLookupResult = (SharedIndexLookupResult)entry.getKey();
                        entry = $dstr$lookupResult$suggestions;
                        bl6 = false;
                        List suggestions = (List)entry.getValue();
                        try {
                            DownloadIndexResult hadDownloadedSomething;
                            void subIndicator;
                            boolean $i$f$measureTimeMillis = false;
                            boolean bl7 = false;
                            long start$iv = System.currentTimeMillis();
                            boolean bl8 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)SharedIndexChunkConfiguration.getInstance().downloadChunk(new LookupChunkDescriptor((SharedIndexLookupResult)lookupResult), this.$project, (ProgressIndicator)subIndicator)), (String)"SharedIndexChunkConfigur\u2026ubIndicator\n            )");
                            if (hadDownloadedSomething == DownloadIndexResult.JUST_DOWNLOADED) {
                                Collection<SharedIndexId> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                long downloadTime = System.currentTimeMillis() - start$iv;
                                boolean $i$f$service22 = false;
                                Class<SharedIndexDownloadHistoryStore> serviceClass$iv = SharedIndexDownloadHistoryStore.class;
                                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                                if (object == null) {
                                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                                }
                                Iterable $i$f$service22 = suggestions;
                                SharedIndexDownloadHistoryStore sharedIndexDownloadHistoryStore = (SharedIndexDownloadHistoryStore)((Object)object);
                                boolean $i$f$map = false;
                                void var36_41 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl9 = false;
                                    SharedIndexId sharedIndexId = it.getSharedIndexId();
                                    collection.add(sharedIndexId);
                                }
                                collection = (List)destination$iv$iv;
                                sharedIndexDownloadHistoryStore.updateLastDownload((List<SharedIndexId>)collection, lookupResult.getChunkUniqueId(), lookupResult.getSize());
                                Collection collection2 = infos;
                                SharedIndexDownloadInfo sharedIndexDownloadInfo = new SharedIndexDownloadInfo(suggestions, lookupResult.getSize(), downloadTime);
                                boolean bl10 = false;
                                collection2.add(sharedIndexDownloadInfo);
                            }
                        }
                        catch (Throwable e) {
                            if (e instanceof ControlFlowException) {
                                throw e;
                            }
                            SharedIndexDownloadService.access$getLog$p(this.this$0).warn("Failed to download shared index " + lookupResult + " (" + suggestions + "). " + e.getMessage(), e);
                        }
                        indicator$iv.setText(prevText$iv);
                        indicator$iv.setText2(prevText2$iv);
                        ++i$iv;
                    }
                    indicator$iv.setFraction(1.0);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
                    $this$withPushPop$iv$iv.popState();
                }
                boolean $i$f$service = false;
                Class<SharedIndexDownloadNotifications> serviceClass$iv = SharedIndexDownloadNotifications.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                ((SharedIndexDownloadNotifications)object).notifySharedIndexInstalled(this.$project, infos);
            }
            {
                this.this$0 = sharedIndexDownloadService;
                this.$indicator = progressIndicator;
                this.$requests = map;
                this.$project = project;
                super(0);
            }
        });
    }

    public SharedIndexDownloadService() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexDownloadService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.log = logger;
        this.rescanningCounter = new AtomicInteger();
    }

    public static final /* synthetic */ Logger access$getLog$p(SharedIndexDownloadService $this) {
        return $this.log;
    }

    public static final /* synthetic */ List access$mergeSameSuggestions(SharedIndexDownloadService $this, Collection $this$access_u24mergeSameSuggestions) {
        return $this.mergeSameSuggestions($this$access_u24mergeSameSuggestions);
    }

    public static final /* synthetic */ List access$collectSuggestionsSuitableForDownload(SharedIndexDownloadService $this, Project project) {
        return $this.collectSuggestionsSuitableForDownload(project);
    }

    public static final /* synthetic */ void access$doDownloadSharedIndexes(SharedIndexDownloadService $this, DownloadTaskContext $this$access_u24doDownloadSharedIndexes, Project project, List actualSuggestions) {
        $this.doDownloadSharedIndexes($this$access_u24doDownloadSharedIndexes, project, actualSuggestions);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadService$LookupChunkDescriptor;", "Lcom/intellij/indexing/shared/platform/api/ChunkDescriptor;", "lookupResult", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;)V", "chunkStorageOption", "Lcom/intellij/indexing/shared/platform/impl/ChunkStorageOption;", "getChunkStorageOption", "()Lcom/intellij/indexing/shared/platform/impl/ChunkStorageOption;", "chunkUniqueId", "", "getChunkUniqueId", "()Ljava/lang/String;", "kind", "getKind", "downloadChunk", "", "targetFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "intellij.indexing.shared"})
    private static final class LookupChunkDescriptor
    implements ChunkDescriptor {
        @NotNull
        private final String chunkUniqueId;
        @NotNull
        private final String kind;
        @NotNull
        private final ChunkStorageOption chunkStorageOption;
        private final SharedIndexLookupResult lookupResult;

        @Override
        @NotNull
        public String getChunkUniqueId() {
            return this.chunkUniqueId;
        }

        @Override
        @NotNull
        public String getKind() {
            return this.kind;
        }

        @Override
        public boolean downloadChunk(@NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            return SharedIndexLookupResultKt.downloadChunk(this.lookupResult, targetFile, project, indicator);
        }

        @Override
        @NotNull
        public ChunkStorageOption getChunkStorageOption() {
            return this.chunkStorageOption;
        }

        @NotNull
        public String toString() {
            return this.getChunkUniqueId();
        }

        public LookupChunkDescriptor(@NotNull SharedIndexLookupResult lookupResult) {
            Intrinsics.checkNotNullParameter((Object)lookupResult, (String)"lookupResult");
            this.lookupResult = lookupResult;
            this.chunkUniqueId = this.lookupResult.getChunkUniqueId();
            this.kind = this.lookupResult.getRequest().getKind();
            this.chunkStorageOption = ChunkStorageOption.APPENDABLE;
        }
    }
}

