/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import git4idea.GitBranchesUsageCollector;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.BranchIconUtil;
import git4idea.ui.branch.GitBranchPopup;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchWidget
extends DvcsStatusWidget<GitRepository> {
    @NonNls
    private static final String ID = "git";
    private final GitVcsSettings mySettings;

    public GitBranchWidget(@NotNull Project project) {
        if (project == null) {
            GitBranchWidget.$$$reportNull$$$0(0);
        }
        super(project, GitVcs.DISPLAY_NAME.get());
        this.mySettings = GitVcsSettings.getInstance(project);
        project.getMessageBus().connect((Disposable)this).subscribe(GitRepository.GIT_REPO_CHANGE, r -> this.updateLater());
        project.getMessageBus().connect((Disposable)this).subscribe(GitBranchIncomingOutgoingManager.GIT_INCOMING_OUTGOING_CHANGED, () -> ((GitBranchWidget)this).updateLater());
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public StatusBarWidget copy() {
        return new GitBranchWidget(this.getProject());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @RequiresEdt
    protected GitRepository guessCurrentRepository(@NotNull Project project) {
        void project2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null) {
            GitBranchWidget.$$$reportNull$$$0(1);
        }
        return (GitRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)project2, (AbstractRepositoryManager)GitUtil.getRepositoryManager((Project)project2), (String)this.mySettings.getRecentRootPath());
    }

    @Nullable
    protected Icon getIcon(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchWidget.$$$reportNull$$$0(2);
        }
        return BranchIconUtil.Companion.getBranchIcon(repository);
    }

    @NotNull
    protected String getFullBranchName(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchWidget.$$$reportNull$$$0(3);
        }
        String string = GitBranchUtil.getDisplayableBranchText(repository);
        if (string == null) {
            GitBranchWidget.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        if (project == null) {
            GitBranchWidget.$$$reportNull$$$0(5);
        }
        return !GitUtil.justOneGitRepository(project);
    }

    @NotNull
    protected ListPopup getPopup(@NotNull Project project, @NotNull GitRepository repository) {
        if (project == null) {
            GitBranchWidget.$$$reportNull$$$0(6);
        }
        if (repository == null) {
            GitBranchWidget.$$$reportNull$$$0(7);
        }
        GitBranchesUsageCollector.branchWidgetClicked();
        ListPopup listPopup = GitBranchPopup.getInstance(project, repository, DataManager.getInstance().getDataContext((Component)this.myStatusBar.getComponent())).asListPopup();
        if (listPopup == null) {
            GitBranchWidget.$$$reportNull$$$0(8);
        }
        return listPopup;
    }

    protected void rememberRecentRoot(@NotNull String path) {
        if (path == null) {
            GitBranchWidget.$$$reportNull$$$0(9);
        }
        this.mySettings.setRecentRoot(path);
    }

    @NlsContexts.Tooltip
    @Nullable
    protected String getToolTip(@Nullable GitRepository repository) {
        if (repository != null && repository.getState() == Repository.State.DETACHED) {
            return GitBundle.message("git.status.bar.widget.tooltip.detached", new Object[0]);
        }
        return super.getToolTip((Repository)repository);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitBranchWidget";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitBranchWidget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullBranchName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "guessCurrentRepository";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFullBranchName";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMultiRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPopup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rememberRecentRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements StatusBarWidgetFactory {
        @NotNull
        public String getId() {
            return GitBranchWidget.ID;
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            String string = GitBundle.message("git.status.bar.widget.name", new Object[0]);
            if (string == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return !ToolbarSettings.getInstance().isVisible() && !GitRepositoryManager.getInstance(project).getRepositories().isEmpty();
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return new GitBranchWidget(project);
        }

        public boolean isEnabledByDefault() {
            return !ToolbarSettings.getInstance().isVisible() || !ToolbarSettings.getInstance().isEnabled();
        }

        public void disposeWidget(@NotNull StatusBarWidget widget) {
            if (widget == null) {
                Factory.$$$reportNull$$$0(3);
            }
            Disposer.dispose((Disposable)widget);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                Factory.$$$reportNull$$$0(4);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchWidget$Factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "widget";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchWidget$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeWidget";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEnabledOn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Listener
    implements VcsRepositoryMappingListener {
        private final Project myProject;

        public Listener(@NotNull Project project) {
            if (project == null) {
                Listener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void mappingChanged() {
            ((StatusBarWidgetsManager)this.myProject.getService(StatusBarWidgetsManager.class)).updateWidget(Factory.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchWidget$Listener", "<init>"));
        }
    }
}

