/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.StatusText;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.i18n.GitBundle;
import git4idea.stash.GitStashCache;
import git4idea.stash.ui.GitStashChangesBrowser;
import git4idea.stash.ui.GitStashDiffPreview;
import git4idea.stash.ui.GitStashEditorDiffPreview;
import git4idea.ui.StashInfo;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001>B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010#\u001a\u00020$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\b\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0014J\n\u0010.\u001a\u0004\u0018\u00010/H\u0014J\u0012\u00100\u001a\u0004\u0018\u00010\u001c2\u0006\u00101\u001a\u00020\tH\u0002J\u0010\u00102\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u00010\u0010J$\u00104\u001a\u00020)2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\bH\u0002J8\u00104\u001a\u00020)2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\b2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020)08H\u0002J\u000e\u0010:\u001a\u00020\u00122\u0006\u0010;\u001a\u00020<J\u001c\u0010=\u001a\u00020)2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020)08H\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001d0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lgit4idea/stash/ui/GitStashChangesBrowser;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserBase;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "getChanges", "()Ljava/util/Collection;", "currentChangesFuture", "Ljava/util/concurrent/CompletableFuture;", "Lgit4idea/stash/GitStashCache$StashData;", "currentStash", "Lgit4idea/ui/StashInfo;", "<set-?>", "Lgit4idea/stash/ui/GitStashDiffPreview;", "diffPreviewProcessor", "getDiffPreviewProcessor", "()Lgit4idea/stash/ui/GitStashDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabPreview;", "editorTabPreview", "getEditorTabPreview", "()Lcom/intellij/openapi/vcs/changes/EditorTabPreview;", "otherChanges", "", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "", "stashCache", "Lgit4idea/stash/GitStashCache;", "getStashCache", "()Lgit4idea/stash/GitStashCache;", "stashedChanges", "buildTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "createPopupMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "", "getDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "userObject", "", "getShowDiffActionPreview", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "getTag", "change", "selectStash", "stash", "setData", "parents", "Lgit4idea/GitCommit;", "updateEmptyText", "Lkotlin/Function1;", "Lcom/intellij/util/ui/StatusText;", "setDiffPreviewInEditor", "isInEditor", "", "setEmpty", "MyTag", "intellij.vcs.git"})
public final class GitStashChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    private Collection<? extends Change> stashedChanges;
    private Map<ChangesBrowserNode.Tag, ? extends Set<? extends Change>> otherChanges;
    private StashInfo currentStash;
    private CompletableFuture<GitStashCache.StashData> currentChangesFuture;
    @Nullable
    private GitStashDiffPreview diffPreviewProcessor;
    @Nullable
    private EditorTabPreview editorTabPreview;

    private final GitStashCache getStashCache() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitStashCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return (GitStashCache)object;
    }

    @NotNull
    public final Collection<Change> getChanges() {
        return this.stashedChanges;
    }

    @Nullable
    public final GitStashDiffPreview getDiffPreviewProcessor() {
        return this.diffPreviewProcessor;
    }

    @Nullable
    public final EditorTabPreview getEditorTabPreview() {
        return this.editorTabPreview;
    }

    public final void selectStash(@Nullable StashInfo stash) {
        if (Intrinsics.areEqual((Object)stash, (Object)this.currentStash)) {
            return;
        }
        this.currentStash = stash;
        CompletableFuture<GitStashCache.StashData> completableFuture = this.currentChangesFuture;
        if (completableFuture != null) {
            completableFuture.cancel(false);
        }
        this.currentChangesFuture = null;
        if (stash == null) {
            this.setEmpty((Function1<? super StatusText, Unit>)((Function1)selectStash.1.INSTANCE));
            return;
        }
        this.setEmpty((Function1<? super StatusText, Unit>)((Function1)selectStash.2.INSTANCE));
        CompletableFuture<GitStashCache.StashData> completableFuture2 = this.getStashCache().loadStashData(stash);
        if (completableFuture2 == null) {
            return;
        }
        CompletableFuture<GitStashCache.StashData> futureChanges = completableFuture2;
        this.currentChangesFuture = futureChanges;
        futureChanges.thenRunAsync(new Runnable(this, stash){
            final /* synthetic */ GitStashChangesBrowser this$0;
            final /* synthetic */ StashInfo $stash;

            public final void run() {
                GitStashCache.StashData stashData;
                if (Intrinsics.areEqual((Object)GitStashChangesBrowser.access$getCurrentStash$p(this.this$0), (Object)this.$stash) ^ true) {
                    return;
                }
                CompletableFuture completableFuture = GitStashChangesBrowser.access$getCurrentChangesFuture$p(this.this$0);
                GitStashCache.StashData stashData2 = stashData = completableFuture != null ? (GitStashCache.StashData)completableFuture.get() : null;
                if (stashData instanceof GitStashCache.StashData.Changes) {
                    GitStashChangesBrowser.access$setData(this.this$0, ((GitStashCache.StashData.Changes)stashData).getChanges(), ((GitStashCache.StashData.Changes)stashData).getParentCommits());
                } else if (stashData instanceof GitStashCache.StashData.Error) {
                    GitStashChangesBrowser.access$setEmpty(this.this$0, (Function1)new Function1<StatusText, Unit>(stashData){
                        final /* synthetic */ GitStashCache.StashData $stashData;

                        public final void invoke(@NotNull StatusText statusText) {
                            Intrinsics.checkNotNullParameter((Object)statusText, (String)"statusText");
                            statusText.setText(((GitStashCache.StashData.Error)this.$stashData).getError().getLocalizedMessage(), SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                        {
                            this.$stashData = stashData;
                            super(1);
                        }
                    });
                }
                GitStashChangesBrowser.access$setCurrentChangesFuture$p(this.this$0, null);
            }
            {
                this.this$0 = gitStashChangesBrowser;
                this.$stash = stashInfo;
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        List list2 = super.createPopupMenuActions();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"super.createPopupMenuActions()");
        return CollectionsKt.plus((Collection)list2, (Object)ActionManager.getInstance().getAction("Git.Stash.ChangesBrowser.ContextMenu"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, this.getGrouping());
        builder.setChanges(this.stashedChanges, null);
        ChangesBrowserNode.Tag tag = this.otherChanges;
        boolean bl = false;
        Iterator<Map.Entry<ChangesBrowserNode.Tag, ? extends Set<? extends Change>>> iterator = tag.entrySet().iterator();
        while (iterator.hasNext()) {
            void tag2;
            Map.Entry<ChangesBrowserNode.Tag, ? extends Set<? extends Change>> entry;
            Map.Entry<ChangesBrowserNode.Tag, ? extends Set<? extends Change>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            tag = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Set<? extends Change> changes = entry2.getValue();
            if (changes.isEmpty()) continue;
            builder.insertChanges((Collection)changes, builder.createTagNode((ChangesBrowserNode.Tag)tag2, SimpleTextAttributes.REGULAR_ATTRIBUTES, false));
        }
        DefaultTreeModel defaultTreeModel = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"builder.build()");
        return defaultTreeModel;
    }

    private final void setEmpty(Function1<? super StatusText, Unit> updateEmptyText) {
        this.setData(CollectionsKt.emptyList(), CollectionsKt.emptyList(), updateEmptyText);
    }

    private final void setData(Collection<? extends Change> stash, Collection<GitCommit> parents) {
        this.setData(stash, parents, (Function1<? super StatusText, Unit>)((Function1)setData.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final void setData(Collection<? extends Change> stash, Collection<GitCommit> parents, Function1<? super StatusText, Unit> updateEmptyText) {
        Map map2;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        this.stashedChanges = stash;
        Iterable iterable = parents;
        GitStashChangesBrowser gitStashChangesBrowser = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv;
            GitCommit parent = (GitCommit)((Object)element$iv$iv);
            boolean bl = false;
            String string = parent.getSubject();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parent.subject");
            String string2 = StringUtil.capitalize((String)StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.capitalize(pa\u2026ect.substringBefore(\":\"))");
            Hash hash = parent.getId();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"parent.id");
            MyTag tag = new MyTag(string2, hash);
            Pair pair = new Pair((Object)tag, (Object)new ReferenceOpenHashSet(parent.getChanges()));
            boolean bl2 = false;
            map3.put(pair.getFirst(), pair.getSecond());
        }
        gitStashChangesBrowser.otherChanges = map2 = destination$iv$iv;
        ChangesTree changesTree = this.getViewer();
        Intrinsics.checkNotNullExpressionValue((Object)changesTree, (String)"viewer");
        StatusText statusText = changesTree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"viewer.emptyText");
        updateEmptyText.invoke((Object)statusText);
        this.getViewer().rebuildTree();
    }

    @Nullable
    protected DiffPreview getShowDiffActionPreview() {
        return (DiffPreview)this.editorTabPreview;
    }

    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        Map context;
        block1: {
            Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
            if (!(userObject instanceof Change)) {
                return null;
            }
            boolean bl = false;
            context = new LinkedHashMap();
            ChangesBrowserNode.Tag tag = this.getTag((Change)userObject);
            if (tag == null) break block1;
            ChangesBrowserNode.Tag tag2 = tag;
            boolean bl2 = false;
            boolean bl3 = false;
            ChangesBrowserNode.Tag it = tag2;
            boolean bl4 = false;
            Key key = ChangeDiffRequestProducer.TAG_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"ChangeDiffRequestProducer.TAG_KEY");
            context.put(key, it);
        }
        return (ChangeDiffRequestChain.Producer)ChangeDiffRequestProducer.create((Project)this.myProject, (Change)((Change)userObject), (Map)context);
    }

    private final ChangesBrowserNode.Tag getTag(Change change) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = MapsKt.asSequence(this.otherChanges);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!((Set)it.getValue()).contains(change)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (ChangesBrowserNode.Tag)entry.getKey() : null;
    }

    @NotNull
    public final GitStashDiffPreview setDiffPreviewInEditor(boolean isInEditor) {
        if (this.diffPreviewProcessor != null) {
            GitStashDiffPreview gitStashDiffPreview = this.diffPreviewProcessor;
            Intrinsics.checkNotNull((Object)((Object)gitStashDiffPreview));
            Disposer.dispose((Disposable)((Disposable)gitStashDiffPreview));
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ChangesTree changesTree = this.getViewer();
        Intrinsics.checkNotNullExpressionValue((Object)changesTree, (String)"viewer");
        GitStashDiffPreview newProcessor2 = new GitStashDiffPreview(this, isInEditor, project, changesTree, isInEditor, this){
            final /* synthetic */ GitStashChangesBrowser this$0;
            final /* synthetic */ boolean $isInEditor;

            @Nullable
            protected ChangesBrowserNode.Tag getTag(@NotNull Change change) {
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                return GitStashChangesBrowser.access$getTag(this.this$0, change);
            }
            {
                this.this$0 = this$0;
                this.$isInEditor = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
        this.diffPreviewProcessor = newProcessor2;
        if (isInEditor) {
            GitStashDiffPreview gitStashDiffPreview = newProcessor2;
            ChangesTree changesTree2 = this.getViewer();
            Intrinsics.checkNotNullExpressionValue((Object)changesTree2, (String)"viewer");
            this.editorTabPreview = (EditorTabPreview)new GitStashEditorDiffPreview(gitStashDiffPreview, changesTree2, (JComponent)((Object)this));
        } else {
            this.editorTabPreview = null;
        }
        return newProcessor2;
    }

    public void dispose() {
    }

    public GitStashChangesBrowser(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(project, false, false);
        this.stashedChanges = CollectionsKt.emptyList();
        this.otherChanges = MapsKt.emptyMap();
        this.init();
        ChangesTree changesTree = this.getViewer();
        Intrinsics.checkNotNullExpressionValue((Object)changesTree, (String)"viewer");
        StatusText statusText = changesTree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"viewer.emptyText");
        statusText.setText(GitBundle.message("stash.changes.empty", new Object[0]));
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public static final /* synthetic */ StashInfo access$getCurrentStash$p(GitStashChangesBrowser $this) {
        return $this.currentStash;
    }

    public static final /* synthetic */ void access$setCurrentStash$p(GitStashChangesBrowser $this, StashInfo stashInfo) {
        $this.currentStash = stashInfo;
    }

    public static final /* synthetic */ CompletableFuture access$getCurrentChangesFuture$p(GitStashChangesBrowser $this) {
        return $this.currentChangesFuture;
    }

    public static final /* synthetic */ void access$setCurrentChangesFuture$p(GitStashChangesBrowser $this, CompletableFuture completableFuture) {
        $this.currentChangesFuture = completableFuture;
    }

    public static final /* synthetic */ void access$setData(GitStashChangesBrowser $this, Collection stash, Collection parents) {
        $this.setData(stash, parents);
    }

    public static final /* synthetic */ void access$setEmpty(GitStashChangesBrowser $this, Function1 updateEmptyText) {
        $this.setEmpty((Function1<? super StatusText, Unit>)updateEmptyText);
    }

    public static final /* synthetic */ ChangesBrowserNode.Tag access$getTag(GitStashChangesBrowser $this, Change change) {
        return $this.getTag(change);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/stash/ui/GitStashChangesBrowser$MyTag;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "text", "", "hash", "Lcom/intellij/vcs/log/Hash;", "(Ljava/lang/String;Lcom/intellij/vcs/log/Hash;)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class MyTag
    implements ChangesBrowserNode.Tag {
        private final String text;
        private final Hash hash;

        @NotNull
        public String toString() {
            return this.text;
        }

        public MyTag(@Nls @NotNull String text, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.text = text;
            this.hash = hash;
        }

        private final String component1() {
            return this.text;
        }

        private final Hash component2() {
            return this.hash;
        }

        @NotNull
        public final MyTag copy(@Nls @NotNull String text, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new MyTag(text, hash);
        }

        public static /* synthetic */ MyTag copy$default(MyTag myTag, String string, Hash hash, int n, Object object) {
            if ((n & 1) != 0) {
                string = myTag.text;
            }
            if ((n & 2) != 0) {
                hash = myTag.hash;
            }
            return myTag.copy(string, hash);
        }

        public int hashCode() {
            String string = this.text;
            Hash hash = this.hash;
            return (string != null ? string.hashCode() : 0) * 31 + (hash != null ? hash.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MyTag)) break block3;
                    MyTag myTag = (MyTag)object;
                    if (!Intrinsics.areEqual((Object)this.text, (Object)myTag.text) || !Intrinsics.areEqual((Object)this.hash, (Object)myTag.hash)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

