/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.actions.diff.PresentableGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.NullableFunction;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.index.GitStageDiffUtilKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerListener;
import git4idea.index.KindTag;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.GitStageDiffPreview;
import git4idea.index.ui.GitStageDiffPreview$GitFileStatusNodeWrapper$WhenMappings;
import git4idea.index.ui.GitStageTree;
import git4idea.index.ui.NodeKind;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0014J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/index/ui/GitStageDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lgit4idea/index/ui/GitStageTree;", "tracker", "Lgit4idea/index/GitStageTracker;", "isInEditor", "", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/index/ui/GitStageTree;Lgit4idea/index/GitStageTracker;ZLcom/intellij/openapi/Disposable;)V", "createGoToChangeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getAllChanges", "Ljava/util/stream/Stream;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "getSelectedChanges", "getToolbarWrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "selectChange", "", "change", "shouldAddToolbarBottomBorder", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "wrap", "modelData", "Lcom/intellij/openapi/vcs/changes/ui/VcsTreeModelData;", "GitFileStatusNodeWrapper", "MyGoToChangePopupAction", "intellij.vcs.git"})
public final class GitStageDiffPreview
extends ChangeViewDiffRequestProcessor {
    private final GitStageTree tree;

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return false;
    }

    @NotNull
    public final Wrapper getToolbarWrapper() {
        Wrapper wrapper = this.myToolbarWrapper;
        Intrinsics.checkNotNullExpressionValue((Object)wrapper, (String)"myToolbarWrapper");
        return wrapper;
    }

    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (!(change instanceof GitFileStatusNodeWrapper) && !(change instanceof ChangeViewDiffRequestProcessor.ChangeWrapper)) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getRoot()), (Object)change.getUserObject());
        if (defaultMutableTreeNode == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"TreeUtil.findNodeWithObj\u2026nge.userObject) ?: return");
        DefaultMutableTreeNode node = defaultMutableTreeNode;
        TreeUtil.selectPath((JTree)((JTree)((Object)this.tree)), (TreePath)TreeUtil.getPathFromRoot((TreeNode)node), (boolean)false);
    }

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.selected((JTree)((JTree)((Object)this.tree)));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"VcsTreeModelData.selected(tree)");
        return this.wrap(vcsTreeModelData);
    }

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.all((JTree)((JTree)((Object)this.tree)));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"VcsTreeModelData.all(tree)");
        return this.wrap(vcsTreeModelData);
    }

    @NotNull
    protected AnAction createGoToChangeAction() {
        return (AnAction)new MyGoToChangePopupAction();
    }

    private final Stream<ChangeViewDiffRequestProcessor.Wrapper> wrap(VcsTreeModelData modelData) {
        Stream<ChangeViewDiffRequestProcessor.Wrapper> stream = Stream.concat(modelData.userObjectsStream(GitFileStatusNode.class).filter(wrap.1.INSTANCE).map(wrap.2.INSTANCE), modelData.userObjectsStream(Change.class).map(wrap.3.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"Stream.concat(\n      mod\u2026ChangeWrapper(it) }\n    )");
        return stream;
    }

    public GitStageDiffPreview(@NotNull Project project, @NotNull GitStageTree tree, @NotNull GitStageTracker tracker, boolean isInEditor, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(project, "Stage");
        this.tree = tree;
        if (!isInEditor) {
            Wrapper wrapper = this.myContentPanel;
            Intrinsics.checkNotNullExpressionValue((Object)wrapper, (String)"myContentPanel");
            wrapper.setBorder(IdeBorderFactory.createBorder((int)2));
        }
        this.tree.addSelectionListener(new Runnable(){

            @Override
            public final void run() {
                final boolean modelUpdateInProgress = tree.isModelUpdateInProgress();
                BaseSingleTaskControllerKt.runInEdtAsync((Disposable)((Disposable)this), (Function0)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        GitStageDiffPreview gitStageDiffPreview = this;
                        JComponent jComponent = this.getComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component");
                        gitStageDiffPreview.updatePreview(jComponent.isShowing(), modelUpdateInProgress);
                    }
                }));
            }
        }, (Disposable)this);
        tracker.addListener(new GitStageTrackerListener(){

            @Override
            public void update() {
                JComponent jComponent = this.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component");
                this.updatePreview(jComponent.isShowing(), true);
            }
        }, (Disposable)this);
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a8\u0006\t"}, d2={"Lgit4idea/index/ui/GitStageDiffPreview$MyGoToChangePopupAction;", "Lcom/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$Default;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "(Lgit4idea/index/ui/GitStageDiffPreview;)V", "getChanges", "Lcom/intellij/openapi/ListSelection;", "onSelected", "", "change", "intellij.vcs.git"})
    private final class MyGoToChangePopupAction
    extends PresentableGoToChangePopupAction.Default<ChangeViewDiffRequestProcessor.Wrapper> {
        @NotNull
        protected ListSelection<ChangeViewDiffRequestProcessor.Wrapper> getChanges() {
            ListSelection<GitFileStatusNode> listSelection = GitStageDiffPreview.this.tree.statusNodesListSelection(false);
            Object object = getChanges.1.INSTANCE;
            if (object != null) {
                Function1 function1 = object;
                object = new NullableFunction(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    @Nullable
                    public final /* synthetic */ Object fun(Object p0) {
                        return this.function.invoke(p0);
                    }
                };
            }
            ListSelection listSelection2 = listSelection.map((NullableFunction)object);
            Intrinsics.checkNotNullExpressionValue((Object)listSelection2, (String)"tree.statusNodesListSele\u2026GitFileStatusNodeWrapper)");
            return listSelection2;
        }

        protected void onSelected(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            GitStageDiffPreview.this.selectChange(change);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lgit4idea/index/ui/GitStageDiffPreview$GitFileStatusNodeWrapper;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "node", "Lgit4idea/index/ui/GitFileStatusNode;", "(Lgit4idea/index/ui/GitFileStatusNode;)V", "getNode", "()Lgit4idea/index/ui/GitFileStatusNode;", "createProducer", "Lcom/intellij/diff/chains/DiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "equals", "", "other", "", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getPresentableName", "", "getTag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "getUserObject", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class GitFileStatusNodeWrapper
    extends ChangeViewDiffRequestProcessor.Wrapper {
        @NotNull
        private final GitFileStatusNode node;

        @NotNull
        public String getPresentableName() {
            String string = this.node.getFilePath().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.filePath.name");
            return string;
        }

        @NotNull
        public Object getUserObject() {
            return this.node;
        }

        @NotNull
        public FilePath getFilePath() {
            return this.node.getFilePath();
        }

        @NotNull
        public FileStatus getFileStatus() {
            return this.node.getFileStatus();
        }

        @NotNull
        public ChangesBrowserNode.Tag getTag() {
            NodeKind nodeKind;
            switch (GitStageDiffPreview$GitFileStatusNodeWrapper$WhenMappings.$EnumSwitchMapping$0[this.node.getKind().ordinal()]) {
                case 1: {
                    nodeKind = NodeKind.UNSTAGED;
                    break;
                }
                default: {
                    nodeKind = this.node.getKind();
                }
            }
            return (ChangesBrowserNode.Tag)KindTag.Companion.getTag$intellij_vcs_git(nodeKind);
        }

        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            return (DiffRequestProducer)GitStageDiffUtilKt.createTwoSidesDiffRequestProducer(project2, this.node);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null) ^ true) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type git4idea.index.ui.GitStageDiffPreview.GitFileStatusNodeWrapper");
            }
            GitFileStatusNodeWrapper cfr_ignored_0 = (GitFileStatusNodeWrapper)((Object)object2);
            if (this.node.getKind() != ((GitFileStatusNodeWrapper)((Object)other)).node.getKind()) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.node.getFilePath(), (Object)((GitFileStatusNodeWrapper)((Object)other)).node.getFilePath()) ^ true);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.node.getKind(), this.node.getFilePath()});
        }

        @NotNull
        public String toString() {
            return "GitFileStatusNodeWrapper(node=" + this.node + ')';
        }

        @NotNull
        public final GitFileStatusNode getNode() {
            return this.node;
        }

        public GitFileStatusNodeWrapper(@NotNull GitFileStatusNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
        }
    }
}

