/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.BaseDataReader;
import git4idea.commands.BufferingTextSplitter;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitTextHandler;
import git4idea.config.GitExecutable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLineHandler
extends GitTextHandler {
    private final EventDispatcher<GitLineHandlerListener> myLineListeners;
    @NotNull
    private Collection<String> myUrls;
    @NotNull
    private GitAuthenticationMode myIgnoreAuthenticationRequest;
    @Nullable
    private GitAuthenticationGate myAuthenticationGate;

    public GitLineHandler(@Nullable Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (directory == null) {
            GitLineHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(1);
        }
        super(project, directory, command);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
        this.myIgnoreAuthenticationRequest = GitAuthenticationMode.FULL;
    }

    public GitLineHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        if (vcsRoot == null) {
            GitLineHandler.$$$reportNull$$$0(2);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(3);
        }
        super(project, vcsRoot, command);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
        this.myIgnoreAuthenticationRequest = GitAuthenticationMode.FULL;
    }

    public GitLineHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (vcsRoot == null) {
            GitLineHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(5);
        }
        if (configParameters == null) {
            GitLineHandler.$$$reportNull$$$0(6);
        }
        super(project, vcsRoot, command, configParameters);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
        this.myIgnoreAuthenticationRequest = GitAuthenticationMode.FULL;
    }

    public GitLineHandler(@Nullable Project project, @NotNull File directory, @NotNull GitExecutable executable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (directory == null) {
            GitLineHandler.$$$reportNull$$$0(7);
        }
        if (executable == null) {
            GitLineHandler.$$$reportNull$$$0(8);
        }
        if (command == null) {
            GitLineHandler.$$$reportNull$$$0(9);
        }
        if (configParameters == null) {
            GitLineHandler.$$$reportNull$$$0(10);
        }
        super(project, directory, executable, command, configParameters);
        this.myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
        this.myUrls = Collections.emptyList();
        this.myIgnoreAuthenticationRequest = GitAuthenticationMode.FULL;
    }

    public void setUrl(@NotNull @NonNls String url) {
        if (url == null) {
            GitLineHandler.$$$reportNull$$$0(11);
        }
        this.setUrls(Collections.singletonList(url));
    }

    public void setUrls(@NotNull Collection<String> urls) {
        if (urls == null) {
            GitLineHandler.$$$reportNull$$$0(12);
        }
        this.myUrls = urls;
    }

    @NotNull
    public Collection<String> getUrls() {
        Collection<String> collection = this.myUrls;
        if (collection == null) {
            GitLineHandler.$$$reportNull$$$0(13);
        }
        return collection;
    }

    protected boolean isRemote() {
        return !this.myUrls.isEmpty();
    }

    @NotNull
    public GitAuthenticationMode getIgnoreAuthenticationMode() {
        GitAuthenticationMode gitAuthenticationMode = this.myIgnoreAuthenticationRequest;
        if (gitAuthenticationMode == null) {
            GitLineHandler.$$$reportNull$$$0(14);
        }
        return gitAuthenticationMode;
    }

    public void setIgnoreAuthenticationMode(@NotNull GitAuthenticationMode authenticationMode) {
        if (authenticationMode == null) {
            GitLineHandler.$$$reportNull$$$0(15);
        }
        this.myIgnoreAuthenticationRequest = authenticationMode;
    }

    @Nullable
    public GitAuthenticationGate getAuthenticationGate() {
        return this.myAuthenticationGate;
    }

    public void setAuthenticationGate(@NotNull GitAuthenticationGate authenticationGate) {
        if (authenticationGate == null) {
            GitLineHandler.$$$reportNull$$$0(16);
        }
        this.myAuthenticationGate = authenticationGate;
    }

    @Override
    protected void processTerminated(int exitCode) {
    }

    public void addLineListener(GitLineHandlerListener listener) {
        super.addListener((ProcessEventListener)listener);
        this.myLineListeners.addListener((EventListener)((Object)listener));
    }

    @Deprecated
    protected void onTextAvailable(String text, Key outputType) {
    }

    private void onLineAvailable(@NotNull String line, boolean isCr, @NotNull Key outputType) {
        if (line == null) {
            GitLineHandler.$$$reportNull$$$0(17);
        }
        if (outputType == null) {
            GitLineHandler.$$$reportNull$$$0(18);
        }
        this.onTextAvailable(line, outputType);
        if (outputType == ProcessOutputTypes.SYSTEM) {
            return;
        }
        if (!isCr) {
            this.logOutput(line, outputType);
        }
        if (OUTPUT_LOG.isDebugEnabled()) {
            OUTPUT_LOG.debug(String.format("%s %% %s (%s):'%s'", this.getCommand(), this.hashCode(), outputType, line));
        }
        ((GitLineHandlerListener)((Object)this.myLineListeners.getMulticaster())).onLineAvailable(line, outputType);
    }

    private void logOutput(@NotNull String line, @NotNull Key outputType) {
        boolean shouldLogOutput;
        if (line == null) {
            GitLineHandler.$$$reportNull$$$0(19);
        }
        if (outputType == null) {
            GitLineHandler.$$$reportNull$$$0(20);
        }
        if (this.mySilent) {
            return;
        }
        boolean bl = shouldLogOutput = outputType == ProcessOutputTypes.STDOUT && !this.isStdoutSuppressed() || outputType == ProcessOutputTypes.STDERR && !this.isStderrSuppressed();
        if (!shouldLogOutput) {
            return;
        }
        if (StringUtil.isEmptyOrSpaces((String)line)) {
            return;
        }
        LOG.info(line.trim());
    }

    @Override
    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            GitLineHandler.$$$reportNull$$$0(21);
        }
        return new GitTextHandler.MyOSProcessHandler(commandLine, this.myWithMediator && this.myExecutable.isLocal() && Registry.is((String)"git.execute.with.mediator")){

            @NotNull
            protected BaseDataReader createOutputDataReader() {
                return new LineReader(this.createProcessOutReader(), this.readerOptions().policy(), new BufferingTextSplitter((line, isCr) -> GitLineHandler.this.onLineAvailable(line, isCr, ProcessOutputTypes.STDOUT)), this.myPresentableName);
            }

            @NotNull
            protected BaseDataReader createErrorDataReader() {
                return new LineReader(this.createProcessErrReader(), this.readerOptions().policy(), new BufferingTextSplitter((line, isCr) -> GitLineHandler.this.onLineAvailable(line, isCr, ProcessOutputTypes.STDERR)), this.myPresentableName);
            }
        };
    }

    public void overwriteConfig(String ... params) {
        for (String param : params) {
            this.myCommandLine.getParametersList().prependAll(new String[]{"-c", param});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitLineHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationMode";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationGate";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitLineHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreAuthenticationMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoreAuthenticationMode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setAuthenticationGate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onLineAvailable";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "logOutput";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LineReader
    extends BaseDataReader {
        @NotNull
        private final Reader myReader;
        private final char @NotNull [] myInputBuffer;
        @NotNull
        private final BufferingTextSplitter myOutputProcessor;

        LineReader(@NotNull Reader reader, @NotNull BaseDataReader.SleepingPolicy sleepingPolicy, @NotNull BufferingTextSplitter outputProcessor, @NotNull String presentableName) {
            if (reader == null) {
                LineReader.$$$reportNull$$$0(0);
            }
            if (sleepingPolicy == null) {
                LineReader.$$$reportNull$$$0(1);
            }
            if (outputProcessor == null) {
                LineReader.$$$reportNull$$$0(2);
            }
            if (presentableName == null) {
                LineReader.$$$reportNull$$$0(3);
            }
            super(sleepingPolicy);
            this.myInputBuffer = new char[8192];
            this.myReader = reader;
            this.myOutputProcessor = outputProcessor;
            this.start(presentableName);
        }

        protected boolean readAvailableNonBlocking() throws IOException {
            return this.read(true);
        }

        protected boolean readAvailableBlocking() throws IOException {
            return this.read(false);
        }

        private boolean read(boolean checkReaderReady) throws IOException {
            int n;
            boolean read = false;
            while ((!checkReaderReady || this.myReader.ready()) && (n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read = true;
                this.myOutputProcessor.process(this.myInputBuffer, n);
            }
            return read;
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                LineReader.$$$reportNull$$$0(4);
            }
            Future<?> future2 = ProcessIOExecutorService.INSTANCE.submit(runnable2);
            if (future2 == null) {
                LineReader.$$$reportNull$$$0(5);
            }
            return future2;
        }

        protected void close() throws IOException {
            try {
                this.myReader.close();
            }
            finally {
                this.myOutputProcessor.flush();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sleepingPolicy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputProcessor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitLineHandler$LineReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitLineHandler$LineReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

