/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.mvstore.Cursor;
import org.jetbrains.mvstore.CursorPos;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.KeyManager;
import org.jetbrains.mvstore.LeafPage;
import org.jetbrains.mvstore.MVStore;
import org.jetbrains.mvstore.MVStoreException;
import org.jetbrains.mvstore.MapMetadata;
import org.jetbrains.mvstore.NonLeafPage;
import org.jetbrains.mvstore.ObjectKeyManager;
import org.jetbrains.mvstore.Page;
import org.jetbrains.mvstore.RootReference;
import org.jetbrains.mvstore.type.DataType;
import org.jetbrains.mvstore.type.KeyableDataType;

public final class MVMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final MVStore store;
    private final AtomicReference<RootReference<K, V>> root;
    private final int id;
    private final long createVersion;
    private final KeyableDataType<K> keyType;
    private final DataType<V> valueType;
    private final boolean singleWriter;
    private final K[] keysBuffer;
    private final V[] valuesBuffer;
    private final Object lock;
    private volatile boolean notificationRequested;
    private volatile boolean closed;
    private boolean readOnly;
    private boolean isVolatile;
    static final long INITIAL_VERSION = -1L;

    private MVMap(MVStore store, int id, boolean singleWriter, @NotNull MapMetadata config, KeyableDataType<K> keyType, DataType<V> valueType) {
        if (config == null) {
            MVMap.$$$reportNull$$$0(0);
        }
        this(store, keyType, valueType, id, config.createVersion, new AtomicReference<RootReference<K, V>>(), singleWriter);
        this.setInitialRoot(this.createEmptyLeaf(), store.getCurrentVersion());
    }

    private MVMap(MVMap<K, V> source) {
        this(source.store, source.keyType, source.valueType, source.id, source.createVersion, new AtomicReference<RootReference<K, V>>(source.root.get()), source.singleWriter);
    }

    MVMap(MVStore store, int id, KeyableDataType<K> keyType, DataType<V> valueType) {
        this(store, keyType, valueType, id, 0L, new AtomicReference<RootReference<K, V>>(), false);
        this.setInitialRoot(this.createEmptyLeaf(), store.getCurrentVersion());
    }

    private MVMap(MVStore store, KeyableDataType<K> keyType, DataType<V> valueType, int id, long createVersion, AtomicReference<RootReference<K, V>> root, boolean singleWriter) {
        this.lock = new Object();
        this.store = store;
        this.id = id;
        this.createVersion = createVersion;
        this.keyType = keyType;
        this.valueType = valueType;
        this.root = root;
        this.keysBuffer = singleWriter ? keyType.createStorage(store.getKeysPerPage()) : null;
        this.valuesBuffer = singleWriter ? valueType.createStorage(store.getKeysPerPage()) : null;
        this.singleWriter = singleWriter;
    }

    @Override
    public V put(K key, @NotNull V value) {
        if (value == null) {
            MVMap.$$$reportNull$$$0(1);
        }
        return (V)this.operate(key, value, DecisionMaker.PUT);
    }

    public K firstKey() {
        return this.getFirstLast(true);
    }

    public K lastKey() {
        return this.getFirstLast(false);
    }

    public K getKey(long index) {
        if (index < 0L || index >= this.sizeAsLong()) {
            return null;
        }
        Page<K, V> p = this.getRootPage();
        long offset = 0L;
        while (true) {
            long c;
            int i;
            if (p.isLeaf()) {
                if (index >= offset + (long)p.getKeyCount()) {
                    return null;
                }
                return p.getKey((int)(index - offset));
            }
            int size = this.getChildPageCount(p);
            for (i = 0; i < size && index >= (c = p.getCounts(i)) + offset; ++i) {
                offset += c;
            }
            if (i == size) {
                return null;
            }
            p = p.getChildPage(i);
        }
    }

    public List<K> keyList() {
        return new AbstractList<K>(){

            @Override
            public K get(int index) {
                return MVMap.this.getKey(index);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public int indexOf(Object key) {
                return (int)MVMap.this.getKeyIndex(key);
            }
        };
    }

    public long getKeyIndex(K key) {
        Page<K, V> p = this.getRootPage();
        if (p.getTotalCount() == 0L) {
            return -1L;
        }
        long offset = 0L;
        while (true) {
            int x = p.binarySearch(key);
            if (p.isLeaf()) {
                if (x < 0) {
                    offset = -offset;
                }
                return offset + (long)x;
            }
            if (x++ < 0) {
                x = -x;
            }
            for (int i = 0; i < x; ++i) {
                offset += p.getCounts(i);
            }
            p = p.getChildPage(x);
        }
    }

    private K getFirstLast(boolean first) {
        Page<K, V> p = this.getRootPage();
        return this.getFirstLast(p, first);
    }

    private K getFirstLast(Page<K, V> p, boolean first) {
        if (p.getTotalCount() == 0L) {
            return null;
        }
        while (!p.isLeaf()) {
            p = p.getChildPage(first ? 0 : this.getChildPageCount(p) - 1);
        }
        return p.getKey(first ? 0 : p.getKeyCount() - 1);
    }

    public K higherKey(K key) {
        return this.getMinMax(key, false, true);
    }

    public K higherKey(RootReference<K, V> rootRef, K key) {
        return this.getMinMax(rootRef, key, false, true);
    }

    public K ceilingKey(K key) {
        return this.getMinMax(key, false, false);
    }

    public K floorKey(K key) {
        return this.getMinMax(key, true, false);
    }

    public K lowerKey(K key) {
        return this.getMinMax(key, true, true);
    }

    public K lowerKey(RootReference<K, V> rootRef, K key) {
        return this.getMinMax(rootRef, key, true, true);
    }

    private K getMinMax(K key, boolean min, boolean excluding) {
        return this.getMinMax(this.flushAndGetRoot(), key, min, excluding);
    }

    private K getMinMax(RootReference<K, V> rootRef, K key, boolean min, boolean excluding) {
        return this.getMinMax(rootRef.root, key, min, excluding);
    }

    private K getMinMax(Page<K, V> p, K key, boolean min, boolean excluding) {
        int x = p.binarySearch(key);
        if (p.isLeaf()) {
            if (x < 0) {
                x = -x - (min ? 2 : 1);
            } else if (excluding) {
                x += min ? -1 : 1;
            }
            if (x < 0 || x >= p.getKeyCount()) {
                return null;
            }
            return p.getKey(x);
        }
        if (x++ < 0) {
            x = -x;
        }
        while (x >= 0 && x < this.getChildPageCount(p)) {
            K k = this.getMinMax(p.getChildPage(x), key, min, excluding);
            if (k != null) {
                return k;
            }
            x += min ? -1 : 1;
        }
        return null;
    }

    @Override
    public V get(Object key) {
        return Page.get(this.getRootPage(), key);
    }

    @Override
    public boolean containsKey(Object key) {
        return Page.get(this.getRootPage(), key) != null;
    }

    @Override
    public void clear() {
        this.clearIt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RootReference<K, V> clearIt() {
        Page<K, V> emptyRootPage = this.createEmptyLeaf();
        int attempt = 0;
        RootReference<K, V> rootReference;
        while ((rootReference = this.flushAndGetRoot()).getTotalCount() != 0L) {
            boolean locked = rootReference.isLockedByCurrentThread();
            if (!locked) {
                if (attempt++ == 0) {
                    this.beforeWrite();
                } else if (attempt > 3 || rootReference.isLocked()) {
                    rootReference = this.lockRoot(rootReference, attempt);
                    locked = true;
                }
            }
            Page rootPage = rootReference.root;
            long version = rootReference.version;
            try {
                if (!locked && (rootReference = rootReference.updateRootPage(emptyRootPage, attempt)) == null) continue;
                this.store.registerUnsavedMemory(rootPage.removeAllRecursive(version));
                rootPage = emptyRootPage;
                RootReference<K, V> rootReference2 = rootReference;
                return rootReference2;
            }
            finally {
                if (!locked) continue;
                this.unlockRoot(rootPage);
                continue;
            }
            break;
        }
        return rootReference;
    }

    void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public V remove(Object key) {
        return (V)this.operate(key, null, DecisionMaker.REMOVE);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)this.operate(key, value, DecisionMaker.IF_ABSENT);
    }

    @Override
    public boolean remove(Object key, Object value) {
        EqualsDecisionMaker<Object> decisionMaker = new EqualsDecisionMaker<Object>(this.getValueType(), value);
        this.operate(key, null, decisionMaker);
        return decisionMaker.getDecision() != Decision.ABORT;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        EqualsDecisionMaker<V> decisionMaker = new EqualsDecisionMaker<V>(this.getValueType(), oldValue);
        this.operate(key, newValue, decisionMaker);
        return decisionMaker.getDecision() != Decision.ABORT;
    }

    @Override
    public V replace(K key, V value) {
        return (V)this.operate(key, value, DecisionMaker.IF_PRESENT);
    }

    public KeyableDataType<K> getKeyType() {
        return this.keyType;
    }

    public DataType<V> getValueType() {
        return this.valueType;
    }

    boolean isSingleWriter() {
        return this.singleWriter;
    }

    void setRootPageInfo(long pageInfo, long version) {
        Page<K, V> root = this.readOrCreateRootPage(pageInfo);
        this.setInitialRoot(root, version);
        this.setWriteVersion(this.store.getCurrentVersion());
    }

    private Page<K, V> readOrCreateRootPage(long rootPageInfo) {
        return rootPageInfo == 0L ? this.createEmptyLeaf() : this.store.readPage(this, rootPageInfo);
    }

    public Iterator<K> keyIterator(K from) {
        return this.cursor(from, null, false);
    }

    public Iterator<K> keyIteratorReverse(K from) {
        return this.cursor(from, null, true);
    }

    boolean rewritePage(long pageInfo) {
        Page p = this.store.readPage(this, pageInfo);
        if (p.getKeyCount() == 0) {
            return true;
        }
        assert (p.isSaved());
        if (!this.isClosed()) {
            boolean result;
            RewriteDecisionMaker decisionMaker = new RewriteDecisionMaker(p.getPosition());
            Object decision = this.operate(p.getKey(0), null, decisionMaker);
            boolean bl = result = decisionMaker.getDecision() != Decision.ABORT;
            assert (!result || decision != null);
            return result;
        }
        return false;
    }

    public Cursor<K, V> cursor(K from) {
        return this.cursor(from, null, false);
    }

    public Cursor<K, V> cursor(K from, K to, boolean reverse) {
        return this.cursor(this.flushAndGetRoot(), from, to, reverse);
    }

    public Cursor<K, V> cursor(RootReference<K, V> rootReference, K from, K to, boolean reverse) {
        return new Cursor<K, V>(rootReference, from, to, reverse);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final RootReference<K, V> rootReference = this.flushAndGetRoot();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Cursor cursor = MVMap.this.cursor(rootReference, null, null, false);
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return cursor.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object k = cursor.next();
                        return Map.entry(k, cursor.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return MVMap.this.containsKey(o);
            }
        };
    }

    @Override
    public Set<K> keySet() {
        final RootReference<K, V> rootReference = this.flushAndGetRoot();
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return MVMap.this.cursor(rootReference, null, null, false);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return MVMap.this.containsKey(o);
            }
        };
    }

    @NotNull
    public CharSequence getName() {
        CharSequence charSequence = Objects.requireNonNull(this.store.getMapName(this.id));
        if (charSequence == null) {
            MVMap.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    public MVStore getStore() {
        return this.store;
    }

    private boolean isPersistent() {
        return this.store.getFileStore() != null && !this.isVolatile;
    }

    public int getId() {
        return this.id;
    }

    public Page<K, V> getRootPage() {
        return this.flushAndGetRoot().root;
    }

    public RootReference<K, V> getRoot() {
        return this.root.get();
    }

    public RootReference<K, V> flushAndGetRoot() {
        RootReference<K, V> rootReference = this.getRoot();
        if (this.singleWriter && rootReference.getAppendCounter() > 0) {
            return this.flushAppendBuffer(rootReference, true);
        }
        return rootReference;
    }

    void setInitialRoot(Page<K, V> rootPage, long version) {
        this.root.set(new RootReference<K, V>(rootPage, version));
    }

    boolean compareAndSetRoot(RootReference<K, V> expectedRootReference, RootReference<K, V> updatedRootReference) {
        return this.root.compareAndSet(expectedRootReference, updatedRootReference);
    }

    void rollbackTo(long version) {
        if (version > this.createVersion) {
            this.rollbackRoot(version);
        }
    }

    boolean rollbackRoot(long version) {
        RootReference previous;
        RootReference<K, V> rootReference = this.flushAndGetRoot();
        while (rootReference.version >= version && (previous = rootReference.previous) != null) {
            if (!this.root.compareAndSet(rootReference, previous)) continue;
            rootReference = previous;
            this.closed = false;
        }
        this.setWriteVersion(version);
        return rootReference.version < version;
    }

    private static <K, V> boolean updateRoot(RootReference<K, V> expectedRootReference, Page<K, V> newRootPage, int attemptUpdateCounter) {
        return expectedRootReference.updateRootPage(newRootPage, attemptUpdateCounter) != null;
    }

    private void removeUnusedOldVersions(RootReference<K, V> rootReference) {
        rootReference.removeUnusedOldVersions(this.store.getOldestVersionToKeep());
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    private void beforeWrite() {
        assert (!this.getRoot().isLockedByCurrentThread()) : this.getRoot();
        if (this.closed) {
            throw new MVStoreException(4, "Map " + this.store.getMapName(this.getId()) + "(id=" + this.getId() + ") is closed", this.store.getPanicException());
        }
        if (this.readOnly) {
            throw new UnsupportedOperationException("Map is read-only: " + this.toString());
        }
        this.store.beforeWrite(this);
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int size() {
        long size = this.sizeAsLong();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public long sizeAsLong() {
        return this.getRoot().getTotalCount();
    }

    @Override
    public boolean isEmpty() {
        return this.sizeAsLong() == 0L;
    }

    long getCreateVersion() {
        return this.createVersion;
    }

    public MVMap<K, V> openVersion(long version) {
        RootReference previous;
        if (this.readOnly) {
            throw new UnsupportedOperationException("This map is read-only; need to call the method on the writable map");
        }
        if (version < this.createVersion) {
            throw new IllegalArgumentException("Unknown version " + version + "; this map was created in version " + this.createVersion);
        }
        RootReference<K, V> rootReference = this.flushAndGetRoot();
        this.removeUnusedOldVersions(rootReference);
        while ((previous = rootReference.previous) != null && previous.version >= version) {
            rootReference = previous;
        }
        if (previous == null && version < this.store.getOldestVersionToKeep()) {
            throw new IllegalArgumentException("Unknown version " + version);
        }
        MVMap m = this.openReadOnly(rootReference.root, version);
        assert (m.getVersion() <= version) : m.getVersion() + " <= " + version;
        return m;
    }

    MVMap<K, V> openReadOnly(long rootPageInfo, long version) {
        Page<K, V> root = this.readOrCreateRootPage(rootPageInfo);
        return this.openReadOnly(root, version);
    }

    private MVMap<K, V> openReadOnly(Page<K, V> root, long version) {
        MVMap<K, V> m = new MVMap<K, V>(this);
        m.readOnly = true;
        m.setInitialRoot(root, version);
        return m;
    }

    public long getVersion() {
        return this.getRoot().getVersion();
    }

    boolean hasChangesSince(long version) {
        return this.getRoot().hasChangesSince(version, this.isPersistent());
    }

    int getChildPageCount(Page<K, V> p) {
        return p.getRawChildPageCount();
    }

    public String getType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RootReference<K, V> setWriteVersion(long writeVersion) {
        int attempt = 0;
        while (true) {
            RootReference<K, V> rootReference = this.flushAndGetRoot();
            if (rootReference.version >= writeVersion) {
                return rootReference;
            }
            if (this.isClosed() && rootReference.getVersion() + 1L < this.store.getOldestVersionToKeep()) {
                this.store.deregisterMapRoot(this.id);
                return null;
            }
            RootReference<K, V> lockedRootReference = null;
            if (++attempt > 3 || rootReference.isLocked()) {
                lockedRootReference = this.lockRoot(rootReference, attempt);
                rootReference = this.flushAndGetRoot();
            }
            try {
                if ((rootReference = rootReference.tryUnlockAndUpdateVersion(writeVersion, attempt)) == null) continue;
                lockedRootReference = null;
                this.removeUnusedOldVersions(rootReference);
                RootReference<K, V> rootReference2 = rootReference;
                return rootReference2;
            }
            finally {
                if (lockedRootReference == null) continue;
                this.unlockRoot();
                continue;
            }
            break;
        }
    }

    Page<K, V> createEmptyLeaf() {
        return Page.createEmptyLeaf(this);
    }

    void copyFrom(MVMap<K, V> sourceMap) {
        MVStore.TxCounter txCounter = this.store.registerVersionUsage();
        try {
            this.beforeWrite();
            this.copy(sourceMap.getRootPage(), null, 0);
        }
        finally {
            this.store.deregisterVersionUsage(txCounter);
        }
    }

    private void copy(Page<K, V> source, Page<K, V> parent, int index) {
        Page<K, V> target = source.copy(this);
        if (parent == null) {
            this.setInitialRoot(target, -1L);
        } else {
            ((NonLeafPage)parent).setChild(index, target);
        }
        if (!source.isLeaf()) {
            for (int i = 0; i < this.getChildPageCount(target); ++i) {
                if (source.getChildPagePos(i) == 0L) continue;
                this.copy(source.getChildPage(i), target, i);
            }
            target.setComplete();
        }
        this.store.registerUnsavedMemory(target.getMemory());
        if (this.store.isSaveNeeded()) {
            this.store.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootReference<K, V> flushAppendBuffer(RootReference<K, V> rootReference, boolean fullFlush) {
        boolean preLocked;
        boolean locked = preLocked = rootReference.isLockedByCurrentThread();
        int keysPerPage = this.store.getKeysPerPage();
        try {
            int keyCount;
            int availabilityThreshold;
            IntValueHolder unsavedMemoryHolder = new IntValueHolder();
            int attempt = 0;
            int n = availabilityThreshold = fullFlush ? 0 : keysPerPage - 1;
            while ((keyCount = rootReference.getAppendCounter()) > availabilityThreshold) {
                V[] values;
                if (!locked) {
                    if ((rootReference = this.tryLock(rootReference, ++attempt)) == null) {
                        rootReference = this.getRoot();
                        continue;
                    }
                    locked = true;
                }
                Page rootPage = rootReference.root;
                long version = rootReference.version;
                CursorPos pos = rootPage.getAppendCursorPos(null);
                assert (pos != null);
                assert (pos.index < 0) : pos.index;
                int index = -pos.index - 1;
                assert (index == pos.page.getKeyCount()) : index + " != " + pos.page.getKeyCount();
                Page p = pos.page;
                CursorPos tip = pos;
                pos = pos.parent;
                int remainingBuffer = 0;
                Page page = null;
                int available = keysPerPage - p.getKeyCount();
                if (available > 0) {
                    if (keyCount <= available) {
                        p = LeafPage.expand((LeafPage)p, keyCount, this.keysBuffer, this.valuesBuffer);
                    } else {
                        p = LeafPage.expand((LeafPage)p, available, this.keysBuffer, this.valuesBuffer);
                        keyCount -= available;
                        if (fullFlush) {
                            ObjectKeyManager<K> keys = new ObjectKeyManager<K>(this, this.keysBuffer, available, keyCount);
                            values = this.getValueType().createStorage(keyCount);
                            System.arraycopy(this.valuesBuffer, available, values, 0, keyCount);
                            page = Page.createLeaf(this, keys, values);
                        } else {
                            System.arraycopy(this.keysBuffer, available, this.keysBuffer, 0, keyCount);
                            System.arraycopy(this.valuesBuffer, available, this.valuesBuffer, 0, keyCount);
                            remainingBuffer = keyCount;
                        }
                    }
                } else {
                    tip = tip.parent;
                    K[] newKeys = Arrays.copyOf(this.keysBuffer, keyCount);
                    values = Arrays.copyOf(this.valuesBuffer, keyCount);
                    page = new LeafPage<K, V>(this, new ObjectKeyManager<K>(newKeys, this.keyType.getMemory(newKeys)), values, 22 + this.valueType.getMemory(values));
                }
                unsavedMemoryHolder.value = 0;
                if (page != null) {
                    assert (page.map == this);
                    assert (page.getKeyCount() > 0);
                    Object key = page.getKey(0);
                    unsavedMemoryHolder.value += page.getMemory();
                    while (true) {
                        if (pos == null) {
                            if (p.getKeyCount() == 0) {
                                p = page;
                                break;
                            }
                            Page.PageReference<K, V>[] children = Page.createRefStorage(2);
                            children[0] = new Page.PageReference(p);
                            children[1] = new Page.PageReference<K, V>(page);
                            unsavedMemoryHolder.value += p.getMemory();
                            p = new NonLeafPage(this, new ObjectKeyManager(this, key), NonLeafPage.calculateSerializedDataSize(children.length), children, p.getTotalCount() + page.getTotalCount());
                            break;
                        }
                        Page childPage = p;
                        index = pos.index;
                        pos = pos.parent;
                        p = NonLeafPage.replaceSplitChild((NonLeafPage)pos.page, index, key, childPage, page);
                        keyCount = p.getKeyCount();
                        int at = keyCount - 2;
                        if (keyCount <= keysPerPage && (at <= 0 || (long)p.getMemory() < this.store.nonLeafPageSplitSize)) break;
                        key = p.getKey(at);
                        page = p.split(at, false);
                        p = p.split(at, true);
                        unsavedMemoryHolder.value += p.getMemory() + page.getMemory();
                    }
                }
                if ((rootReference = rootReference.updatePageAndLockedStatus(p = MVMap.replacePage(pos, p, unsavedMemoryHolder), preLocked || this.isPersistent(), remainingBuffer)) != null) {
                    boolean bl = locked = preLocked || this.isPersistent();
                    if (this.isPersistent() && tip != null) {
                        this.store.registerUnsavedMemory(unsavedMemoryHolder.value + tip.processRemovalInfo(version));
                    }
                    assert (rootReference.getAppendCounter() <= availabilityThreshold);
                    break;
                }
                rootReference = this.getRoot();
            }
        }
        finally {
            if (locked && !preLocked) {
                rootReference = this.unlockRoot();
            }
        }
        return rootReference;
    }

    private static <K, V> Page<K, V> replacePage(@Nullable CursorPos<K, V> path, Page<K, V> replacement, IntValueHolder unsavedMemoryHolder) {
        int unsavedMemory;
        int n = unsavedMemory = replacement.isSaved() ? 0 : replacement.getMemory();
        while (path != null) {
            Page<K, V> child = replacement;
            replacement = NonLeafPage.replaceChild((NonLeafPage)path.page, path.index, child);
            unsavedMemory += replacement.getMemory();
            path = path.parent;
        }
        unsavedMemoryHolder.value += unsavedMemory;
        return replacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(K key, V value) {
        if (this.singleWriter) {
            this.beforeWrite();
            RootReference<K, V> rootReference = this.lockRoot(this.getRoot(), 1);
            int appendCounter = rootReference.getAppendCounter();
            try {
                int keysPerPage = this.store.getKeysPerPage();
                if (appendCounter >= keysPerPage) {
                    rootReference = this.flushAppendBuffer(rootReference, false);
                    appendCounter = rootReference.getAppendCounter();
                    assert (appendCounter < keysPerPage);
                }
                this.keysBuffer[appendCounter] = key;
                this.valuesBuffer[appendCounter] = value;
                ++appendCounter;
            }
            finally {
                this.unlockRoot(appendCounter);
            }
        } else {
            this.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimLast() {
        if (this.singleWriter) {
            boolean useRegularRemove;
            RootReference<K, V> rootReference = this.getRoot();
            int appendCounter = rootReference.getAppendCounter();
            boolean bl = useRegularRemove = appendCounter == 0;
            if (!useRegularRemove) {
                rootReference = this.lockRoot(rootReference, 1);
                try {
                    appendCounter = rootReference.getAppendCounter();
                    boolean bl2 = useRegularRemove = appendCounter == 0;
                    if (!useRegularRemove) {
                        --appendCounter;
                    }
                }
                finally {
                    this.unlockRoot(appendCounter);
                }
            }
            if (useRegularRemove) {
                Page lastLeaf = rootReference.root.getAppendCursorPos(null).page;
                assert (lastLeaf.isLeaf());
                assert (lastLeaf.getKeyCount() > 0);
                Object key = lastLeaf.getKey(lastLeaf.getKeyCount() - 1);
                this.remove(key);
            }
        } else {
            this.remove(this.lastKey());
        }
    }

    @Override
    public String toString() {
        return "MVMap(store=" + this.store + ", root=" + this.root + ", id=" + this.id + ", createVersion=" + this.createVersion + ", keyType=" + this.keyType + ", valueType=" + this.valueType + ", singleWriter=" + this.singleWriter + ", notificationRequested=" + this.notificationRequested + ", closed=" + this.closed + ", readOnly=" + this.readOnly + ", isVolatile=" + this.isVolatile + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V operate(K key, V value, DecisionMaker<? super V> decisionMaker) {
        IntValueHolder unsavedMemoryHolder = new IntValueHolder();
        int attempt = 0;
        block16: while (true) {
            RootReference rootReference;
            boolean locked;
            if (!(locked = (rootReference = this.flushAndGetRoot()).isLockedByCurrentThread())) {
                if (attempt++ == 0) {
                    this.beforeWrite();
                }
                if (attempt > 3 || rootReference.isLocked()) {
                    rootReference = this.lockRoot(rootReference, attempt);
                    locked = true;
                }
            }
            Page rootPage = rootReference.root;
            long version = rootReference.version;
            unsavedMemoryHolder.value = 0;
            try {
                CursorPos cursorPosition = CursorPos.traverseDown(rootPage, key);
                if (!locked && rootReference != this.getRoot()) continue;
                Page page = cursorPosition.page;
                int index = cursorPosition.index;
                CursorPos tip = cursorPosition;
                cursorPosition = cursorPosition.parent;
                V result = index < 0 ? null : (V)page.getValue(index);
                Decision decision = decisionMaker.decide(result, value, tip);
                block8 : switch (decision) {
                    case REPEAT: {
                        decisionMaker.reset();
                        continue block16;
                    }
                    case ABORT: {
                        if (!locked && rootReference != this.getRoot()) {
                            decisionMaker.reset();
                            continue block16;
                        }
                        V v = result;
                        return v;
                    }
                    case REMOVE: {
                        int keyCount;
                        if (index < 0) {
                            if (!locked && rootReference != this.getRoot()) {
                                decisionMaker.reset();
                                continue block16;
                            }
                            V v = null;
                            return v;
                        }
                        if (page.getTotalCount() == 1L && cursorPosition != null) {
                            do {
                                page = cursorPosition.page;
                                index = cursorPosition.index;
                                cursorPosition = cursorPosition.parent;
                            } while ((keyCount = page.getKeyCount()) == 0 && cursorPosition != null);
                            if (keyCount <= 1) {
                                if (keyCount == 1) {
                                    assert (index <= 1);
                                    page = page.getChildPage(1 - index);
                                    break;
                                }
                                page = Page.createEmptyLeaf(this);
                                break;
                            }
                        }
                        page = page.remove(index);
                        break;
                    }
                    case PUT: {
                        int keyCount;
                        value = decisionMaker.selectValue(result, value);
                        if (index < 0) {
                            page = LeafPage.add((LeafPage)page, -index - 1, key, value);
                            keyCount = page.getKeyCount();
                            while (this.isSplitNeeded(page, keyCount)) {
                                long totalCount = page.getTotalCount();
                                int at = keyCount >> 1;
                                Object k = page.getKey(at);
                                KeyManager keyManagerAt = cursorPosition == null ? page.keyManager.copy(at, at + 1, this) : null;
                                Page nextSiblingPage = page.split(at, false);
                                page = page.split(at, true);
                                unsavedMemoryHolder.value += page.getMemory() + nextSiblingPage.getMemory();
                                if (cursorPosition == null) {
                                    Page.PageReference[] children = new Page.PageReference[]{new Page.PageReference(page), new Page.PageReference(nextSiblingPage)};
                                    page = new NonLeafPage(this, keyManagerAt, NonLeafPage.calculateSerializedDataSize(children.length), children, totalCount);
                                    break block8;
                                }
                                NonLeafPage parentPage = (NonLeafPage)cursorPosition.page;
                                index = cursorPosition.index;
                                cursorPosition = cursorPosition.parent;
                                page = NonLeafPage.replaceSplitChild(parentPage, index, k, page, nextSiblingPage);
                                keyCount = page.getKeyCount();
                            }
                            break;
                        }
                        page = LeafPage.replaceValue((LeafPage)page, index, value);
                    }
                }
                rootPage = MVMap.replacePage(cursorPosition, page, unsavedMemoryHolder);
                if (!locked && (rootReference = rootReference.updateRootPage(rootPage, attempt)) == null) {
                    decisionMaker.reset();
                    continue;
                }
                this.store.registerUnsavedMemory(unsavedMemoryHolder.value + tip.processRemovalInfo(version));
                V v = result;
                return v;
            }
            finally {
                if (!locked) continue;
                this.unlockRoot(rootPage);
                continue;
            }
            break;
        }
    }

    private boolean isSplitNeeded(Page<K, V> page, int keyCount) {
        if (page.isLeaf()) {
            return keyCount > this.store.getKeysPerPage() || keyCount > 1 && (long)page.getMemory() > this.store.leafPageSplitSize;
        }
        if (keyCount < 3) {
            return false;
        }
        int pageMemory = page.getMemory();
        return keyCount > this.store.getKeysPerPage() && pageMemory > 4096 || (long)pageMemory > this.store.nonLeafPageSplitSize;
    }

    private RootReference<K, V> lockRoot(RootReference<K, V> rootReference, int attempt) {
        RootReference<K, V> lockedRootReference;
        while ((lockedRootReference = this.tryLock(rootReference, attempt++)) == null) {
            rootReference = this.getRoot();
        }
        return lockedRootReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootReference<K, V> tryLock(RootReference<K, V> rootReference, int attempt) {
        RootReference<K, V> lockedRootReference = rootReference.tryLock(attempt);
        if (lockedRootReference != null) {
            return lockedRootReference;
        }
        assert (!rootReference.isLockedByCurrentThread()) : rootReference;
        RootReference oldRootReference = rootReference.previous;
        int contention = 1;
        if (oldRootReference != null) {
            long updateAttemptCounter = rootReference.updateAttemptCounter - oldRootReference.updateAttemptCounter;
            assert (updateAttemptCounter >= 0L) : updateAttemptCounter;
            long updateCounter = rootReference.updateCounter - oldRootReference.updateCounter;
            assert (updateCounter >= 0L) : updateCounter;
            assert (updateAttemptCounter >= updateCounter) : updateAttemptCounter + " >= " + updateCounter;
            contention += (int)((updateAttemptCounter + 1L) / (updateCounter + 1L));
        }
        if (attempt > 4) {
            if (attempt <= 12) {
                Thread.yield();
            } else {
                if (attempt <= 70 - 2 * contention) {
                    try {
                        Thread.sleep(contention);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                Object object = this.lock;
                synchronized (object) {
                    this.notificationRequested = true;
                    try {
                        this.lock.wait(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private RootReference<K, V> unlockRoot() {
        return this.unlockRoot(null, -1);
    }

    private RootReference<K, V> unlockRoot(Page<K, V> newRootPage) {
        return this.unlockRoot(newRootPage, -1);
    }

    private void unlockRoot(int appendCounter) {
        this.unlockRoot(null, appendCounter);
    }

    private RootReference<K, V> unlockRoot(Page<K, V> newRootPage, int appendCounter) {
        RootReference<K, V> rootReference;
        RootReference<K, V> updatedRootReference;
        do {
            rootReference = this.getRoot();
            assert (rootReference.isLockedByCurrentThread());
        } while ((updatedRootReference = rootReference.updatePageAndLockedStatus(newRootPage == null ? rootReference.root : newRootPage, false, appendCounter == -1 ? rootReference.getAppendCounter() : appendCounter)) == null);
        this.notifyWaiters();
        return updatedRootReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiters() {
        if (this.notificationRequested) {
            Object object = this.lock;
            synchronized (object) {
                this.notificationRequested = false;
                this.lock.notify();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/mvstore/MVMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/mvstore/MVMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IntValueHolder {
        int value;

        IntValueHolder() {
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    private static final class RewriteDecisionMaker<V>
    extends DecisionMaker<V> {
        private final long pagePos;
        private Decision decision;

        RewriteDecisionMaker(long pagePos) {
            this.pagePos = pagePos;
        }

        @Override
        public Decision decide(V existingValue, V providedValue, CursorPos<?, ?> tip) {
            assert (this.decision == null);
            this.decision = Decision.ABORT;
            if (!DataUtil.isLeafPage(this.pagePos)) {
                while ((tip = tip.parent) != null) {
                    if (tip.page.getPosition() != this.pagePos) continue;
                    this.decision = this.decide(existingValue, providedValue);
                    break;
                }
            } else if (tip.page.getPosition() == this.pagePos) {
                this.decision = this.decide(existingValue, providedValue);
            }
            return this.decision;
        }

        @Override
        public Decision decide(V existingValue, V providedValue) {
            this.decision = existingValue == null ? Decision.ABORT : Decision.PUT;
            return this.decision;
        }

        @Override
        public <T extends V> T selectValue(T existingValue, T providedValue) {
            return existingValue;
        }

        @Override
        public void reset() {
            this.decision = null;
        }

        Decision getDecision() {
            return this.decision;
        }

        public String toString() {
            return "rewrite";
        }
    }

    private static final class EqualsDecisionMaker<V>
    extends DecisionMaker<V> {
        private final DataType<V> dataType;
        private final V expectedValue;
        private Decision decision;

        EqualsDecisionMaker(DataType<V> dataType, V expectedValue) {
            this.dataType = dataType;
            this.expectedValue = expectedValue;
        }

        @Override
        public Decision decide(V existingValue, V providedValue) {
            assert (this.decision == null);
            this.decision = this.expectedValue == existingValue || existingValue != null && this.expectedValue != null && this.dataType.equals(this.expectedValue, existingValue) ? (providedValue == null ? Decision.REMOVE : Decision.PUT) : Decision.ABORT;
            return this.decision;
        }

        @Override
        public void reset() {
            this.decision = null;
        }

        Decision getDecision() {
            return this.decision;
        }

        public String toString() {
            return "equals_to " + this.expectedValue;
        }
    }

    public static abstract class DecisionMaker<V> {
        public static final DecisionMaker<Object> DEFAULT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return providedValue == null ? Decision.REMOVE : Decision.PUT;
            }

            public String toString() {
                return "default";
            }
        };
        public static final DecisionMaker<Object> PUT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return Decision.PUT;
            }

            public String toString() {
                return "put";
            }
        };
        public static final DecisionMaker<Object> REMOVE = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return Decision.REMOVE;
            }

            public String toString() {
                return "remove";
            }
        };
        static final DecisionMaker<Object> IF_ABSENT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return existingValue == null ? Decision.PUT : Decision.ABORT;
            }

            public String toString() {
                return "if_absent";
            }
        };
        static final DecisionMaker<Object> IF_PRESENT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return existingValue != null ? Decision.PUT : Decision.ABORT;
            }

            public String toString() {
                return "if_present";
            }
        };

        public Decision decide(V existingValue, V providedValue, CursorPos<?, ?> tip) {
            return this.decide(existingValue, providedValue);
        }

        public abstract Decision decide(V var1, V var2);

        public <T extends V> T selectValue(T existingValue, T providedValue) {
            return providedValue;
        }

        public void reset() {
        }
    }

    public static enum Decision {
        ABORT,
        REMOVE,
        PUT,
        REPEAT;

    }

    public static final class Builder<K, V>
    extends BasicBuilder<MVMap<K, V>, K, V> {
        private boolean singleWriter;

        public Builder<K, V> keyType(KeyableDataType<K> dataType) {
            this.setKeyType(dataType);
            return this;
        }

        public Builder<K, V> valueType(DataType<V> dataType) {
            this.setValueType(dataType);
            return this;
        }

        public Builder<K, V> singleWriter() {
            this.singleWriter = true;
            return this;
        }

        @Override
        public MVMap<K, V> create(MVStore store, int id, MapMetadata config) {
            Object type = null;
            if (type == null || type.equals("rtree")) {
                return new MVMap(store, id, this.singleWriter, config, this.getKeyType(), this.getValueType());
            }
            throw new IllegalArgumentException("Incompatible map type");
        }
    }

    public static abstract class BasicBuilder<M extends MVMap<K, V>, K, V>
    implements MapBuilder<M, K, V> {
        private KeyableDataType<K> keyType;
        private DataType<V> valueType;

        protected BasicBuilder() {
        }

        @Override
        public KeyableDataType<K> getKeyType() {
            return this.keyType;
        }

        @Override
        public DataType<V> getValueType() {
            return this.valueType;
        }

        @Override
        public void setKeyType(KeyableDataType<K> keyType) {
            this.keyType = keyType;
        }

        @Override
        public void setValueType(DataType<V> valueType) {
            this.valueType = valueType;
        }

        public BasicBuilder<M, K, V> keyType(KeyableDataType<K> keyType) {
            this.setKeyType(keyType);
            return this;
        }

        public BasicBuilder<M, K, V> valueType(DataType<V> valueType) {
            this.setValueType(valueType);
            return this;
        }

        @Override
        public abstract M create(MVStore var1, int var2, MapMetadata var3);
    }

    public static interface MapBuilder<M extends MVMap<K, V>, K, V> {
        public M create(MVStore var1, int var2, MapMetadata var3);

        public KeyableDataType<K> getKeyType();

        public DataType<V> getValueType();

        public void setKeyType(KeyableDataType<K> var1);

        public void setValueType(DataType<V> var1);
    }
}

