/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.JBColor;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.AvatarPalette;
import com.intellij.util.ui.Avatars;
import com.intellij.util.ui.ColorPalette;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/ui/AvatarUtils;", "", "()V", "createRoundRectIcon", "Ljavax/swing/ImageIcon;", "image", "Ljava/awt/image/BufferedImage;", "targetSize", "", "generateColoredAvatar", "gradientSeed", "", "name", "palette", "Lcom/intellij/util/ui/ColorPalette;", "intellij.platform.util.ui"})
public final class AvatarUtils {
    @NotNull
    public static final AvatarUtils INSTANCE;

    @NotNull
    public final ImageIcon createRoundRectIcon(@NotNull BufferedImage image, int targetSize) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int n = image.getWidth();
        int n2 = image.getHeight();
        boolean bl = false;
        int size = Math.min(n, n2);
        double baseArcSize = 6.0 * (double)size / (double)targetSize;
        BufferedImage bufferedImage = ImageUtil.createRoundedImage(image, baseArcSize);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.createRoundedImage(image, baseArcSize)");
        BufferedImage rounded = bufferedImage;
        Image hiDpi = ImageUtil.ensureHiDPI(rounded, ScaleContext.create());
        return new JBImageIcon(ImageUtil.scaleImage(hiDpi, targetSize, targetSize));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BufferedImage generateColoredAvatar(@NotNull String gradientSeed, @NotNull String name, @NotNull ColorPalette palette) {
        void color1;
        Intrinsics.checkNotNullParameter((Object)gradientSeed, (String)"gradientSeed");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        Pair<Color, Color> pair = palette.gradient(gradientSeed);
        Color color = (Color)pair.component1();
        Color color2 = (Color)pair.component2();
        String shortName = Avatars.INSTANCE.initials(name);
        int size = 64;
        BufferedImage bufferedImage = ImageUtil.createImage(size, size, 2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.createImage(si\u2026feredImage.TYPE_INT_ARGB)");
        BufferedImage image = bufferedImage;
        Graphics2D g2 = image.createGraphics();
        ImageUtil.applyQualityRenderingHints(g2);
        Graphics2D graphics2D = g2;
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"g2");
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, size, size, (Color)color1));
        g2.fillRect(0, 0, size, size);
        g2.setPaint(JBColor.WHITE);
        g2.setFont(JBFont.create(new Font("Segoe UI", 0, (int)((double)size / 2.2))));
        UIUtil.drawCenteredString(g2, new Rectangle(0, 0, size, size), shortName);
        g2.dispose();
        return image;
    }

    public static /* synthetic */ BufferedImage generateColoredAvatar$default(AvatarUtils avatarUtils, String string2, String string3, ColorPalette colorPalette, int n, Object object) {
        if ((n & 4) != 0) {
            colorPalette = AvatarPalette.INSTANCE;
        }
        return avatarUtils.generateColoredAvatar(string2, string3, colorPalette);
    }

    private AvatarUtils() {
    }

    static {
        AvatarUtils avatarUtils;
        INSTANCE = avatarUtils = new AvatarUtils();
    }
}

