/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.RandomAccessDataFile;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

final class DataTable
implements Disposable,
Forceable {
    private static final Logger LOG = Logger.getInstance(DataTable.class);
    private static final int HEADER_SIZE = 32;
    private static final int DIRTY_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private final RandomAccessDataFile myFile;
    private volatile int myWasteSize;
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_WASTE_SIZE_OFFSET = 4;
    private boolean myIsDirty;

    DataTable(@NotNull Path filePath, @NotNull PagePool pool) throws IOException {
        if (filePath == null) {
            DataTable.$$$reportNull$$$0(0);
        }
        if (pool == null) {
            DataTable.$$$reportNull$$$0(1);
        }
        this.myIsDirty = false;
        this.myFile = new RandomAccessDataFile(filePath, pool);
        if (this.myFile.length() == 0L) {
            this.markDirty();
        } else {
            this.readInHeader(filePath);
        }
    }

    public boolean isCompactNecessary() {
        return (double)this.myWasteSize / (double)this.myFile.length() > 0.25 && this.myWasteSize > 0x300000;
    }

    private void readInHeader(@NotNull Path filePath) throws IOException {
        int magic;
        if (filePath == null) {
            DataTable.$$$reportNull$$$0(2);
        }
        if ((magic = this.myFile.getInt(0L)) != 523190095) {
            this.myFile.dispose();
            throw new IOException("Records table for '" + filePath + "' haven't been closed correctly. Rebuild required.");
        }
        this.myWasteSize = this.myFile.getInt(4L);
    }

    public void readBytes(long address, byte[] bytes) {
        this.myFile.get(address, bytes, 0, bytes.length);
    }

    public void writeBytes(long address, byte[] bytes) {
        this.writeBytes(address, bytes, 0, bytes.length);
    }

    public void writeBytes(long address, byte[] bytes, int off, int len) {
        this.markDirty();
        this.myFile.put(address, bytes, off, len);
    }

    public long allocateSpace(int len) {
        long result = Math.max(this.myFile.length(), 32L);
        long newLength = result + (long)len;
        this.writeBytes(newLength - 1L, new byte[]{0});
        long actualLength = this.myFile.length();
        if (actualLength != newLength) {
            LOG.error("Failed to resize the storage at: " + this.myFile + ". Required: " + newLength + ", actual: " + actualLength);
        }
        return result;
    }

    public void reclaimSpace(int len) {
        if (len > 0) {
            this.markDirty();
            this.myWasteSize += len;
        }
    }

    @Override
    public void dispose() {
        if (!this.myFile.isDisposed()) {
            this.markClean();
            this.myFile.dispose();
        }
    }

    @Override
    public void force() {
        this.markClean();
        this.myFile.force();
    }

    @Override
    public boolean isDirty() {
        return this.myIsDirty || this.myFile.isDirty();
    }

    private void markClean() {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.fillInHeader(523190095, this.myWasteSize);
        }
    }

    private void markDirty() {
        if (!this.myIsDirty) {
            this.myIsDirty = true;
            this.fillInHeader(313341156, 0);
        }
    }

    private void fillInHeader(int magic, int wasteSize) {
        this.myFile.putInt(0L, magic);
        this.myFile.putInt(4L, wasteSize);
    }

    public int getWaste() {
        return this.myWasteSize;
    }

    public long getFileSize() {
        return this.myFile.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/storage/DataTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readInHeader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

