/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.PowerService;
import com.intellij.util.io.PowerStatus;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/io/LinuxPowerService;", "Lcom/intellij/util/io/PowerService;", "()V", "classDirectory", "Ljava/io/File;", "read", "", "device", "key", "status", "Lcom/intellij/util/io/PowerStatus;", "intellij.platform.ide.util.io.impl"})
final class LinuxPowerService
implements PowerService {
    private final File classDirectory = new File("/sys/class/power_supply");

    @Override
    @NotNull
    public PowerStatus status() {
        File[] fileArray = this.classDirectory.listFiles();
        if (fileArray == null) {
            throw (Throwable)new IOException("can't enumerate devices");
        }
        File[] devices = fileArray;
        if (PowerService.Companion.getLOG$intellij_platform_ide_util_io_impl().isDebugEnabled()) {
            PowerService.Companion.getLOG$intellij_platform_ide_util_io_impl().debug("devices=" + devices.length);
        }
        boolean online = false;
        boolean discharging = false;
        File[] fileArray2 = devices;
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            String state;
            File device;
            File file2 = device = fileArray2[i];
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"device");
            String type = this.read(file2, "type");
            if (PowerService.Companion.getLOG$intellij_platform_ide_util_io_impl().isDebugEnabled()) {
                PowerService.Companion.getLOG$intellij_platform_ide_util_io_impl().debug(device.getName() + " type=" + type);
            }
            if (Intrinsics.areEqual((Object)type, (Object)"Mains")) {
                state = this.read(device, "online");
                if (PowerService.Companion.getLOG$intellij_platform_ide_util_io_impl().isDebugEnabled()) {
                    PowerService.Companion.getLOG$intellij_platform_ide_util_io_impl().debug("  online=" + state);
                }
                if (!Intrinsics.areEqual((Object)state, (Object)"1")) continue;
                online = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)"Battery")) continue;
            state = this.read(device, "status");
            if (PowerService.Companion.getLOG$intellij_platform_ide_util_io_impl().isDebugEnabled()) {
                PowerService.Companion.getLOG$intellij_platform_ide_util_io_impl().debug("  status=" + state);
            }
            if (!Intrinsics.areEqual((Object)state, (Object)"Discharging")) continue;
            discharging = true;
        }
        return online ? PowerStatus.AC : (discharging ? PowerStatus.BATTERY : PowerStatus.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String read(File device, String key) {
        Object object;
        try {
            String string2;
            object = new BufferedReader(new FileReader(new File(device, key)));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl3 = false;
                String string3 = it.readLine();
                string2 = string3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BufferedReader(FileReade\u2026))).use { it.readLine() }");
            object = string2;
        }
        catch (IOException e) {
            object = "-";
        }
        return object;
    }

    public LinuxPowerService() {
        if (!this.classDirectory.isDirectory()) {
            throw (Throwable)new IOException("not a directory: " + this.classDirectory);
        }
    }
}

