/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.StorageLockContext;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class IntToIntBtree {
    private static final int HAS_ZERO_KEY_MASK = -16777216;
    static final boolean doSanityCheck = false;
    static final boolean doDump = false;
    final int pageSize;
    private final short maxInteriorNodes;
    private final short maxLeafNodes;
    private final short maxLeafNodesInHash;
    final BtreeRootNode root;
    private int height;
    private int maxStepsSearchedInHash;
    private int totalHashStepsSearched;
    private int hashSearchRequests;
    private int pagesCount;
    private int hashedPagesCount;
    private int count;
    private int movedMembersCount;
    private boolean hasZeroKey;
    private int zeroKeyValue;
    private static final boolean isLarge = true;
    private final ResizeableMappedFile storage;
    private static final boolean offloadToSiblingsBeforeSplit = false;
    private static final boolean indexNodeIsHashTable = true;
    final int metaDataLeafPageLength;
    final int hashPageCapacity;
    private static final boolean hasCachedMappings = false;
    private Int2IntMap myCachedMappings;
    private final int myCachedMappingsSize;
    private static final int UNDEFINED_ADDRESS = -1;
    private BtreeIndexNodeView myAccessNodeView;
    private int myLastGetKey;
    private int myOptimizedInserts;
    private boolean myCanUseLastKey;

    public static int version() {
        return 4 + (IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER ? 255 : 0);
    }

    public IntToIntBtree(int pageSize, @NotNull Path file2, @NotNull StorageLockContext storageLockContext, boolean initial) throws IOException {
        if (file2 == null) {
            IntToIntBtree.$$$reportNull$$$0(0);
        }
        if (storageLockContext == null) {
            IntToIntBtree.$$$reportNull$$$0(1);
        }
        this.pageSize = pageSize;
        if (initial) {
            Files.deleteIfExists(file2);
        }
        this.storage = new ResizeableMappedFile(file2, pageSize, storageLockContext, 0x100000, true, IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER);
        this.storage.setRoundFactor(pageSize);
        this.root = new BtreeRootNode(this);
        if (initial) {
            this.root.setAddress(-1);
        }
        int i = (this.pageSize - 8) / 8 - 1;
        assert (i < Short.MAX_VALUE && i % 2 == 0);
        this.maxInteriorNodes = (short)i;
        this.maxLeafNodes = (short)i;
        ++i;
        while (!IntToIntBtree.isPrime(i)) {
            i -= 2;
        }
        this.hashPageCapacity = i;
        int metaPageLen = 8;
        i = (int)((double)this.hashPageCapacity * 0.9);
        if ((i & 1) == 1) {
            ++i;
        }
        this.metaDataLeafPageLength = metaPageLen;
        assert (i > 0 && i % 2 == 0);
        this.maxLeafNodesInHash = (short)i;
        this.myCachedMappings = null;
        this.myCachedMappingsSize = -1;
    }

    private void doAllocateRoot() throws IOException {
        this.nextPage();
        this.root.setAddress(0);
        this.root.getNodeView().setIndexLeaf(true);
    }

    public int persistVars(@NotNull BtreeDataStorage storage, boolean toDisk) throws IOException {
        if (storage == null) {
            IntToIntBtree.$$$reportNull$$$0(2);
        }
        int i = storage.persistInt(0, this.height | (this.hasZeroKey ? -16777216 : 0), toDisk);
        this.hasZeroKey = (i & 0xFF000000) != 0;
        this.height = i & 0xFFFFFF;
        this.pagesCount = storage.persistInt(4, this.pagesCount, toDisk);
        this.movedMembersCount = storage.persistInt(8, this.movedMembersCount, toDisk);
        this.maxStepsSearchedInHash = storage.persistInt(12, this.maxStepsSearchedInHash, toDisk);
        this.count = storage.persistInt(16, this.count, toDisk);
        this.hashSearchRequests = storage.persistInt(20, this.hashSearchRequests, toDisk);
        this.totalHashStepsSearched = storage.persistInt(24, this.totalHashStepsSearched, toDisk);
        this.hashedPagesCount = storage.persistInt(28, this.hashedPagesCount, toDisk);
        this.root.setAddress(storage.persistInt(32, this.root.address, toDisk));
        this.zeroKeyValue = storage.persistInt(36, this.zeroKeyValue, toDisk);
        return 40;
    }

    private static boolean isPrime(int val) {
        if (val % 2 == 0) {
            return false;
        }
        int maxDivisor = (int)Math.sqrt(val);
        for (int i = 3; i <= maxDivisor; i += 2) {
            if (val % i != 0) continue;
            return false;
        }
        return true;
    }

    private int nextPage() throws IOException {
        int pageStart = (int)this.storage.length();
        this.storage.putInt(pageStart + this.pageSize - 4, 0);
        ++this.pagesCount;
        return pageStart;
    }

    public boolean get(int key, int @NotNull [] result) throws IOException {
        if (result == null) {
            IntToIntBtree.$$$reportNull$$$0(3);
        }
        if (key == 0) {
            if (this.hasZeroKey) {
                result[0] = this.zeroKeyValue;
                return true;
            }
            return false;
        }
        if (this.root.address == -1) {
            return false;
        }
        if (this.myAccessNodeView == null) {
            this.myAccessNodeView = new BtreeIndexNodeView(this);
        }
        this.myAccessNodeView.initTraversal(this.root.address);
        int index = this.myAccessNodeView.locate(key, false);
        if (index < 0) {
            this.myCanUseLastKey = true;
            this.myLastGetKey = key;
            return false;
        }
        this.myCanUseLastKey = false;
        result[0] = this.myAccessNodeView.addressAt(index);
        return true;
    }

    public void put(int key, int value) throws IOException {
        if (key == 0) {
            this.hasZeroKey = true;
            this.zeroKeyValue = value;
            return;
        }
        boolean canUseLastKey = this.myCanUseLastKey;
        if (canUseLastKey) {
            this.myCanUseLastKey = false;
            if (key == this.myLastGetKey && !this.myAccessNodeView.myHasFullPagesAlongPath && this.myAccessNodeView.isValid()) {
                ++this.myOptimizedInserts;
                ++this.count;
                this.myAccessNodeView.insert(key, value);
                return;
            }
        }
        this.doPut(key, value);
    }

    private void doPut(int key, int value) throws IOException {
        if (this.root.address == -1) {
            this.doAllocateRoot();
        }
        if (this.myAccessNodeView == null) {
            this.myAccessNodeView = new BtreeIndexNodeView(this);
        }
        this.myAccessNodeView.initTraversal(this.root.address);
        int index = this.myAccessNodeView.locate(key, true);
        if (index < 0) {
            ++this.count;
            this.myAccessNodeView.insert(key, value);
        } else {
            this.myAccessNodeView.setAddressAt(index, value);
        }
    }

    void dumpStatistics() throws IOException {
        int leafPages = this.height == 3 ? this.pagesCount - (1 + this.root.getNodeView().getChildrenCount() + 1) : (this.height == 2 ? this.pagesCount - 1 : 1);
        long leafNodesCapacity = (long)this.hashedPagesCount * (long)this.maxLeafNodesInHash + (long)(leafPages - this.hashedPagesCount) * (long)this.maxLeafNodes;
        long leafNodesCapacity2 = (long)leafPages * (long)this.maxLeafNodes;
        int usedPercent = (int)((long)this.count * 100L / leafNodesCapacity);
        int usedPercent2 = (int)((long)this.count * 100L / leafNodesCapacity2);
        IOStatistics.dump("pagecount:" + this.pagesCount + ", height:" + this.height + ", movedMembers:" + this.movedMembersCount + ", optimized inserts:" + this.myOptimizedInserts + ", hash steps:" + this.maxStepsSearchedInHash + ", avg search in hash:" + (this.hashSearchRequests != 0 ? this.totalHashStepsSearched / this.hashSearchRequests : 0) + ", leaf pages used:" + usedPercent + "%, leaf pages used if sorted: " + usedPercent2 + "%, size:" + this.storage.length());
    }

    private void flushCachedMappings() throws IOException {
    }

    public void doClose() throws IOException {
        this.myCachedMappings = null;
        this.storage.close();
    }

    public void doFlush() throws IOException {
        this.flushCachedMappings();
        this.storage.force();
    }

    static void myAssert(boolean b) {
        if (!b) {
            IntToIntBtree.myAssert(true);
        }
        assert (b);
    }

    public boolean processMappings(@NotNull KeyValueProcessor processor) throws IOException {
        if (processor == null) {
            IntToIntBtree.$$$reportNull$$$0(4);
        }
        this.doFlush();
        if (this.hasZeroKey && !processor.process(0, this.zeroKeyValue)) {
            return false;
        }
        if (this.root.address == -1) {
            return true;
        }
        this.root.syncWithStore();
        return this.processLeafPages(this.root.getNodeView(), processor);
    }

    private boolean processLeafPages(@NotNull BtreeIndexNodeView node, @NotNull KeyValueProcessor processor) throws IOException {
        if (processor == null) {
            IntToIntBtree.$$$reportNull$$$0(5);
        }
        if (node == null) {
            IntToIntBtree.$$$reportNull$$$0(6);
        }
        if (node.isIndexLeaf()) {
            return node.processMappings(processor);
        }
        int[] childrenAddresses = new int[node.getChildrenCount() + 1];
        for (int i = 0; i < childrenAddresses.length; ++i) {
            childrenAddresses[i] = -node.addressAt(i);
        }
        if (childrenAddresses.length > 0) {
            BtreeIndexNodeView child = new BtreeIndexNodeView(this);
            for (int childrenAddress : childrenAddresses) {
                child.setAddress(childrenAddress);
                if (this.processLeafPages(child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageLockContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/IntToIntBtree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "persistVars";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processMappings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processLeafPages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class KeyValueProcessor {
        public abstract boolean process(int var1, int var2) throws IOException;
    }

    private final class BtreeIndexNodeView
    extends BtreePage {
        static final int INTERIOR_SIZE = 8;
        static final int KEY_OFFSET = 4;
        static final int MIN_ITEMS_TO_SHARE = 20;
        private boolean isIndexLeaf;
        private boolean isHashedLeaf;
        private static final int LARGE_MOVE_THRESHOLD = 5;
        private static final int HASH_FREE = 0;
        static final int INDEX_LEAF_MASK = 1;
        static final int HASHED_LEAF_MASK = 2;
        private static final boolean useDoubleHash = true;

        BtreeIndexNodeView(IntToIntBtree btree) {
            super(btree);
        }

        private int search(int value) throws IOException {
            if (this.isIndexLeaf() && this.isHashedLeaf()) {
                return this.hashIndex(value);
            }
            return ObjectUtils.binarySearch(0, this.getChildrenCount(), mid -> Integer.compare(this.keyAt(mid), value));
        }

        int addressAt(int i) {
            return this.getInt(this.indexToOffset(i));
        }

        private void setAddressAt(int i, int value) throws IOException {
            int offset = this.indexToOffset(i);
            this.putInt(offset, value);
        }

        private int indexToOffset(int i) {
            return i * 8 + (this.isHashedLeaf() ? this.btree.metaDataLeafPageLength : 8);
        }

        private int keyAt(int i) {
            return this.getInt(this.indexToOffset(i) + 4);
        }

        private void setKeyAt(int i, int value) throws IOException {
            int offset = this.indexToOffset(i) + 4;
            this.putInt(offset, value);
        }

        boolean isIndexLeaf() {
            return this.isIndexLeaf;
        }

        @Override
        protected void doInitFlags(int flags) {
            super.doInitFlags(flags);
            flags = flags >> 24 & 0xFF;
            this.isHashedLeaf = BitUtil.isSet(flags, 2);
            this.isIndexLeaf = BitUtil.isSet(flags, 1);
        }

        void setIndexLeaf(boolean value) throws IOException {
            this.isIndexLeaf = value;
            this.setFlag(1, value);
        }

        private boolean isHashedLeaf() {
            return this.isHashedLeaf;
        }

        void setHashedLeaf() throws IOException {
            this.isHashedLeaf = true;
            this.setFlag(2, true);
        }

        short getMaxChildrenCount() {
            return this.isIndexLeaf() ? (this.isHashedLeaf() ? this.btree.maxLeafNodesInHash : this.btree.maxLeafNodes) : this.btree.maxInteriorNodes;
        }

        boolean isFull() {
            short childrenCount = this.getChildrenCount();
            if (!this.isIndexLeaf()) {
                childrenCount = (short)(childrenCount + 1);
            }
            return childrenCount == this.getMaxChildrenCount();
        }

        boolean processMappings(KeyValueProcessor processor) throws IOException {
            assert (this.isIndexLeaf());
            if (this.isHashedLeaf()) {
                int offset = this.myAddressInBuffer + this.indexToOffset(0);
                for (int i = 0; i < this.btree.hashPageCapacity; ++i) {
                    int key = this.myBufferWrapper.getInt(offset + 4);
                    if (key != 0 && !processor.process(key, this.myBufferWrapper.getInt(offset))) {
                        return false;
                    }
                    offset += 8;
                }
            } else {
                int childrenCount = this.getChildrenCount();
                for (int i = 0; i < childrenCount; ++i) {
                    if (processor.process(this.keyAt(i), this.addressAt(i))) continue;
                    return false;
                }
            }
            return true;
        }

        public void initTraversal(int address) throws IOException {
            this.myHasFullPagesAlongPath = false;
            this.setAddress(address);
        }

        public boolean isValid() {
            return !this.myBufferWrapper.isReleased();
        }

        private int splitNode(int parentAddress) throws IOException {
            int medianKey;
            boolean indexLeaf = this.isIndexLeaf();
            boolean hashedLeaf = this.isHashedLeaf();
            short recordCount = this.getChildrenCount();
            BtreeIndexNodeView parent = null;
            HashLeafData hashLeafData = null;
            if (parentAddress != 0) {
                parent = new BtreeIndexNodeView(this.btree);
                parent.setAddress(parentAddress);
            }
            short maxIndex = (short)(this.getMaxChildrenCount() / 2);
            BtreeIndexNodeView newIndexNode = new BtreeIndexNodeView(this.btree);
            newIndexNode.setAddress(this.btree.nextPage());
            this.syncWithStore();
            if (parent != null) {
                parent.syncWithStore();
            }
            this.btree.root.syncWithStore();
            newIndexNode.setIndexLeaf(indexLeaf);
            int nextPage = this.getNextPage();
            this.setNextPage(newIndexNode.address);
            newIndexNode.setNextPage(nextPage);
            if (indexLeaf && hashedLeaf) {
                if (hashLeafData == null) {
                    hashLeafData = new HashLeafData(this, recordCount);
                }
                int[] keys = hashLeafData.keys;
                hashLeafData.clean();
                Int2IntMap map2 = hashLeafData.values;
                int avg = keys.length / 2;
                medianKey = keys[avg];
                --this.btree.hashedPagesCount;
                this.setChildrenCount((short)0);
                newIndexNode.setChildrenCount((short)0);
                for (int i = 0; i < avg; ++i) {
                    int key = keys[i];
                    this.insert(key, map2.get(key));
                    key = keys[avg + i];
                    newIndexNode.insert(key, map2.get(key));
                }
            } else {
                short recordCountInNewNode = (short)(recordCount - maxIndex);
                newIndexNode.setChildrenCount(recordCountInNewNode);
                ByteBuffer buffer = this.getBytes(this.indexToOffset(maxIndex), recordCountInNewNode * 8);
                newIndexNode.putBytes(newIndexNode.indexToOffset(0), buffer);
                if (indexLeaf) {
                    medianKey = newIndexNode.keyAt(0);
                } else {
                    newIndexNode.setAddressAt(recordCountInNewNode, this.addressAt(recordCount));
                    maxIndex = (short)(maxIndex - 1);
                    medianKey = this.keyAt(maxIndex);
                }
                this.setChildrenCount(maxIndex);
            }
            if (parent != null) {
                parent.insert(medianKey, -newIndexNode.address);
            } else {
                int newRootAddress = this.btree.nextPage();
                newIndexNode.syncWithStore();
                this.syncWithStore();
                this.btree.root.setAddress(newRootAddress);
                parentAddress = newRootAddress;
                BtreeIndexNodeView rootNodeView = this.btree.root.getNodeView();
                rootNodeView.setChildrenCount((short)1);
                rootNodeView.setKeyAt(0, medianKey);
                rootNodeView.setAddressAt(0, -this.address);
                rootNodeView.setAddressAt(1, -newIndexNode.address);
            }
            return parentAddress;
        }

        private boolean doOffloadToSiblingsWhenHashed(BtreeIndexNodeView parent, HashLeafData hashLeafData) throws IOException {
            int indexInParent = parent.search(hashLeafData.keys[0]);
            if (indexInParent >= 0) {
                BtreeIndexNodeView sibling = new BtreeIndexNodeView(this.btree);
                sibling.setAddress(-parent.addressAt(indexInParent));
                int numberOfKeysToMove = (sibling.getMaxChildrenCount() - sibling.getChildrenCount()) / 2;
                if (!sibling.isFull() && numberOfKeysToMove > 20) {
                    int key;
                    int i;
                    short childrenCount = this.getChildrenCount();
                    int[] keys = hashLeafData.keys;
                    Int2IntMap map2 = hashLeafData.values;
                    for (i = 0; i < numberOfKeysToMove; ++i) {
                        key = keys[i];
                        sibling.insert(key, map2.get(key));
                    }
                    parent.setKeyAt(indexInParent, keys[numberOfKeysToMove]);
                    this.setChildrenCount((short)0);
                    --this.btree.hashedPagesCount;
                    hashLeafData.clean();
                    for (i = numberOfKeysToMove; i < childrenCount; ++i) {
                        key = keys[i];
                        this.insert(key, map2.get(key));
                    }
                } else if (indexInParent + 1 < parent.getChildrenCount()) {
                    this.insertToRightSiblingWhenHashed(parent, hashLeafData, indexInParent, sibling);
                }
            } else if (indexInParent == -1) {
                this.insertToRightSiblingWhenHashed(parent, hashLeafData, 0, new BtreeIndexNodeView(this.btree));
            }
            return !this.isFull();
        }

        private void insertToRightSiblingWhenHashed(BtreeIndexNodeView parent, HashLeafData hashLeafData, int indexInParent, BtreeIndexNodeView sibling) throws IOException {
            sibling.setAddress(-parent.addressAt(indexInParent + 1));
            int numberOfKeysToMove = (sibling.getMaxChildrenCount() - sibling.getChildrenCount()) / 2;
            if (!sibling.isFull() && numberOfKeysToMove > 20) {
                int key;
                int lastChildIndex;
                int i;
                int[] keys = hashLeafData.keys;
                Int2IntMap map2 = hashLeafData.values;
                short childrenCount = this.getChildrenCount();
                for (i = lastChildIndex = childrenCount - numberOfKeysToMove; i < childrenCount; ++i) {
                    key = keys[i];
                    sibling.insert(key, map2.get(key));
                }
                parent.setKeyAt(indexInParent, keys[lastChildIndex]);
                this.setChildrenCount((short)0);
                --this.btree.hashedPagesCount;
                hashLeafData.clean();
                for (i = 0; i < lastChildIndex; ++i) {
                    key = keys[i];
                    this.insert(key, map2.get(key));
                }
            }
        }

        private boolean doOffloadToSiblingsSorted(BtreeIndexNodeView parent) throws IOException {
            if (!this.isIndexLeaf()) {
                return false;
            }
            int indexInParent = parent.search(this.keyAt(0));
            if (indexInParent >= 0) {
                BtreeIndexNodeView sibling = new BtreeIndexNodeView(this.btree);
                sibling.setAddress(-parent.addressAt(indexInParent));
                int toMove = (sibling.getMaxChildrenCount() - sibling.getChildrenCount()) / 2;
                if (toMove > 0) {
                    for (int i = 0; i < toMove; ++i) {
                        sibling.insert(this.keyAt(i), this.addressAt(i));
                    }
                    parent.setKeyAt(indexInParent, this.keyAt(toMove));
                    int indexOfLastChildToMove = this.getChildrenCount() - toMove;
                    this.btree.movedMembersCount += indexOfLastChildToMove;
                    ByteBuffer buffer = this.getBytes(this.indexToOffset(toMove), indexOfLastChildToMove * 8);
                    this.putBytes(this.indexToOffset(0), buffer);
                    this.setChildrenCount((short)indexOfLastChildToMove);
                } else if (indexInParent + 1 < parent.getChildrenCount()) {
                    this.insertToRightSiblingWhenSorted(parent, indexInParent + 1, sibling);
                }
            } else if (indexInParent == -1) {
                this.insertToRightSiblingWhenSorted(parent, 0, new BtreeIndexNodeView(this.btree));
            }
            return !this.isFull();
        }

        private void insertToRightSiblingWhenSorted(BtreeIndexNodeView parent, int indexInParent, BtreeIndexNodeView sibling) throws IOException {
            sibling.setAddress(-parent.addressAt(indexInParent + 1));
            int toMove = (sibling.getMaxChildrenCount() - sibling.getChildrenCount()) / 2;
            if (toMove > 0) {
                int lastChildIndex;
                short childrenCount = this.getChildrenCount();
                for (int i = lastChildIndex = childrenCount - toMove; i < childrenCount; ++i) {
                    sibling.insert(this.keyAt(i), this.addressAt(i));
                }
                parent.setKeyAt(indexInParent, this.keyAt(lastChildIndex));
                this.setChildrenCount((short)lastChildIndex);
            }
        }

        void dump(String s) {
        }

        private void immediateDump(String s) {
            int maxIndex = this.getChildrenCount();
            System.out.println(s + " @" + this.address);
            for (int i = 0; i < maxIndex; ++i) {
                System.out.print(this.addressAt(i) + " " + this.keyAt(i) + " ");
            }
            if (!this.isIndexLeaf()) {
                System.out.println(this.addressAt(maxIndex));
            } else {
                System.out.println();
            }
        }

        private int locate(int valueHC, boolean split) throws IOException {
            int searched = 0;
            int parentAddress = 0;
            int maxHeight = this.btree.height + 1;
            while (true) {
                if (this.isFull()) {
                    if (split) {
                        if ((parentAddress = this.splitNode(parentAddress)) != 0) {
                            this.setAddress(parentAddress);
                        }
                        --searched;
                    } else {
                        this.myHasFullPagesAlongPath = true;
                    }
                }
                int i = this.search(valueHC);
                if (++searched > maxHeight) {
                    throw new CorruptedException(IntToIntBtree.this.storage.getPagedFileStorage().getFile());
                }
                if (this.isIndexLeaf()) {
                    this.btree.height = Math.max(this.btree.height, searched);
                    return i;
                }
                int address = i < 0 ? this.addressAt(-i - 1) : this.addressAt(i + 1);
                parentAddress = this.address;
                this.setAddress(-address);
            }
        }

        private void insert(int valueHC, int newValueId) throws IOException {
            short recordCount = this.getChildrenCount();
            boolean indexLeaf = this.isIndexLeaf();
            if (indexLeaf) {
                if (recordCount == 0) {
                    this.setHashedLeaf();
                    ++this.btree.hashedPagesCount;
                }
                if (this.isHashedLeaf()) {
                    int index = this.hashIndex(valueHC);
                    if (index < 0) {
                        index = -index - 1;
                    }
                    this.setKeyAt(index, valueHC);
                    this.setAddressAt(index, newValueId);
                    this.setChildrenCount((short)(recordCount + 1));
                    return;
                }
            }
            int medianKeyInParent = this.search(valueHC);
            int index = -medianKeyInParent - 1;
            this.setChildrenCount((short)(recordCount + 1));
            int itemsToMove = recordCount - index;
            this.btree.movedMembersCount += itemsToMove;
            if (indexLeaf) {
                if (itemsToMove > 5) {
                    ByteBuffer buffer = this.getBytes(this.indexToOffset(index), itemsToMove * 8);
                    this.putBytes(this.indexToOffset(index + 1), buffer);
                } else {
                    for (int i = recordCount - 1; i >= index; --i) {
                        this.setKeyAt(i + 1, this.keyAt(i));
                        this.setAddressAt(i + 1, this.addressAt(i));
                    }
                }
                this.setKeyAt(index, valueHC);
                this.setAddressAt(index, newValueId);
            } else {
                this.setAddressAt(recordCount + 1, this.addressAt(recordCount));
                if (itemsToMove > 5) {
                    int elementsAfterIndex = recordCount - index - 1;
                    if (elementsAfterIndex > 0) {
                        ByteBuffer buffer = this.getBytes(this.indexToOffset(index + 1), elementsAfterIndex * 8);
                        this.putBytes(this.indexToOffset(index + 2), buffer);
                    }
                } else {
                    for (int i = recordCount - 1; i > index; --i) {
                        this.setKeyAt(i + 1, this.keyAt(i));
                        this.setAddressAt(i + 1, this.addressAt(i));
                    }
                }
                if (index < recordCount) {
                    this.setKeyAt(index + 1, this.keyAt(index));
                }
                this.setKeyAt(index, valueHC);
                this.setAddressAt(index + 1, newValueId);
            }
        }

        private int hashIndex(int value) throws IOException {
            int length = this.btree.hashPageCapacity;
            int hash = value & Integer.MAX_VALUE;
            int index = hash % length;
            int keyAtIndex = this.keyAt(index);
            this.btree.hashSearchRequests++;
            int total = 0;
            if (keyAtIndex != value && keyAtIndex != 0) {
                int probe = 1 + hash % (length - 2);
                do {
                    if ((index -= probe) < 0) {
                        index += length;
                    }
                    keyAtIndex = this.keyAt(index);
                    if (++total <= length) continue;
                    throw new CorruptedException(IntToIntBtree.this.storage.getPagedFileStorage().getFile());
                } while (keyAtIndex != value && keyAtIndex != 0);
            }
            this.btree.maxStepsSearchedInHash = Math.max(this.btree.maxStepsSearchedInHash, total);
            this.btree.totalHashStepsSearched += total;
            return keyAtIndex == 0 ? -index - 1 : index;
        }

        private final class HashLeafData {
            final BtreeIndexNodeView nodeView;
            final int[] keys;
            final Int2IntMap values;

            HashLeafData(BtreeIndexNodeView _nodeView, int recordCount) throws IOException {
                this.nodeView = _nodeView;
                IntToIntBtree btree = _nodeView.btree;
                int offset = this.nodeView.myAddressInBuffer + this.nodeView.indexToOffset(0);
                this.keys = new int[recordCount];
                this.values = new Int2IntOpenHashMap(recordCount);
                int keyNumber = 0;
                for (int i = 0; i < btree.hashPageCapacity; ++i) {
                    int key = this.nodeView.myBufferWrapper.getInt(offset + 4);
                    if (key != 0) {
                        int value = this.nodeView.myBufferWrapper.getInt(offset);
                        if (keyNumber == this.keys.length) {
                            throw new CorruptedException(IntToIntBtree.this.storage.getPagedFileStorage().getFile());
                        }
                        this.keys[keyNumber++] = key;
                        this.values.put(key, value);
                    }
                    offset += 8;
                }
                Arrays.sort(this.keys);
            }

            private void clean() throws IOException {
                IntToIntBtree btree = this.nodeView.btree;
                for (int i = 0; i < btree.hashPageCapacity; ++i) {
                    this.nodeView.setKeyAt(i, 0);
                }
            }
        }
    }

    private static class BtreePage {
        static final int RESERVED_META_PAGE_LEN = 8;
        static final int FLAGS_SHIFT = 24;
        static final int LENGTH_SHIFT = 8;
        static final int LENGTH_MASK = 65535;
        protected final IntToIntBtree btree;
        protected int address = -1;
        private short myChildrenCount;
        protected int myAddressInBuffer;
        protected DirectBufferWrapper myBufferWrapper;
        protected boolean myHasFullPagesAlongPath;

        BtreePage(IntToIntBtree btree) {
            this.btree = btree;
            this.myChildrenCount = (short)-1;
        }

        void setAddress(int _address) throws IOException {
            this.setAddressInternal(_address);
            this.syncWithStore();
        }

        private void setAddressInternal(int _address) {
            this.address = _address;
        }

        protected void syncWithStore() throws IOException {
            PagedFileStorage pagedFileStorage = this.btree.storage.getPagedFileStorage();
            this.myAddressInBuffer = pagedFileStorage.getOffsetInPage(this.address);
            this.myBufferWrapper = pagedFileStorage.getByteBuffer(this.address, false);
            this.doInitFlags(this.myBufferWrapper.getInt(this.myAddressInBuffer));
        }

        protected void doInitFlags(int anInt) {
            this.myChildrenCount = (short)(anInt >>> 8 & 0xFFFF);
        }

        protected final void setFlag(int mask, boolean flag) throws IOException {
            int anInt = this.myBufferWrapper.getInt(this.myAddressInBuffer);
            anInt = flag ? (anInt |= mask) : (anInt &= ~(mask <<= 24));
            this.myBufferWrapper.putInt(this.myAddressInBuffer, anInt);
        }

        protected final short getChildrenCount() {
            return this.myChildrenCount;
        }

        protected final void setChildrenCount(short value) throws IOException {
            this.myChildrenCount = value;
            int myValue = this.myBufferWrapper.getInt(this.myAddressInBuffer);
            myValue &= 0xFF000000;
            this.myBufferWrapper.putInt(this.myAddressInBuffer, myValue |= value << 8);
        }

        protected final void setNextPage(int nextPage) throws IOException {
            this.putInt(4, nextPage);
        }

        protected final int getNextPage() {
            return this.getInt(4);
        }

        protected final int getInt(int address) {
            return this.myBufferWrapper.getInt(this.myAddressInBuffer + address);
        }

        protected final void putInt(int offset, int value) throws IOException {
            this.myBufferWrapper.putInt(this.myAddressInBuffer + offset, value);
        }

        protected final ByteBuffer getBytes(int address, int length) {
            ByteBuffer duplicate = this.myBufferWrapper.copy();
            int newPosition = address + this.myAddressInBuffer;
            duplicate.position(newPosition);
            duplicate.limit(newPosition + length);
            return duplicate;
        }

        protected final void putBytes(int address, ByteBuffer buffer) throws IOException {
            this.myBufferWrapper.position(address + this.myAddressInBuffer);
            this.myBufferWrapper.put(buffer);
        }
    }

    private final class BtreeRootNode {
        int address;
        final BtreeIndexNodeView nodeView;
        boolean initialized;

        BtreeRootNode(IntToIntBtree btree) {
            this.nodeView = new BtreeIndexNodeView(btree);
        }

        void setAddress(int _address) {
            this.address = _address;
            this.initialized = false;
        }

        private void syncWithStore() throws IOException {
            this.nodeView.setAddress(this.address);
            this.initialized = true;
        }

        public BtreeIndexNodeView getNodeView() throws IOException {
            if (!this.initialized) {
                this.syncWithStore();
            }
            return this.nodeView;
        }
    }

    public static interface BtreeDataStorage {
        public int persistInt(int var1, int var2, boolean var3) throws IOException;
    }
}

