/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessService;
import com.intellij.execution.process.SelfKiller;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance(OSProcessHandler.class);
    private static final Set<String> REPORTED_EXECUTIONS = ContainerUtil.newConcurrentSet();
    private static final long ALLOWED_TIMEOUT_THRESHOLD = 10L;
    private static final Key<Set<File>> DELETE_FILES_ON_TERMINATION = Key.create("OSProcessHandler.FileToDelete");
    private final boolean myHasErrorStream;
    private final ModalityState myModality;
    private Boolean myHasPty;
    private boolean myDestroyRecursively;
    private final Set<File> myFilesToDelete;

    public OSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            OSProcessHandler.$$$reportNull$$$0(0);
        }
        super(OSProcessHandler.startProcess(commandLine), commandLine.getCommandLineString(), commandLine.getCharset());
        this.myDestroyRecursively = true;
        LoadingState.CONFIGURATION_STORE_INITIALIZED.checkOccurred();
        this.myHasErrorStream = !commandLine.isRedirectErrorStream();
        this.myFilesToDelete = commandLine.getUserData(DELETE_FILES_ON_TERMINATION);
        this.myModality = OSProcessHandler.getDefaultModality();
    }

    @NotNull
    public static ModalityState getDefaultModality() {
        Application app = ApplicationManager.getApplication();
        ModalityState modalityState = app == null ? ModalityState.NON_MODAL : app.getDefaultModalityState();
        if (modalityState == null) {
            OSProcessHandler.$$$reportNull$$$0(1);
        }
        return modalityState;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public OSProcessHandler(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessHandler.$$$reportNull$$$0(2);
        }
        this(process2, null);
        PluginException.reportDeprecatedUsage((String)"OSProcessHandler#OSProcessHandler(Process)", (String)"Use `#OSProcessHandler(Process, String)` instead");
    }

    public OSProcessHandler(@NotNull Process process2, String commandLine) {
        if (process2 == null) {
            OSProcessHandler.$$$reportNull$$$0(3);
        }
        this(process2, commandLine, EncodingManager.getInstance().getDefaultConsoleEncoding());
    }

    public OSProcessHandler(@NotNull Process process2, String commandLine, @Nullable Charset charset) {
        if (process2 == null) {
            OSProcessHandler.$$$reportNull$$$0(4);
        }
        this(process2, commandLine, charset, null);
    }

    public OSProcessHandler(@NotNull Process process2, String commandLine, @Nullable Charset charset, @Nullable Set<File> filesToDelete) {
        if (process2 == null) {
            OSProcessHandler.$$$reportNull$$$0(5);
        }
        super(process2, commandLine, charset);
        this.myDestroyRecursively = true;
        this.myFilesToDelete = filesToDelete;
        this.myHasErrorStream = true;
        this.myModality = OSProcessHandler.getDefaultModality();
    }

    private static Process startProcess(GeneralCommandLine commandLine) throws ExecutionException {
        try {
            return commandLine.createProcess();
        }
        catch (Throwable e) {
            OSProcessHandler.deleteTempFiles(commandLine.getUserData(DELETE_FILES_ON_TERMINATION));
            throw e;
        }
    }

    @Override
    public boolean waitFor() {
        OSProcessHandler.checkEdtAndReadAction(this);
        return super.waitFor();
    }

    @Override
    public boolean waitFor(long timeoutInMilliseconds) {
        if (timeoutInMilliseconds > 10L) {
            OSProcessHandler.checkEdtAndReadAction(this);
        }
        return super.waitFor(timeoutInMilliseconds);
    }

    public static void checkEdtAndReadAction(@NotNull ProcessHandler processHandler) {
        Application application;
        if (processHandler == null) {
            OSProcessHandler.$$$reportNull$$$0(6);
        }
        if ((application = ApplicationManager.getApplication()) == null || !application.isInternal() || application.isHeadlessEnvironment()) {
            return;
        }
        String message = null;
        if (application.isDispatchThread()) {
            message = "Synchronous execution on EDT: ";
        } else if (application.isReadAccessAllowed()) {
            message = "Synchronous execution under ReadAction: ";
        }
        if (message != null && REPORTED_EXECUTIONS.add(ExceptionUtil.currentStackTrace())) {
            LOG.error(message + processHandler + ", see com.intellij.execution.process.OSProcessHandler#checkEdtAndReadAction() Javadoc for resolutions");
        }
    }

    private static void deleteTempFiles(Set<File> tempFiles) {
        if (tempFiles != null) {
            try {
                for (File file2 : tempFiles) {
                    FileUtil.delete(file2);
                }
            }
            catch (Throwable t) {
                LOG.error("failed to delete temp. files", t);
            }
        }
    }

    @Override
    protected void onOSProcessTerminated(int exitCode) {
        if (this.myModality != ModalityState.NON_MODAL) {
            ProgressManager.getInstance().runProcess(() -> super.onOSProcessTerminated(exitCode), (ProgressIndicator)new EmptyProgressIndicator(this.myModality));
        } else {
            super.onOSProcessTerminated(exitCode);
        }
        OSProcessHandler.deleteTempFiles(this.myFilesToDelete);
    }

    @Override
    protected boolean processHasSeparateErrorStream() {
        return this.myHasErrorStream;
    }

    protected boolean shouldDestroyProcessRecursively() {
        return this.myDestroyRecursively;
    }

    public void setShouldDestroyProcessRecursively(boolean destroyRecursively) {
        this.myDestroyRecursively = destroyRecursively;
    }

    @Override
    protected void doDestroyProcess() {
        Object process2 = this.getProcess();
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS(process2)) {
            this.killProcessTree((Process)process2);
        } else {
            ((Process)process2).destroy();
        }
    }

    public static boolean processCanBeKilledByOS(Process process2) {
        return !(process2 instanceof SelfKiller);
    }

    protected void killProcessTree(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessHandler.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.killProcessTreeSync(process2);
        } else {
            this.executeTask(() -> this.killProcessTreeSync(process2));
        }
    }

    private void killProcessTreeSync(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessHandler.$$$reportNull$$$0(8);
        }
        LOG.debug("killing process tree");
        boolean destroyed = OSProcessUtil.killProcessTree(process2);
        if (!destroyed) {
            if (!process2.isAlive()) {
                LOG.warn("Process has been already terminated: " + this.myCommandLine);
            } else {
                LOG.warn("Cannot kill process tree. Trying to destroy process using Java API. Cmdline:\n" + this.myCommandLine);
                process2.destroy();
            }
        }
    }

    public boolean hasPty() {
        if (this.myHasPty == null) {
            this.myHasPty = LoadingState.COMPONENTS_LOADED.isOccurred() && ProcessService.getInstance().isLocalPtyProcess((Process)this.getProcess());
        }
        return this.myHasPty;
    }

    public void setHasPty(boolean hasPty) {
        this.myHasPty = hasPty;
    }

    @Override
    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = this.hasPty() ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
        if (options == null) {
            OSProcessHandler.$$$reportNull$$$0(9);
        }
        return options;
    }

    public static void deleteFileOnTermination(@NotNull GeneralCommandLine commandLine, @NotNull File fileToDelete) {
        Set<File> set;
        if (commandLine == null) {
            OSProcessHandler.$$$reportNull$$$0(10);
        }
        if (fileToDelete == null) {
            OSProcessHandler.$$$reportNull$$$0(11);
        }
        if ((set = commandLine.getUserData(DELETE_FILES_ON_TERMINATION)) == null) {
            set = new HashSet<File>();
            commandLine.putUserData(DELETE_FILES_ON_TERMINATION, set);
        }
        set.add(fileToDelete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/OSProcessHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/OSProcessHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModality";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkEdtAndReadAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTreeSync";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteFileOnTermination";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Silent
    extends OSProcessHandler {
        public Silent(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                Silent.$$$reportNull$$$0(0);
            }
            super(commandLine);
        }

        @Override
        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
            if (options == null) {
                Silent.$$$reportNull$$$0(1);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/process/OSProcessHandler$Silent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/process/OSProcessHandler$Silent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

