/*
 * Decompiled with CFR 0.152.
 */
package training.ui.views;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.IftModule;
import training.ui.UISettings;
import training.ui.views.LearningItems;
import training.util.DataLoader;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ltraining/ui/views/ModulesPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "modulesPanel", "Ltraining/ui/views/LearningItems;", "addFooter", "", "addHeaderPanel", "initModulesPanel", "updateMainPanel", "intellij.featuresTrainer"})
public final class ModulesPanel
extends JPanel {
    private final LearningItems modulesPanel;

    private final void initModulesPanel() {
        Collection<IftModule> modules = CourseManager.Companion.getInstance().getModules();
        if (DataLoader.INSTANCE.getLiveMode()) {
            CourseManager.Companion.getInstance().clearModules();
        }
        Object object = this.modulesPanel;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        ((LearningItems)it).setModules(modules);
        ((LearningItems)it).updateItems(CourseManager.Companion.getInstance().getUnfoldModuleOnInit());
        this.removeAll();
        this.addHeaderPanel();
        this.modulesPanel.setAlignmentX(0.0f);
        object = UISettings.Companion.getInstance();
        bl = false;
        bl2 = false;
        it = object;
        LearningItems learningItems = this.modulesPanel;
        boolean bl4 = false;
        int n = ((UISettings)it).getPanelWidth() - (((UISettings)it).getWestInset() + ((UISettings)it).getEastInset());
        int n2 = 10000;
        int n3 = n;
        learningItems.setMaximumSize(new Dimension(n3, n2));
        this.add(this.modulesPanel);
        this.add(Box.createVerticalGlue());
        this.addFooter();
    }

    private final void addHeaderPanel() {
        JLabel it;
        JPanel headerContent = new JPanel();
        headerContent.setOpaque(false);
        headerContent.setLayout(new BoxLayout(headerContent, 1));
        headerContent.setAlignmentX(0.0f);
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            return;
        }
        LangSupport langSupport3 = langSupport2;
        String primaryLanguageId = langSupport3.getPrimaryLanguage();
        Language language = Language.findLanguageByID((String)primaryLanguageId);
        if (language == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"Language.findLanguageByI\u2026maryLanguageId) ?: return");
        Language language2 = language;
        Object[] objectArray = new Object[1];
        String string = language2.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.displayName");
        objectArray[0] = string;
        JLabel jLabel = new JLabel(LearnBundle.INSTANCE.message("modules.panel.header", objectArray));
        boolean bl = false;
        boolean bl2 = false;
        JLabel jLabel2 = jLabel;
        JPanel jPanel = headerContent;
        boolean bl3 = false;
        it.setFont(UISettings.Companion.getInstance().getFont(3).deriveFont(1));
        Unit unit = Unit.INSTANCE;
        jPanel.add(jLabel);
        headerContent.add(UtilsKt.rigid(0, 4));
        jLabel = new JLabel(UtilsKt.learningProgressString(CourseManager.Companion.getInstance().getLessonsForModules()));
        bl = false;
        bl2 = false;
        it = jLabel;
        jPanel = headerContent;
        boolean bl4 = false;
        it.setForeground(UISettings.Companion.getInstance().getModuleProgressColor());
        unit = Unit.INSTANCE;
        jPanel.add(jLabel);
        headerContent.add(UtilsKt.scaledRigid(0, UISettings.Companion.getInstance().getNorthInset() - UISettings.Companion.getInstance().getVerticalModuleItemInset()));
        this.add(headerContent);
    }

    /*
     * WARNING - void declaration
     */
    private final void addFooter() {
        void it;
        Object object = LangManager.Companion.getInstance().getLangSupport();
        if (object == null || (object = object.getLangCourseFeedback()) == null) {
            return;
        }
        Object linkForFeedback = object;
        JPanel footerContent = new JPanel();
        footerContent.setOpaque(false);
        footerContent.setLayout(new BoxLayout(footerContent, 1));
        footerContent.add(UtilsKt.rigid(0, 15));
        LinkLabel linkLabel2 = new LinkLabel(LearnBundle.INSTANCE.message("feedback.link.text", new Object[0]), null, new LinkListener((String)linkForFeedback){
            final /* synthetic */ String $linkForFeedback;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                UtilsKt.openLinkInBrowser(this.$linkForFeedback);
            }
            {
                this.$linkForFeedback = string;
            }
        });
        footerContent.add(UtilsKt.wrapWithUrlPanel((LinkLabel<Object>)linkLabel2));
        footerContent.add(UtilsKt.rigid(0, 4));
        JLabel jLabel = new JLabel(LearnBundle.INSTANCE.message("feedback.link.hint", new Object[0]));
        boolean bl = false;
        boolean bl2 = false;
        JLabel jLabel2 = jLabel;
        JPanel jPanel = footerContent;
        boolean bl3 = false;
        it.setForeground(UISettings.Companion.getInstance().getModuleProgressColor());
        it.setFont(UISettings.Companion.getInstance().getFont(-1));
        Unit unit = Unit.INSTANCE;
        jPanel.add(jLabel);
        JPanel shiftedFooter = new JPanel();
        shiftedFooter.setName("footerModulePanel");
        shiftedFooter.setLayout(new BoxLayout(shiftedFooter, 0));
        shiftedFooter.setFocusable(false);
        shiftedFooter.setOpaque(false);
        shiftedFooter.setBorder(new MatteBorder(JBUI.scale((int)1), 0, 0, 0, UISettings.Companion.getInstance().getSeparatorColor()));
        shiftedFooter.setAlignmentX(0.0f);
        shiftedFooter.add(footerContent);
        shiftedFooter.add(UtilsKt.rigid(1, 0));
        shiftedFooter.add(Box.createHorizontalGlue());
        this.add(shiftedFooter);
    }

    public final void updateMainPanel() {
        this.modulesPanel.removeAll();
        this.initModulesPanel();
    }

    public ModulesPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.modulesPanel = new LearningItems(project);
        this.setLayout(new BoxLayout(this, 1));
        this.setFocusable(false);
        this.setOpaque(true);
        this.setBackground(UISettings.Companion.getInstance().getBackgroundColor());
        this.setBorder(UISettings.Companion.getInstance().getEmptyBorder());
        this.initModulesPanel();
        this.revalidate();
        this.repaint();
    }
}

