/*
 * Decompiled with CFR 0.152.
 */
package training.project;

import com.intellij.UtilBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\"\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltraining/project/FileUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "copyDirWithDestFilter", "", "fromDir", "Ljava/io/File;", "toDir", "destinationFilter", "Ljava/io/FileFilter;", "copyJarResourcesRecursively", "", "destDir", "jarPath", "", "copyResourcesRecursively", "originUrl", "Ljava/net/URL;", "destination", "copyStream", "inputStream", "Ljava/io/InputStream;", "f", "os", "Ljava/io/OutputStream;", "ensureDirectoryExists", "splitJarPath", "Lkotlin/Pair;", "path", "intellij.featuresTrainer"})
public final class FileUtils {
    private static final Logger LOG;
    @NotNull
    public static final FileUtils INSTANCE;

    public final boolean copyJarResourcesRecursively(@NotNull File destDir, @NotNull String jarPath, @Nullable FileFilter destinationFilter) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        Pair<String, String> splitJarPath = this.splitJarPath(jarPath);
        String mayBeEscapedFile = new URL((String)splitJarPath.getFirst()).getFile();
        String string = URLUtil.unescapePercentSequences((String)mayBeEscapedFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLUtil.unescapePercentSequences(mayBeEscapedFile)");
        String file = string;
        JarFile jarFile = new JarFile(file);
        String prefix = (String)splitJarPath.getSecond();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            InputStream entryInputStream;
            String filename;
            JarEntry entry;
            JarEntry jarEntry = entry = entries.nextElement();
            Intrinsics.checkNotNullExpressionValue((Object)jarEntry, (String)"entry");
            String string2 = jarEntry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
            if (!StringsKt.startsWith$default((String)string2, (String)prefix, (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.trimStart((String)entry.getName(), (String)prefix), (String)"StringUtil.trimStart(entry.name, prefix)");
            File f = new File(destDir, filename);
            if (destinationFilter != null && !destinationFilter.accept(f) || entry.isDirectory()) continue;
            File file2 = f.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"f.parentFile");
            if (!this.ensureDirectoryExists(file2)) {
                LOG.error("Cannot create directory: " + f.getParentFile());
            }
            InputStream inputStream = entryInputStream = jarFile.getInputStream(entry);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"entryInputStream");
            if (!this.copyStream(inputStream, f)) {
                return false;
            }
            entryInputStream.close();
        }
        return true;
    }

    public static /* synthetic */ boolean copyJarResourcesRecursively$default(FileUtils fileUtils, File file, String string, FileFilter fileFilter, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            fileFilter = null;
        }
        return fileUtils.copyJarResourcesRecursively(file, string, fileFilter);
    }

    public final boolean copyResourcesRecursively(@NotNull URL originUrl, @NotNull File destination, @Nullable FileFilter destinationFilter) {
        Intrinsics.checkNotNullParameter((Object)originUrl, (String)"originUrl");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        try {
            if (Intrinsics.areEqual((Object)originUrl.getProtocol(), (Object)"jar")) {
                String string = originUrl.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"originUrl.file");
                this.copyJarResourcesRecursively(destination, string, destinationFilter);
            } else if (Intrinsics.areEqual((Object)originUrl.getProtocol(), (Object)"file")) {
                this.copyDirWithDestFilter(new File(originUrl.getPath()), destination, destinationFilter);
            }
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public static /* synthetic */ boolean copyResourcesRecursively$default(FileUtils fileUtils, URL uRL, File file, FileFilter fileFilter, int n, Object object) {
        if ((n & 4) != 0) {
            fileFilter = null;
        }
        return fileUtils.copyResourcesRecursively(uRL, file, fileFilter);
    }

    private final void copyDirWithDestFilter(File fromDir, File toDir, FileFilter destinationFilter) {
        FileUtil.ensureExists((File)toDir);
        if (FileUtil.isAncestor((File)fromDir, (File)toDir, (boolean)true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] fileArray = fromDir.listFiles();
        if (fileArray == null) {
            throw (Throwable)new IOException(UtilBundle.message((String)"exception.directory.is.invalid", (Object[])new Object[]{fromDir.getPath()}));
        }
        File[] files = fileArray;
        if (!fromDir.canRead()) {
            throw (Throwable)new IOException(UtilBundle.message((String)"exception.directory.is.not.readable", (Object[])new Object[]{fromDir.getPath()}));
        }
        File[] fileArray2 = files;
        int n = fileArray2.length;
        for (int j = 0; j < n; ++j) {
            File file;
            File file2 = file = fileArray2[j];
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            File destinationFile = new File(toDir, file2.getName());
            if (file.isDirectory()) {
                this.copyDirWithDestFilter(file, destinationFile, destinationFilter);
                continue;
            }
            if (destinationFilter != null && !destinationFilter.accept(destinationFile)) continue;
            FileUtil.copy((File)file, (File)destinationFile);
        }
    }

    private final boolean copyStream(InputStream inputStream, File f) {
        try {
            return this.copyStream(inputStream, new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private final boolean copyStream(InputStream inputStream, OutputStream os) {
        try {
            byte[] buf = new byte[1024];
            int len = inputStream.read(buf);
            while (len > 0) {
                os.write(buf, 0, len);
                len = inputStream.read(buf);
            }
            inputStream.close();
            os.close();
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private final boolean ensureDirectoryExists(File f) {
        return f.exists() || f.mkdirs();
    }

    private final Pair<String, String> splitJarPath(String path) {
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)path, (String)".jar!/", (int)0, (boolean)false, (int)6, null);
        if (lastIndexOf == -1) {
            throw (Throwable)new IOException("Invalid Jar path format");
        }
        int splitIdx = lastIndexOf + 4;
        String string = path;
        int n = 0;
        int n2 = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, splitIdx);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String filePath = string3;
        String string4 = path;
        n2 = splitIdx + 2;
        int n3 = path.length();
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String pathInsideJar = string6;
        return new Pair((Object)filePath, (Object)pathInsideJar);
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
        Logger logger = Logger.getInstance(FileUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(FileUtils::class.java)");
        LOG = logger;
    }
}

