/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.LocalVariableInserter;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.data.Jump;
import com.intellij.rt.coverage.instrumentation.data.Switch;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Opcodes;

public class TouchCounter
extends LocalVariableInserter
implements Opcodes {
    private static final String OBJECT_TYPE = "Ljava/lang/Object;";
    private static final String CLASS_DATA_LOCAL_VARIABLE_NAME = "__class__data__";
    private final BranchDataContainer myBranchData;
    private final String myClassName;

    public TouchCounter(MethodVisitor methodVisitor, BranchDataContainer branchData, int access, String desc, String className) {
        super(methodVisitor, access, desc, CLASS_DATA_LOCAL_VARIABLE_NAME, OBJECT_TYPE);
        this.myBranchData = branchData;
        this.myClassName = className;
    }

    public void visitLineNumber(int line, Label start) {
        if (this.myBranchData.getContext().getLineData(line) != null) {
            this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
            InstrumentationUtils.pushInt(this.mv, line);
            this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "trace", "(Ljava/lang/Object;I)V", false);
        }
        super.visitLineNumber(line, start);
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.visitPossibleJump(label);
        Switch aSwitch = this.myBranchData.getSwitch(label);
        if (aSwitch != null) {
            this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
            InstrumentationUtils.pushInt(this.mv, aSwitch.getLine());
            InstrumentationUtils.pushInt(this.mv, aSwitch.getIndex());
            this.mv.visitIntInsn(17, aSwitch.getKey());
            this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchSwitch", "(Ljava/lang/Object;III)V", false);
        }
    }

    private void touchBranch(boolean trueHit, int jumpIndex, int line) {
        this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
        InstrumentationUtils.pushInt(this.mv, line);
        InstrumentationUtils.pushInt(this.mv, jumpIndex);
        this.mv.visitInsn(trueHit ? 4 : 3);
        this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchJump", "(Ljava/lang/Object;IIZ)V", false);
    }

    private void visitPossibleJump(Label label) {
        Jump jump = this.myBranchData.getJump(label);
        if (jump != null) {
            this.touchBranch(jump.getType(), jump.getIndex(), jump.getLine());
        }
    }

    public void visitCode() {
        this.mv.visitLdcInsn(this.myClassName);
        this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "loadClassData", "(Ljava/lang/String;)Ljava/lang/Object;", false);
        this.mv.visitVarInsn(58, this.getOrCreateLocalVariableIndex());
        super.visitCode();
    }
}

