/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleFilters;
import org.languagetool.rules.RemoteRuleMetrics;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteRule
extends Rule {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRule.class);
    private static final ConcurrentMap<String, Long> lastFailure = new ConcurrentHashMap<String, Long>();
    private static final ConcurrentMap<String, Long> timeoutIntervalStart = new ConcurrentHashMap<String, Long>();
    private static final ConcurrentMap<String, AtomicInteger> consecutiveFailures = new ConcurrentHashMap<String, AtomicInteger>();
    private static final ConcurrentMap<String, AtomicLong> timeoutTotal = new ConcurrentHashMap<String, AtomicLong>();
    private static final ConcurrentMap<String, ConcurrentLinkedQueue<Future>> runningTasks = new ConcurrentHashMap<String, ConcurrentLinkedQueue<Future>>();
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("remote-rule-pool-%d").setDaemon(true).build();
    protected static final List<Runnable> shutdownRoutines = new LinkedList<Runnable>();
    static final ExecutorService executor = Executors.newCachedThreadPool(threadFactory);
    protected final RemoteRuleConfig serviceConfiguration;
    protected final boolean inputLogging;
    protected final boolean filterMatches;
    protected final boolean fixOffsets;
    protected final Language ruleLanguage;
    protected final JLanguageTool lt;
    protected final Pattern suppressMisspelledMatch;
    protected final Pattern suppressMisspelledSuggestions;

    public RemoteRule(Language language, ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging, @Nullable String ruleId) {
        super(messages);
        this.serviceConfiguration = config;
        this.ruleLanguage = language;
        this.lt = new JLanguageTool(this.ruleLanguage);
        this.inputLogging = inputLogging;
        if (ruleId == null) {
            ruleId = this.getId();
        }
        this.filterMatches = Boolean.parseBoolean(this.serviceConfiguration.getOptions().getOrDefault("filterMatches", "false"));
        this.fixOffsets = Boolean.parseBoolean(this.serviceConfiguration.getOptions().getOrDefault("fixOffsets", "true"));
        try {
            this.suppressMisspelledMatch = this.serviceConfiguration.getOptions().containsKey("suppressMisspelledMatch") ? Pattern.compile(this.serviceConfiguration.getOptions().get("suppressMisspelledMatch")) : null;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("suppressMisspelledMatch must be a valid regex", e);
        }
        try {
            this.suppressMisspelledSuggestions = this.serviceConfiguration.getOptions().containsKey("suppressMisspelledSuggestions") ? Pattern.compile(this.serviceConfiguration.getOptions().get("suppressMisspelledSuggestions")) : null;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("suppressMisspelledSuggestions must be a valid regex", e);
        }
        lastFailure.putIfAbsent(ruleId, 0L);
        timeoutIntervalStart.putIfAbsent(ruleId, 0L);
        timeoutTotal.putIfAbsent(ruleId, new AtomicLong());
        consecutiveFailures.putIfAbsent(ruleId, new AtomicInteger());
        runningTasks.putIfAbsent(ruleId, new ConcurrentLinkedQueue());
    }

    public RemoteRule(Language language, ResourceBundle messages, RemoteRuleConfig config, boolean inputLogging) {
        this(language, messages, config, inputLogging, null);
    }

    public static void shutdown() {
        shutdownRoutines.forEach(Runnable::run);
    }

    public FutureTask<RemoteRuleResult> run(List<AnalyzedSentence> sentences2) {
        return this.run(sentences2, null);
    }

    protected abstract RemoteRequest prepareRequest(List<AnalyzedSentence> var1, @Nullable Long var2);

    protected abstract Callable<RemoteRuleResult> executeRequest(RemoteRequest var1, long var2) throws TimeoutException;

    protected abstract RemoteRuleResult fallbackResults(RemoteRequest var1);

    public FutureTask<RemoteRuleResult> run(List<AnalyzedSentence> sentences2, @Nullable Long textSessionId) {
        if (sentences2.isEmpty()) {
            return new FutureTask<RemoteRuleResult>(() -> new RemoteRuleResult(false, true, Collections.emptyList(), sentences2));
        }
        return new FutureTask<RemoteRuleResult>(() -> {
            long failureInterval;
            long startTime = System.nanoTime();
            long characters = sentences2.stream().mapToInt(sentence -> sentence.getText().length()).sum();
            String ruleId = this.getId();
            RemoteRequest req = this.prepareRequest(sentences2, textSessionId);
            if (((AtomicInteger)consecutiveFailures.get(ruleId)).get() >= this.serviceConfiguration.getFall() && (failureInterval = System.currentTimeMillis() - (Long)lastFailure.get(ruleId)) < this.serviceConfiguration.getDownMilliseconds()) {
                RemoteRuleMetrics.request(ruleId, 0, 0L, characters, RemoteRuleMetrics.RequestResult.DOWN);
                RemoteRuleResult result2 = this.fallbackResults(req);
                return result2;
            }
            if (System.nanoTime() - (Long)timeoutIntervalStart.get(ruleId) > TimeUnit.MILLISECONDS.toNanos(this.serviceConfiguration.getTimeoutLimitIntervalMilliseconds())) {
                System.out.printf("Resetting timeoutTotal; was %d%n", ((AtomicLong)timeoutTotal.get(ruleId)).intValue());
                ((AtomicLong)timeoutTotal.get(ruleId)).set(0L);
                timeoutIntervalStart.put(ruleId, System.nanoTime());
            } else if (this.serviceConfiguration.getTimeoutLimitTotalMilliseconds() > 0L && ((AtomicLong)timeoutTotal.get(ruleId)).get() > this.serviceConfiguration.getTimeoutLimitTotalMilliseconds()) {
                System.out.printf("Down because of timeoutTotal; was %d%n", ((AtomicLong)timeoutTotal.get(ruleId)).intValue());
                RemoteRuleMetrics.request(ruleId, 0, 0L, characters, RemoteRuleMetrics.RequestResult.DOWN);
                RemoteRuleResult result3 = this.fallbackResults(req);
                return result3;
            }
            RemoteRuleMetrics.up(ruleId, true);
            for (int i2 = 0; i2 <= this.serviceConfiguration.getMaxRetries(); ++i2) {
                long timeout = this.serviceConfiguration.getBaseTimeoutMilliseconds() + (long)Math.round((float)characters * this.serviceConfiguration.getTimeoutPerCharacterMilliseconds());
                Callable<RemoteRuleResult> task2 = this.executeRequest(req, timeout);
                Future<RemoteRuleResult> future = null;
                try {
                    List<RuleMatch> filteredSentenceMatches;
                    List<RuleMatch> sentenceMatches;
                    ArrayList<RuleMatch> filteredMatches;
                    future = executor.submit(task2);
                    ((ConcurrentLinkedQueue)runningTasks.get(ruleId)).add(future);
                    RemoteRuleResult result4 = timeout <= 0L ? future.get() : future.get(timeout, TimeUnit.MILLISECONDS);
                    future.cancel(true);
                    if (result4.isRemote()) {
                        ((AtomicInteger)consecutiveFailures.get(ruleId)).set(0);
                        RemoteRuleMetrics.failures(ruleId, 0);
                    }
                    RemoteRuleMetrics.RequestResult requestResult = result4.isRemote() ? RemoteRuleMetrics.RequestResult.SUCCESS : RemoteRuleMetrics.RequestResult.SKIPPED;
                    RemoteRuleMetrics.request(ruleId, i2, System.nanoTime() - startTime, characters, requestResult);
                    if (this.fixOffsets) {
                        for (AnalyzedSentence sentence2 : sentences2) {
                            List<RuleMatch> toFix = result4.matchesForSentence(sentence2);
                            if (toFix == null) continue;
                            RemoteRule.fixMatchOffsets(sentence2, toFix);
                        }
                    }
                    if (this.filterMatches) {
                        filteredMatches = new ArrayList<RuleMatch>();
                        for (AnalyzedSentence sentence3 : sentences2) {
                            sentenceMatches = result4.matchesForSentence(sentence3);
                            if (sentenceMatches == null) continue;
                            filteredSentenceMatches = RemoteRuleFilters.filterMatches(this.ruleLanguage, sentence3, sentenceMatches);
                            filteredMatches.addAll(filteredSentenceMatches);
                        }
                        result4 = new RemoteRuleResult(result4.isRemote(), result4.isSuccess(), filteredMatches, sentences2);
                    }
                    filteredMatches = new ArrayList();
                    for (AnalyzedSentence sentence3 : sentences2) {
                        sentenceMatches = result4.matchesForSentence(sentence3);
                        if (sentenceMatches == null) continue;
                        filteredSentenceMatches = this.suppressMisspelled(sentenceMatches);
                        filteredMatches.addAll(filteredSentenceMatches);
                    }
                    result4 = new RemoteRuleResult(result4.isRemote(), result4.isSuccess(), filteredMatches, sentences2);
                    RemoteRuleResult remoteRuleResult = result4;
                    return remoteRuleResult;
                }
                catch (Exception e) {
                    RemoteRuleMetrics.RequestResult status;
                    if (e instanceof TimeoutException || e instanceof InterruptedException || e instanceof CancellationException || e.getCause() != null && e.getCause() instanceof TimeoutException) {
                        status = RemoteRuleMetrics.RequestResult.TIMEOUT;
                        logger.warn("Timed out while fetching results for remote rule " + ruleId + ", tried " + (i2 + 1) + " times, timeout: " + timeout + "ms", (Throwable)e);
                        ((AtomicLong)timeoutTotal.get(ruleId)).addAndGet(timeout);
                    } else {
                        status = RemoteRuleMetrics.RequestResult.ERROR;
                        logger.error("Error while fetching results for remote rule " + ruleId + ", tried " + (i2 + 1) + " times, timeout: " + timeout + "ms", (Throwable)e);
                    }
                    RemoteRuleMetrics.request(ruleId, i2, System.nanoTime() - startTime, characters, status);
                    continue;
                }
                finally {
                    if (future != null) {
                        future.cancel(true);
                        ((ConcurrentLinkedQueue)runningTasks.get(ruleId)).remove(future);
                    }
                }
            }
            RemoteRuleMetrics.failures(ruleId, ((AtomicInteger)consecutiveFailures.get(ruleId)).incrementAndGet());
            logger.warn("Fetching results for remote rule " + ruleId + " failed.");
            if (((AtomicInteger)consecutiveFailures.get(ruleId)).get() >= this.serviceConfiguration.getFall() || this.serviceConfiguration.getTimeoutLimitTotalMilliseconds() > 0L && ((AtomicLong)timeoutTotal.get(ruleId)).get() > this.serviceConfiguration.getTimeoutLimitTotalMilliseconds()) {
                lastFailure.put(ruleId, System.currentTimeMillis());
                logger.warn("Remote rule " + ruleId + " marked as DOWN.");
                RemoteRuleMetrics.downtime(ruleId, this.serviceConfiguration.getDownMilliseconds());
                RemoteRuleMetrics.up(ruleId, false);
                System.out.printf("Aborting %d tasks.%n", ((ConcurrentLinkedQueue)runningTasks.get(ruleId)).size());
                ((ConcurrentLinkedQueue)runningTasks.get(ruleId)).forEach(task -> task.cancel(true));
            }
            RemoteRuleResult result5 = this.fallbackResults(req);
            return result5;
        });
    }

    private List<RuleMatch> suppressMisspelled(List<RuleMatch> sentenceMatches) {
        ArrayList<RuleMatch> result2 = new ArrayList<RuleMatch>();
        SpellingCheckRule speller2 = this.ruleLanguage.getDefaultSpellingRule(this.messages);
        Predicate<SuggestedReplacement> checkSpelling = s -> {
            try {
                AnalyzedSentence sentence = this.lt.getRawAnalyzedSentence(s.getReplacement());
                RuleMatch[] matches = speller2.match(sentence);
                return matches.length == 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        if (speller2 == null) {
            if (this.suppressMisspelledMatch != null || this.suppressMisspelledSuggestions != null) {
                logger.warn("Cannot activate suppression of misspelled matches for rule {}, no spelling rule found for language {}.", (Object)this.getId(), (Object)this.ruleLanguage.getShortCodeWithCountryAndVariant());
            }
            return sentenceMatches;
        }
        for (RuleMatch m : sentenceMatches) {
            String id = m.getRule().getId();
            if (this.suppressMisspelledMatch != null && this.suppressMisspelledMatch.matcher(id).matches() && !m.getSuggestedReplacementObjects().stream().allMatch(checkSpelling)) continue;
            if (this.suppressMisspelledSuggestions != null && this.suppressMisspelledSuggestions.matcher(id).matches()) {
                List<SuggestedReplacement> suggestedReplacements = m.getSuggestedReplacementObjects().stream().filter(checkSpelling).collect(Collectors.toList());
                m.setSuggestedReplacementObjects(suggestedReplacements);
            }
            result2.add(m);
        }
        return result2;
    }

    @Override
    public String getId() {
        return this.serviceConfiguration.getRuleId();
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        FutureTask<RemoteRuleResult> task = this.run(Collections.singletonList(sentence));
        task.run();
        try {
            return task.get().getMatches().toArray(RuleMatch.EMPTY_ARRAY);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Fetching results for remote rule " + this.getId() + " failed.", (Throwable)e);
            return RuleMatch.EMPTY_ARRAY;
        }
    }

    public RemoteRuleConfig getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    static int[] computeOffsetShifts(String s) {
        int len = s.length() + 1;
        int[] offsets = new int[len];
        int shifted = 0;
        int original = 0;
        while (shifted < s.length()) {
            offsets[original] = shifted;
            shifted = s.offsetByCodePoints(shifted, 1);
            ++original;
        }
        if (original < len) {
            offsets[original] = shifted;
        }
        for (int i2 = original + 1; i2 < len; ++i2) {
            offsets[i2] = offsets[i2 - 1] + 1;
        }
        return offsets;
    }

    public static void fixMatchOffsets(AnalyzedSentence sentence, List<RuleMatch> matches) {
        int[] shifts = RemoteRule.computeOffsetShifts(sentence.getText());
        matches.forEach(m -> {
            int from = shifts[m.getFromPos()];
            int to = shifts[m.getToPos()];
            m.setOffsetPosition(from, to);
        });
    }

    protected static class RemoteRequest {
        protected RemoteRequest() {
        }
    }
}

