/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.languagetool.UserConfig;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;

public class DictionarySpellMatchFilter
implements RuleMatchFilter {
    private final UserConfig userConfig;

    public DictionarySpellMatchFilter(UserConfig userConfig) {
        this.userConfig = userConfig;
    }

    @Override
    public List<RuleMatch> filter(List<RuleMatch> ruleMatches, AnnotatedText text2) {
        HashSet<String> dictionary = new HashSet<String>(this.userConfig.getAcceptedPhrases());
        if (dictionary.size() > 0) {
            Map<String, List<RuleMatch>> phraseToMatches = this.getPhrases(ruleMatches, text2);
            ArrayList<RuleMatch> cleanMatches = new ArrayList<RuleMatch>(ruleMatches);
            for (Map.Entry<String, List<RuleMatch>> entry : phraseToMatches.entrySet()) {
                if (!dictionary.contains(entry.getKey())) continue;
                cleanMatches.removeAll((Collection)entry.getValue());
            }
            return cleanMatches;
        }
        return ruleMatches;
    }

    Map<String, List<RuleMatch>> getPhrases(List<RuleMatch> ruleMatches, AnnotatedText text2) {
        HashMap<String, List<RuleMatch>> phraseToMatches = new HashMap<String, List<RuleMatch>>();
        int prevToPos = Integer.MIN_VALUE;
        ArrayList<RuleMatch> collectedMatches = new ArrayList<RuleMatch>();
        ArrayList<String> collectedTerms = new ArrayList<String>();
        for (RuleMatch match : ruleMatches) {
            if (!match.getRule().isDictionaryBasedSpellingRule()) continue;
            String covered = text2.getPlainText().substring(match.getFromPos(), match.getToPos());
            if (match.getFromPos() == prevToPos + 1) {
                String key = String.join((CharSequence)" ", collectedTerms) + " " + covered;
                ArrayList<RuleMatch> l = new ArrayList<RuleMatch>(collectedMatches);
                l.add(match);
                phraseToMatches.put(key, l);
            } else {
                collectedTerms.clear();
                collectedMatches.clear();
            }
            collectedTerms.add(covered);
            collectedMatches.add(match);
            prevToPos = match.getToPos();
        }
        return phraseToMatches;
    }
}

