/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0007J\n\u0010\u0016\u001a\u00020\u0010*\u00020\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/grazie/utils/Text;", "", "()V", "PUNCTUATIONS", "", "", "allOccurrences", "", "Lcom/intellij/openapi/util/TextRange;", "pattern", "Ljava/util/regex/Pattern;", "text", "", "findParagraphRange", "range", "isNewline", "", "char", "", "isPunctuation", "isQuote", "isSingleSentence", "looksLikeCode", "intellij.grazie.core"})
public final class Text {
    private static final Set<Byte> PUNCTUATIONS;
    @NotNull
    public static final Text INSTANCE;

    public final boolean isNewline(char c) {
        return c == '\n';
    }

    public final boolean isPunctuation(char c) {
        byte by = (byte)Character.getType(c);
        return PUNCTUATIONS.contains(by);
    }

    public final boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    @JvmStatic
    public static final boolean isSingleSentence(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CharSequence charSequence = text2;
        Regex regex2 = new Regex("\\.\\s");
        boolean bl = false;
        return !regex2.containsMatchIn(charSequence);
    }

    @JvmStatic
    @NotNull
    public static final TextRange findParagraphRange(@NotNull CharSequence text2, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int start = range.getStartOffset();
        while (start > 0) {
            int wsStart;
            for (wsStart = start; wsStart > 0 && CharsKt.isWhitespace((char)text2.charAt(wsStart - 1)); --wsStart) {
            }
            if (wsStart < start) {
                CharSequence $this$count$iv = text2.subSequence(wsStart, start);
                boolean $i$f$count = false;
                int count$iv = 0;
                CharSequence charSequence = $this$count$iv;
                for (int j = 0; j < charSequence.length(); ++j) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(j);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                if (count$iv > 1) break;
            }
            start = wsStart - 1;
        }
        int end = range.getEndOffset();
        while (end < text2.length()) {
            int wsEnd;
            for (wsEnd = end; wsEnd < text2.length() && CharsKt.isWhitespace((char)text2.charAt(wsEnd)); ++wsEnd) {
            }
            if (wsEnd > end) {
                CharSequence $this$count$iv = text2.subSequence(end, wsEnd);
                boolean $i$f$count = false;
                int count$iv = 0;
                CharSequence charSequence = $this$count$iv;
                for (int j = 0; j < charSequence.length(); ++j) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(j);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                if (count$iv > 1) break;
            }
            end = wsEnd + 1;
        }
        return new TextRange(RangesKt.coerceAtLeast((int)start, (int)0), RangesKt.coerceAtMost((int)end, (int)text2.length()));
    }

    public final boolean looksLikeCode(@NotNull CharSequence $this$looksLikeCode) {
        Intrinsics.checkNotNullParameter((Object)$this$looksLikeCode, (String)"$this$looksLikeCode");
        int codeChars = 0;
        int textTokens = 0;
        boolean inToken = false;
        CharSequence charSequence = $this$looksLikeCode;
        for (int j = 0; j < charSequence.length(); ++j) {
            char c;
            char c2 = c = charSequence.charAt(j);
            boolean bl = false;
            if (Character.isLetterOrDigit(c2)) {
                if (inToken) continue;
                inToken = true;
                ++textTokens;
                continue;
            }
            inToken = false;
            if (!StringsKt.contains$default((CharSequence)"(){}[]<>=+-*/%|&!;,.:\"'\\@$#^", (char)c, (boolean)false, (int)2, null)) continue;
            ++codeChars;
        }
        return codeChars > 0 && textTokens / codeChars < 2;
    }

    @JvmStatic
    @NotNull
    public static final List<TextRange> allOccurrences(@NotNull Pattern pattern, @NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        int start = 0;
        boolean bl = false;
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        Matcher matcher = pattern.matcher(text2);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"pattern.matcher(text)");
        Matcher matcher2 = matcher;
        while (matcher2.find(start)) {
            result2.add(new TextRange(matcher2.start(), matcher2.end()));
            start = RangesKt.coerceAtLeast((int)matcher2.end(), (int)(start + 1));
        }
        return result2;
    }

    private Text() {
    }

    static {
        Text text2;
        INSTANCE = text2 = new Text();
        PUNCTUATIONS = SetsKt.setOf((Object[])new Byte[]{(byte)21, (byte)22, (byte)24, (byte)23, (byte)20, (byte)29, (byte)30});
    }
}

