/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.algorithm;

import com.hankcs.algorithm.State;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class AhoCorasickDoubleArrayTrie<V>
implements Serializable {
    protected int[] check;
    protected int[] base;
    protected int[] fail;
    protected int[][] output;
    protected V[] v;
    protected int[] l;
    protected int size;

    public List<Hit<V>> parseText(CharSequence text2) {
        int position = 1;
        int currentState = 0;
        ArrayList<Hit<V>> collectedEmits = new ArrayList<Hit<V>>();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            currentState = this.getState(currentState, text2.charAt(i2));
            this.storeEmits(position, currentState, collectedEmits);
            ++position;
        }
        return collectedEmits;
    }

    public void parseText(CharSequence text2, IHit<V> processor) {
        int position = 1;
        int currentState = 0;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            int[] hitArray = this.output[currentState = this.getState(currentState, text2.charAt(i2))];
            if (hitArray != null) {
                for (int hit : hitArray) {
                    processor.hit(position - this.l[hit], position, this.v[hit]);
                }
            }
            ++position;
        }
    }

    public void parseText(CharSequence text2, IHitCancellable<V> processor) {
        int currentState = 0;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            int position = i2 + 1;
            int[] hitArray = this.output[currentState = this.getState(currentState, text2.charAt(i2))];
            if (hitArray == null) continue;
            for (int hit : hitArray) {
                boolean proceed = processor.hit(position - this.l[hit], position, this.v[hit]);
                if (proceed) continue;
                return;
            }
        }
    }

    public void parseText(char[] text2, IHit<V> processor) {
        int position = 1;
        int currentState = 0;
        for (char c : text2) {
            int[] hitArray = this.output[currentState = this.getState(currentState, c)];
            if (hitArray != null) {
                for (int hit : hitArray) {
                    processor.hit(position - this.l[hit], position, this.v[hit]);
                }
            }
            ++position;
        }
    }

    public void parseText(char[] text2, IHitFull<V> processor) {
        int position = 1;
        int currentState = 0;
        for (char c : text2) {
            int[] hitArray = this.output[currentState = this.getState(currentState, c)];
            if (hitArray != null) {
                for (int hit : hitArray) {
                    processor.hit(position - this.l[hit], position, this.v[hit], hit);
                }
            }
            ++position;
        }
    }

    public boolean matches(String text2) {
        int currentState = 0;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            int[] hitArray = this.output[currentState = this.getState(currentState, text2.charAt(i2))];
            if (hitArray == null) continue;
            return true;
        }
        return false;
    }

    public Hit<V> findFirst(String text2) {
        int position = 1;
        int currentState = 0;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            int[] hitArray = this.output[currentState = this.getState(currentState, text2.charAt(i2))];
            if (hitArray != null) {
                int hitIndex = hitArray[0];
                return new Hit<V>(position - this.l[hitIndex], position, this.v[hitIndex]);
            }
            ++position;
        }
        return null;
    }

    public void save(ObjectOutputStream out) throws IOException {
        out.writeObject(this.base);
        out.writeObject(this.check);
        out.writeObject(this.fail);
        out.writeObject(this.output);
        out.writeObject(this.l);
        out.writeObject(this.v);
    }

    public void load(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.base = (int[])in.readObject();
        this.check = (int[])in.readObject();
        this.fail = (int[])in.readObject();
        this.output = (int[][])in.readObject();
        this.l = (int[])in.readObject();
        this.v = (Object[])in.readObject();
    }

    public V get(String key) {
        int index = this.exactMatchSearch(key);
        if (index >= 0) {
            return this.v[index];
        }
        return null;
    }

    public boolean set(String key, V value) {
        int index = this.exactMatchSearch(key);
        if (index >= 0) {
            this.v[index] = value;
            return true;
        }
        return false;
    }

    public V get(int index) {
        return this.v[index];
    }

    private int getState(int currentState, char character) {
        int newCurrentState = this.transitionWithRoot(currentState, character);
        while (newCurrentState == -1) {
            currentState = this.fail[currentState];
            newCurrentState = this.transitionWithRoot(currentState, character);
        }
        return newCurrentState;
    }

    private void storeEmits(int position, int currentState, List<Hit<V>> collectedEmits) {
        int[] hitArray = this.output[currentState];
        if (hitArray != null) {
            for (int hit : hitArray) {
                collectedEmits.add(new Hit<V>(position - this.l[hit], position, this.v[hit]));
            }
        }
    }

    protected int transition(int current, char c) {
        int b2 = current;
        int p2 = b2 + c + 1;
        if (b2 != this.check[p2]) {
            return -1;
        }
        b2 = this.base[p2];
        p2 = b2;
        return p2;
    }

    protected int transitionWithRoot(int nodePos, char c) {
        int b2 = this.base[nodePos];
        int p2 = b2 + c + 1;
        if (b2 != this.check[p2]) {
            if (nodePos == 0) {
                return 0;
            }
            return -1;
        }
        return p2;
    }

    public void build(Map<String, V> map2) {
        new Builder().build(map2);
    }

    public int exactMatchSearch(String key) {
        return this.exactMatchSearch(key, 0, 0, 0);
    }

    private int exactMatchSearch(String key, int pos, int len, int nodePos) {
        if (len <= 0) {
            len = key.length();
        }
        if (nodePos <= 0) {
            nodePos = 0;
        }
        int result2 = -1;
        char[] keyChars = key.toCharArray();
        return this.getMatched(pos, len, result2, keyChars, this.base[nodePos]);
    }

    private int getMatched(int pos, int len, int result2, char[] keyChars, int b1) {
        int p2;
        int b2 = b1;
        for (int i2 = pos; i2 < len; ++i2) {
            p2 = b2 + keyChars[i2] + 1;
            if (b2 != this.check[p2]) {
                return result2;
            }
            b2 = this.base[p2];
        }
        p2 = b2;
        int n = this.base[p2];
        if (b2 == this.check[p2]) {
            result2 = -n - 1;
        }
        return result2;
    }

    private int exactMatchSearch(char[] keyChars, int pos, int len, int nodePos) {
        int result2 = -1;
        return this.getMatched(pos, len, result2, keyChars, this.base[nodePos]);
    }

    public int size() {
        return this.v.length;
    }

    private class Builder {
        private State rootState = new State();
        private boolean[] used;
        private int allocSize;
        private int progress;
        private int nextCheckPos;
        private int keySize;

        private Builder() {
        }

        public void build(Map<String, V> map2) {
            AhoCorasickDoubleArrayTrie.this.v = map2.values().toArray();
            AhoCorasickDoubleArrayTrie.this.l = new int[AhoCorasickDoubleArrayTrie.this.v.length];
            Set<String> keySet = map2.keySet();
            this.addAllKeyword(keySet);
            this.buildDoubleArrayTrie(keySet.size());
            this.used = null;
            this.constructFailureStates();
            this.rootState = null;
            this.loseWeight();
        }

        private int fetch(State parent, List<Map.Entry<Integer, State>> siblings2) {
            if (parent.isAcceptable()) {
                State fakeNode = new State(-(parent.getDepth() + 1));
                fakeNode.addEmit(parent.getLargestValueId());
                siblings2.add(new AbstractMap.SimpleEntry<Integer, State>(0, fakeNode));
            }
            for (Map.Entry<Character, State> entry : parent.getSuccess().entrySet()) {
                siblings2.add(new AbstractMap.SimpleEntry<Integer, State>(entry.getKey().charValue() + '\u0001', entry.getValue()));
            }
            return siblings2.size();
        }

        private void addKeyword(String keyword, int index) {
            State currentState = this.rootState;
            char[] cArray = keyword.toCharArray();
            int n = cArray.length;
            for (int j = 0; j < n; ++j) {
                Character character = Character.valueOf(cArray[j]);
                currentState = currentState.addState(character);
            }
            currentState.addEmit(index);
            AhoCorasickDoubleArrayTrie.this.l[index] = keyword.length();
        }

        private void addAllKeyword(Collection<String> keywordSet) {
            int i2 = 0;
            for (String keyword : keywordSet) {
                this.addKeyword(keyword, i2++);
            }
        }

        private void constructFailureStates() {
            AhoCorasickDoubleArrayTrie.this.fail = new int[AhoCorasickDoubleArrayTrie.this.size + 1];
            AhoCorasickDoubleArrayTrie.this.output = new int[AhoCorasickDoubleArrayTrie.this.size + 1][];
            ArrayDeque<State> queue = new ArrayDeque<State>();
            for (State depthOneState : this.rootState.getStates()) {
                depthOneState.setFailure(this.rootState, AhoCorasickDoubleArrayTrie.this.fail);
                queue.add(depthOneState);
                this.constructOutput(depthOneState);
            }
            while (!queue.isEmpty()) {
                State currentState = (State)queue.remove();
                for (Character transition : currentState.getTransitions()) {
                    State targetState = currentState.nextState(transition);
                    queue.add(targetState);
                    State traceFailureState = currentState.failure();
                    while (traceFailureState.nextState(transition) == null) {
                        traceFailureState = traceFailureState.failure();
                    }
                    State newFailureState = traceFailureState.nextState(transition);
                    targetState.setFailure(newFailureState, AhoCorasickDoubleArrayTrie.this.fail);
                    targetState.addEmit(newFailureState.emit());
                    this.constructOutput(targetState);
                }
            }
        }

        private void constructOutput(State targetState) {
            Collection<Integer> emit = targetState.emit();
            if (emit == null || emit.size() == 0) {
                return;
            }
            int[] output2 = new int[emit.size()];
            Iterator<Integer> it = emit.iterator();
            for (int i2 = 0; i2 < output2.length; ++i2) {
                output2[i2] = it.next();
            }
            AhoCorasickDoubleArrayTrie.this.output[targetState.getIndex()] = output2;
        }

        private void buildDoubleArrayTrie(int keySize) {
            this.progress = 0;
            this.keySize = keySize;
            this.resize(0x200000);
            AhoCorasickDoubleArrayTrie.this.base[0] = 1;
            this.nextCheckPos = 0;
            State root_node = this.rootState;
            ArrayList<Map.Entry<Integer, State>> siblings2 = new ArrayList<Map.Entry<Integer, State>>(root_node.getSuccess().entrySet().size());
            this.fetch(root_node, siblings2);
            if (!siblings2.isEmpty()) {
                this.insert(siblings2);
            }
        }

        private int resize(int newSize) {
            int[] base2 = new int[newSize];
            int[] check2 = new int[newSize];
            boolean[] used2 = new boolean[newSize];
            if (this.allocSize > 0) {
                System.arraycopy(AhoCorasickDoubleArrayTrie.this.base, 0, base2, 0, this.allocSize);
                System.arraycopy(AhoCorasickDoubleArrayTrie.this.check, 0, check2, 0, this.allocSize);
                System.arraycopy(this.used, 0, used2, 0, this.allocSize);
            }
            AhoCorasickDoubleArrayTrie.this.base = base2;
            AhoCorasickDoubleArrayTrie.this.check = check2;
            this.used = used2;
            this.allocSize = newSize;
            return this.allocSize;
        }

        private void insert(List<Map.Entry<Integer, State>> firstSiblings) {
            ArrayDeque<Map.Entry<Integer, List<Map.Entry<Integer, State>>>> siblingQueue = new ArrayDeque<Map.Entry<Integer, List<Map.Entry<Integer, State>>>>();
            siblingQueue.add(new AbstractMap.SimpleEntry<Object, List<Map.Entry<Integer, State>>>(null, firstSiblings));
            while (!siblingQueue.isEmpty()) {
                this.insert(siblingQueue);
            }
        }

        private void insert(Queue<Map.Entry<Integer, List<Map.Entry<Integer, State>>>> siblingQueue) {
            Map.Entry<Integer, List<Map.Entry<Integer, State>>> tCurrent = siblingQueue.remove();
            List<Map.Entry<Integer, State>> siblings2 = tCurrent.getValue();
            int begin = 0;
            int pos = Math.max(siblings2.get(0).getKey() + 1, this.nextCheckPos) - 1;
            int nonzero_num = 0;
            boolean first = false;
            if (this.allocSize <= pos) {
                this.resize(pos + 1);
            }
            block0: while (true) {
                if (this.allocSize <= ++pos) {
                    this.resize(pos + 1);
                }
                if (AhoCorasickDoubleArrayTrie.this.check[pos] != 0) {
                    ++nonzero_num;
                    continue;
                }
                if (!first) {
                    this.nextCheckPos = pos;
                    first = true;
                }
                if (this.allocSize <= (begin = pos - siblings2.get(0).getKey()) + siblings2.get(siblings2.size() - 1).getKey()) {
                    double l = 1.05 > 1.0 * (double)this.keySize / (double)(this.progress + 1) ? 1.05 : 1.0 * (double)this.keySize / (double)(this.progress + 1);
                    this.resize((int)((double)this.allocSize * l));
                }
                if (this.used[begin]) continue;
                for (int i2 = 1; i2 < siblings2.size(); ++i2) {
                    if (AhoCorasickDoubleArrayTrie.this.check[begin + siblings2.get(i2).getKey()] == 0) continue;
                    continue block0;
                }
                break;
            }
            if (1.0 * (double)nonzero_num / (double)(pos - this.nextCheckPos + 1) >= 0.95) {
                this.nextCheckPos = pos;
            }
            this.used[begin] = true;
            AhoCorasickDoubleArrayTrie.this.size = AhoCorasickDoubleArrayTrie.this.size > begin + siblings2.get(siblings2.size() - 1).getKey() + 1 ? AhoCorasickDoubleArrayTrie.this.size : begin + siblings2.get(siblings2.size() - 1).getKey() + 1;
            for (Map.Entry<Integer, State> sibling : siblings2) {
                AhoCorasickDoubleArrayTrie.this.check[begin + sibling.getKey().intValue()] = begin;
            }
            for (Map.Entry<Integer, State> sibling : siblings2) {
                ArrayList<Map.Entry<Integer, State>> new_siblings = new ArrayList<Map.Entry<Integer, State>>(sibling.getValue().getSuccess().entrySet().size() + 1);
                if (this.fetch(sibling.getValue(), new_siblings) == 0) {
                    AhoCorasickDoubleArrayTrie.this.base[begin + sibling.getKey().intValue()] = -sibling.getValue().getLargestValueId().intValue() - 1;
                    ++this.progress;
                } else {
                    siblingQueue.add(new AbstractMap.SimpleEntry<Integer, ArrayList<Map.Entry<Integer, State>>>(begin + sibling.getKey(), new_siblings));
                }
                sibling.getValue().setIndex(begin + sibling.getKey());
            }
            Integer parentBaseIndex = tCurrent.getKey();
            if (parentBaseIndex != null) {
                AhoCorasickDoubleArrayTrie.this.base[parentBaseIndex.intValue()] = begin;
            }
        }

        private void loseWeight() {
            int[] nbase = new int[AhoCorasickDoubleArrayTrie.this.size + 65535];
            System.arraycopy(AhoCorasickDoubleArrayTrie.this.base, 0, nbase, 0, AhoCorasickDoubleArrayTrie.this.size);
            AhoCorasickDoubleArrayTrie.this.base = nbase;
            int[] ncheck = new int[AhoCorasickDoubleArrayTrie.this.size + 65535];
            System.arraycopy(AhoCorasickDoubleArrayTrie.this.check, 0, ncheck, 0, AhoCorasickDoubleArrayTrie.this.size);
            AhoCorasickDoubleArrayTrie.this.check = ncheck;
        }
    }

    public static class Hit<V> {
        public final int begin;
        public final int end;
        public final V value;

        public Hit(int begin, int end, V value) {
            this.begin = begin;
            this.end = end;
            this.value = value;
        }

        public String toString() {
            return String.format("[%d:%d]=%s", this.begin, this.end, this.value);
        }
    }

    public static interface IHitCancellable<V> {
        public boolean hit(int var1, int var2, V var3);
    }

    public static interface IHitFull<V> {
        public void hit(int var1, int var2, V var3, int var4);
    }

    public static interface IHit<V> {
        public void hit(int var1, int var2, V var3);
    }
}

