/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.ui.ColorUtil;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.Animations;
import com.intellij.util.animation.DoubleArrayFunction;
import com.intellij.util.animation.DoubleColorFunction;
import com.intellij.util.animation.DoubleDimensionFunction;
import com.intellij.util.animation.DoubleIntFunction;
import com.intellij.util.animation.DoublePointFunction;
import com.intellij.util.animation.DoubleRectangleFunction;
import com.intellij.util.animation.JBAnimator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.IntConsumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a%\u0010\u0000\u001a\u00020\u00012\u001d\u0010\u0002\u001a\u0019\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\b\u0007\u001a\u0006\u0010\b\u001a\u00020\u0006\u001a$\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r\u001a$\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a$\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000f0\r\u001a$\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u001a\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0011\u001a'\u0010\b\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00140\r\u00a2\u0006\u0002\u0010\u0015\u001a\u001e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0011\u001a\u001e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0018\u001a$\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u00192\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00190\r\u001a(\u0010\f\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u001a0\r\u001a%\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0013\"\u00020\u0006\u00a2\u0006\u0002\u0010\u001f\u001a\u0018\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0017H\u0002\u001a\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u001c2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0019H\u0002\u001a\u001c\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r\u00a8\u0006%"}, d2={"animate", "", "block", "Lkotlin/Function1;", "Lcom/intellij/util/animation/JBAnimator;", "", "Lcom/intellij/util/animation/Animation;", "Lkotlin/ExtensionFunctionType;", "animation", "from", "Ljava/awt/Color;", "to", "consumer", "Ljava/util/function/Consumer;", "Ljava/awt/Dimension;", "Ljava/awt/Point;", "Ljava/awt/Rectangle;", "Ljava/util/function/DoubleConsumer;", "icons", "", "Ljavax/swing/Icon;", "([Ljavax/swing/Icon;Ljava/util/function/Consumer;)Lcom/intellij/util/animation/Animation;", "", "", "Ljava/util/function/IntConsumer;", "", "T", "function", "Ljava/util/function/DoubleFunction;", "makeSequent", "animations", "([Lcom/intellij/util/animation/Animation;)Ljava/util/Collection;", "range", "Lcom/intellij/util/animation/DoubleIntFunction;", "text", "transparent", "color", "intellij.platform.ide"})
@JvmName(name="Animations")
public final class Animations {
    public static final void animate(@NotNull Function1<? super JBAnimator, ? extends Collection<Animation>> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        JBAnimator animator = new JBAnimator();
        animator.animate((Collection)block.invoke((Object)animator));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Animation> makeSequent(Animation ... animations) {
        Intrinsics.checkNotNullParameter((Object)animations, (String)"animations");
        int n = 1;
        int n2 = animations.length;
        while (n < n2) {
            Animation curr;
            void i2;
            Animation prev = animations[i2 - true];
            Animation animation2 = curr = animations[i2];
            animation2.setDelay(animation2.getDelay() + (prev.getDelay() + prev.getDuration()));
            ++i2;
        }
        return ArraysKt.toList((Object[])animations);
    }

    @NotNull
    public static final Animation animation() {
        return Animations.animation(animation.1.INSTANCE);
    }

    @NotNull
    public static final Animation animation(@NotNull DoubleConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        return new Animation(consumer2);
    }

    @NotNull
    public static final Animation animation(int from, int to, @NotNull IntConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        return new Animation(new DoubleConsumer(consumer2, from, to){
            final /* synthetic */ IntConsumer $consumer;
            final /* synthetic */ int $from;
            final /* synthetic */ int $to;

            public final void accept(double value2) {
                this.$consumer.accept(MathKt.roundToInt((double)((double)this.$from + value2 * (double)(this.$to - this.$from))));
            }
            {
                this.$consumer = intConsumer;
                this.$from = n;
                this.$to = n2;
            }
        });
    }

    @NotNull
    public static final Animation animation(double from, double to, @NotNull DoubleConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        return new Animation(new DoubleConsumer(consumer2, from, to){
            final /* synthetic */ DoubleConsumer $consumer;
            final /* synthetic */ double $from;
            final /* synthetic */ double $to;

            public final void accept(double value2) {
                this.$consumer.accept(this.$from + value2 * (this.$to - this.$from));
            }
            {
                this.$consumer = doubleConsumer;
                this.$from = d;
                this.$to = d2;
            }
        });
    }

    @NotNull
    public static final Animation animation(@NotNull Point from, @NotNull Point to, @NotNull Consumer<Point> consumer2) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return new Animation(new DoublePointFunction(from, to), consumer2);
    }

    @NotNull
    public static final Animation animation(@NotNull Rectangle from, @NotNull Rectangle to, @NotNull Consumer<Rectangle> consumer2) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return new Animation(new DoubleRectangleFunction(from, to), consumer2);
    }

    @NotNull
    public static final Animation animation(@NotNull Icon[] icons, @NotNull Consumer<Icon> consumer2) {
        Intrinsics.checkNotNullParameter((Object)icons, (String)"icons");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return new Animation((DoubleFunction)new DoubleArrayFunction<Icon>(icons), consumer2);
    }

    @NotNull
    public static final Animation animation(@NotNull Dimension from, @NotNull Dimension to, @NotNull Consumer<Dimension> consumer2) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return new Animation(new DoubleDimensionFunction(from, to), consumer2);
    }

    @NotNull
    public static final Animation animation(@NotNull Color from, @NotNull Color to, @NotNull Consumer<Color> consumer2) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return new Animation(new DoubleColorFunction(from, to), consumer2);
    }

    @NotNull
    public static final Animation transparent(@NotNull Color color, @NotNull Consumer<Color> consumer2) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        Color color2 = ColorUtil.withAlpha((Color)color, (double)0.0);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"ColorUtil.withAlpha(color, 0.0)");
        return Animations.animation(color, color2, consumer2);
    }

    @NotNull
    public static final <T> DoubleConsumer consumer(@NotNull DoubleFunction<T> function, @NotNull Consumer<T> consumer2) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return new DoubleConsumer(consumer2, function){
            final /* synthetic */ Consumer $consumer;
            final /* synthetic */ DoubleFunction $function;

            public final void accept(double it) {
                this.$consumer.accept(this.$function.apply(it));
            }
            {
                this.$consumer = consumer2;
                this.$function = doubleFunction;
            }
        };
    }

    private static final DoubleFunction<String> text(String from, String to) {
        String longer;
        String shorter = from.length() < to.length() ? from : to;
        String string = longer = from == shorter ? to : from;
        if (shorter.length() == longer.length() || !StringsKt.startsWith$default((String)longer, (String)shorter, (boolean)false, (int)2, null)) {
            double fraction = (double)from.length() / (double)(from.length() + to.length());
            return new DoubleFunction(fraction, from, to){
                final /* synthetic */ double $fraction;
                final /* synthetic */ String $from;
                final /* synthetic */ String $to;

                public final String apply(double timeline) {
                    String string;
                    if (timeline < this.$fraction) {
                        String string2 = this.$from;
                        int n = 0;
                        int n2 = MathKt.roundToInt((double)((double)this.$from.length() * ((this.$fraction - timeline) / this.$fraction)));
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n, n2);
                        string = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    } else {
                        String string5 = this.$to;
                        int n = 0;
                        int n3 = MathKt.roundToInt((double)((double)this.$to.length() * (timeline - this.$fraction) / (1.0 - this.$fraction)));
                        boolean bl = false;
                        String string6 = string5;
                        if (string6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.substring(n, n3);
                        string = string7;
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    }
                    return string;
                }
                {
                    this.$fraction = d;
                    this.$from = string;
                    this.$to = string2;
                }
            };
        }
        return from == shorter ? (DoubleFunction)new DoubleFunction(longer, shorter){
            final /* synthetic */ String $longer;
            final /* synthetic */ String $shorter;

            public final String apply(double timeline) {
                String string = this.$longer;
                int n = 0;
                int n2 = MathKt.roundToInt((double)((double)this.$shorter.length() + (double)(this.$longer.length() - this.$shorter.length()) * timeline));
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
            {
                this.$longer = string;
                this.$shorter = string2;
            }
        } : (DoubleFunction)new DoubleFunction(longer, shorter){
            final /* synthetic */ String $longer;
            final /* synthetic */ String $shorter;

            public final String apply(double timeline) {
                String string = this.$longer;
                int n = 0;
                int n2 = MathKt.roundToInt((double)((double)this.$longer.length() - (double)(this.$longer.length() - this.$shorter.length()) * timeline));
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
            {
                this.$longer = string;
                this.$shorter = string2;
            }
        };
    }

    @NotNull
    public static final Animation animation(@NotNull String from, @NotNull String to, @NotNull Consumer<String> consumer2) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return new Animation(Animations.text(from, to), consumer2);
    }

    private static final DoubleIntFunction range(int from, int to) {
        return new DoubleIntFunction(from, to){
            final /* synthetic */ int $from;
            final /* synthetic */ int $to;

            public final int apply(double value2) {
                return (int)((double)this.$from + value2 * (double)(this.$to - this.$from));
            }
            {
                this.$from = n;
                this.$to = n2;
            }
        };
    }

    public static final /* synthetic */ DoubleIntFunction access$range(int from, int to) {
        return Animations.range(from, to);
    }
}

