/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.reference.SoftReference;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.impl.SyntaxHighlighterOverEditorHighlighter;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.util.Processor;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChunkExtractor {
    private static final Logger LOG = Logger.getInstance(ChunkExtractor.class);
    static final int MAX_LINE_LENGTH_TO_SHOW = 200;
    static final int OFFSET_BEFORE_TO_SHOW_WHEN_LONG_LINE = 40;
    static final int OFFSET_AFTER_TO_SHOW_WHEN_LONG_LINE = 100;
    private final EditorColorsScheme myColorsScheme;
    private final Document myDocument;
    private long myDocumentStamp;
    private final SyntaxHighlighterOverEditorHighlighter myHighlighter;
    private static final ThreadLocal<WeakFactory> ourExtractors = ThreadLocal.withInitial(() -> new WeakFactory());

    static TextChunk @NotNull [] extractChunks(@NotNull PsiFile file, @NotNull UsageInfo2UsageAdapter usageAdapter) {
        if (file == null) {
            ChunkExtractor.$$$reportNull$$$0(0);
        }
        if (usageAdapter == null) {
            ChunkExtractor.$$$reportNull$$$0(1);
        }
        return ChunkExtractor.getExtractor(file).extractChunks(usageAdapter, file);
    }

    @NotNull
    public static ChunkExtractor getExtractor(@NotNull PsiFile file) {
        if (file == null) {
            ChunkExtractor.$$$reportNull$$$0(2);
        }
        ChunkExtractor chunkExtractor = ourExtractors.get().getValue().get(file);
        if (chunkExtractor == null) {
            ChunkExtractor.$$$reportNull$$$0(3);
        }
        return chunkExtractor;
    }

    private ChunkExtractor(@NotNull PsiFile file) {
        if (file == null) {
            ChunkExtractor.$$$reportNull$$$0(4);
        }
        this.myColorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
        Project project = file.getProject();
        this.myDocument = PsiDocumentManager.getInstance(project).getDocument(file);
        LOG.assertTrue(this.myDocument != null);
        FileType fileType = file.getFileType();
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(fileType, project, file.getVirtualFile());
        highlighter = highlighter == null ? new PlainSyntaxHighlighter() : highlighter;
        this.myHighlighter = new SyntaxHighlighterOverEditorHighlighter(highlighter, file.getVirtualFile(), project);
        this.myDocumentStamp = -1L;
    }

    public static int getStartOffset(List<? extends RangeMarker> rangeMarkers) {
        LOG.assertTrue(!rangeMarkers.isEmpty());
        int minStart = Integer.MAX_VALUE;
        for (RangeMarker rangeMarker : rangeMarkers) {
            int startOffset;
            if (!rangeMarker.isValid() || (startOffset = rangeMarker.getStartOffset()) >= minStart) continue;
            minStart = startOffset;
        }
        return minStart == Integer.MAX_VALUE ? -1 : minStart;
    }

    private TextChunk @NotNull [] extractChunks(@NotNull UsageInfo2UsageAdapter usageInfo2UsageAdapter, @NotNull PsiFile file) {
        int fragmentToShowEnd;
        int absoluteStartOffset;
        if (usageInfo2UsageAdapter == null) {
            ChunkExtractor.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ChunkExtractor.$$$reportNull$$$0(6);
        }
        if ((absoluteStartOffset = usageInfo2UsageAdapter.getNavigationOffset()) == -1) {
            if (TextChunk.EMPTY_ARRAY == null) {
                ChunkExtractor.$$$reportNull$$$0(7);
            }
            return TextChunk.EMPTY_ARRAY;
        }
        Document visibleDocument = this.myDocument instanceof DocumentWindow ? ((DocumentWindow)this.myDocument).getDelegate() : this.myDocument;
        int visibleStartOffset = this.myDocument instanceof DocumentWindow ? ((DocumentWindow)this.myDocument).injectedToHost(absoluteStartOffset) : absoluteStartOffset;
        int lineNumber = this.myDocument.getLineNumber(absoluteStartOffset);
        int visibleLineNumber = visibleDocument.getLineNumber(visibleStartOffset);
        ArrayList result = new ArrayList();
        ChunkExtractor.appendPrefix(result, visibleLineNumber);
        int fragmentToShowStart = this.myDocument.getLineStartOffset(lineNumber);
        int n = fragmentToShowEnd = fragmentToShowStart < this.myDocument.getTextLength() ? this.myDocument.getLineEndOffset(lineNumber) : 0;
        if (fragmentToShowStart > fragmentToShowEnd) {
            if (TextChunk.EMPTY_ARRAY == null) {
                ChunkExtractor.$$$reportNull$$$0(8);
            }
            return TextChunk.EMPTY_ARRAY;
        }
        CharSequence chars = this.myDocument.getCharsSequence();
        if (fragmentToShowEnd - fragmentToShowStart > 200) {
            int lineStartOffset = fragmentToShowStart;
            fragmentToShowStart = Math.max(lineStartOffset, absoluteStartOffset - 40);
            int lineEndOffset = fragmentToShowEnd;
            Segment segment = usageInfo2UsageAdapter.getUsageInfo().getSegment();
            int usage_length = segment != null ? segment.getEndOffset() - segment.getStartOffset() : 0;
            if (usage_length > 0 && StringUtil.isJavaIdentifierStart((char)chars.charAt(absoluteStartOffset)) && StringUtil.isJavaIdentifierStart((char)chars.charAt(absoluteStartOffset + usage_length - 1))) {
                for (fragmentToShowEnd = Math.min(lineEndOffset, absoluteStartOffset + usage_length + 100); fragmentToShowEnd < lineEndOffset && StringUtil.isJavaIdentifierStart((char)chars.charAt(fragmentToShowEnd - 1)); ++fragmentToShowEnd) {
                }
                while (fragmentToShowStart > lineStartOffset && StringUtil.isJavaIdentifierStart((char)chars.charAt(fragmentToShowStart))) {
                    --fragmentToShowStart;
                }
                if (fragmentToShowStart != lineStartOffset) {
                    ++fragmentToShowStart;
                }
                if (fragmentToShowEnd != lineEndOffset) {
                    --fragmentToShowEnd;
                }
            }
        }
        if (this.myDocument instanceof DocumentWindow) {
            List<TextRange> editable = InjectedLanguageManager.getInstance(file.getProject()).intersectWithAllEditableFragments(file, new TextRange(fragmentToShowStart, fragmentToShowEnd));
            for (TextRange range2 : editable) {
                this.createTextChunks(usageInfo2UsageAdapter, chars, range2.getStartOffset(), range2.getEndOffset(), true, result);
            }
            TextChunk[] textChunkArray = result.toArray(TextChunk.EMPTY_ARRAY);
            if (textChunkArray == null) {
                ChunkExtractor.$$$reportNull$$$0(9);
            }
            return textChunkArray;
        }
        TextChunk[] textChunkArray = this.createTextChunks(usageInfo2UsageAdapter, chars, fragmentToShowStart, fragmentToShowEnd, true, result);
        if (textChunkArray == null) {
            ChunkExtractor.$$$reportNull$$$0(10);
        }
        return textChunkArray;
    }

    public TextChunk @NotNull [] createTextChunks(@NotNull UsageInfo2UsageAdapter usageInfo2UsageAdapter, @NotNull CharSequence chars, int start, int end, boolean selectUsageWithBold, @NotNull List<? super TextChunk> result) {
        if (usageInfo2UsageAdapter == null) {
            ChunkExtractor.$$$reportNull$$$0(11);
        }
        if (chars == null) {
            ChunkExtractor.$$$reportNull$$$0(12);
        }
        if (result == null) {
            ChunkExtractor.$$$reportNull$$$0(13);
        }
        this.processTokens(chars, start, end, (startOffset, endOffset, textAttributesKeys) -> {
            this.processIntersectingRange(usageInfo2UsageAdapter, chars, startOffset, endOffset, textAttributesKeys, selectUsageWithBold, result);
            return true;
        });
        TextChunk[] textChunkArray = result.toArray(TextChunk.EMPTY_ARRAY);
        if (textChunkArray == null) {
            ChunkExtractor.$$$reportNull$$$0(14);
        }
        return textChunkArray;
    }

    private void processTokens(@NotNull CharSequence chars, int start, int end, @NotNull TokenHighlightProcessor tokenHighlightProcessor) {
        if (chars == null) {
            ChunkExtractor.$$$reportNull$$$0(15);
        }
        if (tokenHighlightProcessor == null) {
            ChunkExtractor.$$$reportNull$$$0(16);
        }
        Lexer lexer = this.myHighlighter.getHighlightingLexer();
        SyntaxHighlighterOverEditorHighlighter highlighter = this.myHighlighter;
        LOG.assertTrue(start <= end);
        int i2 = StringUtil.indexOf((CharSequence)chars, (char)'\n', (int)start, (int)end);
        if (i2 != -1) {
            end = i2;
        }
        if (this.myDocumentStamp != this.myDocument.getModificationStamp()) {
            highlighter.restart(chars);
            this.myDocumentStamp = this.myDocument.getModificationStamp();
        } else if (lexer.getTokenType() == null || lexer.getTokenStart() > start) {
            highlighter.resetPosition(0);
        }
        boolean isBeginning = true;
        while (lexer.getTokenType() != null) {
            String text2;
            int hiStart = lexer.getTokenStart();
            int hiEnd = lexer.getTokenEnd();
            if (hiStart >= end) break;
            if (!((hiStart = Math.max(hiStart, start)) >= (hiEnd = Math.min(hiEnd, end)) || isBeginning && (text2 = chars.subSequence(hiStart, hiEnd).toString()).trim().isEmpty())) {
                isBeginning = false;
                IElementType tokenType = lexer.getTokenType();
                TextAttributesKey[] tokenHighlights = highlighter.getTokenHighlights(tokenType);
                if (!tokenHighlightProcessor.process(hiStart, hiEnd, tokenHighlights)) {
                    return;
                }
            }
            lexer.advance();
        }
    }

    private void processIntersectingRange(@NotNull UsageInfo2UsageAdapter usageInfo2UsageAdapter, @NotNull CharSequence chars, int hiStart, int hiEnd, TextAttributesKey @NotNull [] tokenHighlights, boolean selectUsageWithBold, @NotNull List<? super TextChunk> result) {
        if (usageInfo2UsageAdapter == null) {
            ChunkExtractor.$$$reportNull$$$0(17);
        }
        if (chars == null) {
            ChunkExtractor.$$$reportNull$$$0(18);
        }
        if (result == null) {
            ChunkExtractor.$$$reportNull$$$0(19);
        }
        if (tokenHighlights == null) {
            ChunkExtractor.$$$reportNull$$$0(20);
        }
        TextAttributes originalAttrs = this.convertAttributes(tokenHighlights);
        if (selectUsageWithBold) {
            originalAttrs.setFontType(0);
        }
        int[] lastOffset = new int[]{hiStart};
        usageInfo2UsageAdapter.processRangeMarkers((Processor<? super Segment>)((Processor)segment -> {
            int usageEnd;
            int usageStart = segment.getStartOffset();
            if (ChunkExtractor.rangeIntersect(lastOffset[0], hiEnd, usageStart, usageEnd = segment.getEndOffset())) {
                ChunkExtractor.addChunk(chars, lastOffset[0], Math.max(lastOffset[0], usageStart), originalAttrs, false, result);
                ChunkExtractor.addChunk(chars, Math.max(lastOffset[0], usageStart), Math.min(hiEnd, usageEnd), originalAttrs, selectUsageWithBold, result);
                lastOffset[0] = usageEnd;
                if (usageEnd > hiEnd) {
                    return false;
                }
            }
            return true;
        }));
        if (lastOffset[0] < hiEnd) {
            ChunkExtractor.addChunk(chars, lastOffset[0], hiEnd, originalAttrs, false, result);
        }
    }

    @Nullable
    UsageType deriveUsageTypeFromHighlighting(@NotNull CharSequence chars, int usageStartOffset, int usageEndOffset) {
        if (chars == null) {
            ChunkExtractor.$$$reportNull$$$0(21);
        }
        Ref result = new Ref();
        this.processTokens(chars, usageStartOffset, usageEndOffset, (tokenStart, tokenEnd, tokenAttributeKeys) -> {
            UsageType usageType = ChunkExtractor.deriveUsageTypeFromHighlighting(tokenAttributeKeys);
            if (usageType != null) {
                result.set((Object)usageType);
                return false;
            }
            return true;
        });
        return (UsageType)result.get();
    }

    @Nullable
    private static UsageType deriveUsageTypeFromHighlighting(@NotNull @NotNull TextAttributesKey @NotNull [] tokenAttributeKeys) {
        if (tokenAttributeKeys == null) {
            ChunkExtractor.$$$reportNull$$$0(22);
        }
        return ChunkExtractor.isHighlightedAsString(tokenAttributeKeys) ? UsageType.LITERAL_USAGE : (ChunkExtractor.isHighlightedAsComment(tokenAttributeKeys) ? UsageType.COMMENT_USAGE : null);
    }

    public static boolean isHighlightedAsComment(TextAttributesKey ... keys) {
        for (TextAttributesKey key : keys) {
            TextAttributesKey fallbackAttributeKey;
            if (key == DefaultLanguageHighlighterColors.DOC_COMMENT || key == DefaultLanguageHighlighterColors.LINE_COMMENT || key == DefaultLanguageHighlighterColors.BLOCK_COMMENT) {
                return true;
            }
            if (key == null || (fallbackAttributeKey = key.getFallbackAttributeKey()) == null || !ChunkExtractor.isHighlightedAsComment(fallbackAttributeKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHighlightedAsString(TextAttributesKey ... keys) {
        for (TextAttributesKey key : keys) {
            TextAttributesKey fallbackAttributeKey;
            if (key == DefaultLanguageHighlighterColors.STRING) {
                return true;
            }
            if (key == null || (fallbackAttributeKey = key.getFallbackAttributeKey()) == null || !ChunkExtractor.isHighlightedAsString(fallbackAttributeKey)) continue;
            return true;
        }
        return false;
    }

    private static void addChunk(@NotNull CharSequence chars, int start, int end, @NotNull TextAttributes originalAttrs, boolean bold, @NotNull List<? super TextChunk> result) {
        if (chars == null) {
            ChunkExtractor.$$$reportNull$$$0(23);
        }
        if (originalAttrs == null) {
            ChunkExtractor.$$$reportNull$$$0(24);
        }
        if (result == null) {
            ChunkExtractor.$$$reportNull$$$0(25);
        }
        if (start >= end) {
            return;
        }
        TextAttributes attrs = bold ? TextAttributes.merge(originalAttrs, new TextAttributes(null, null, null, null, 1)) : originalAttrs;
        result.add(new TextChunk(attrs, new String(CharArrayUtil.fromSequence((CharSequence)chars, (int)start, (int)end))));
    }

    private static boolean rangeIntersect(int s1, int e1, int s2, int e2) {
        return s2 < s1 && s1 < e2 || s2 < e1 && e1 < e2 || s1 < s2 && s2 < e1 || s1 < e2 && e2 < e1 || s1 == s2 && e1 == e2;
    }

    @NotNull
    private TextAttributes convertAttributes(TextAttributesKey @NotNull [] keys) {
        if (keys == null) {
            ChunkExtractor.$$$reportNull$$$0(26);
        }
        TextAttributes attrs = this.myColorsScheme.getAttributes(HighlighterColors.TEXT);
        for (TextAttributesKey key : keys) {
            TextAttributes attrs2 = this.myColorsScheme.getAttributes(key);
            if (attrs2 == null) continue;
            attrs = TextAttributes.merge(attrs, attrs2);
        }
        TextAttributes textAttributes = attrs = attrs.clone();
        if (textAttributes == null) {
            ChunkExtractor.$$$reportNull$$$0(27);
        }
        return textAttributes;
    }

    private static void appendPrefix(@NotNull List<? super TextChunk> result, int lineNumber) {
        if (result == null) {
            ChunkExtractor.$$$reportNull$$$0(28);
        }
        result.add(new TextChunk(UsageTreeColors.NUMBER_OF_USAGES_ATTRIBUTES.toTextAttributes(), String.valueOf(lineNumber + 1)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageAdapter";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/ChunkExtractor";
                break;
            }
            case 5: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo2UsageAdapter";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 13: 
            case 19: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenHighlightProcessor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenHighlights";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenAttributeKeys";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalAttrs";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/ChunkExtractor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractChunks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextChunks";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractChunks";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExtractor";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTextChunks";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processTokens";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processIntersectingRange";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deriveUsageTypeFromHighlighting";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addChunk";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "convertAttributes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface TokenHighlightProcessor {
        public boolean process(int var1, int var2, @NotNull @NotNull TextAttributesKey @NotNull [] var3);
    }

    private static final class WeakFactory {
        private WeakReference<Map<PsiFile, ChunkExtractor>> myRef;

        private WeakFactory() {
        }

        @NotNull
        public Map<PsiFile, ChunkExtractor> getValue() {
            Map cur = (Map)SoftReference.dereference(this.myRef);
            if (cur != null) {
                Map map = cur;
                if (map == null) {
                    WeakFactory.$$$reportNull$$$0(0);
                }
                return map;
            }
            Map result = FactoryMap.create(psiFile -> new ChunkExtractor((PsiFile)psiFile));
            this.myRef = new WeakReference<Map>(result);
            Map map = result;
            if (map == null) {
                WeakFactory.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/ChunkExtractor$WeakFactory", "getValue"));
        }
    }
}

