/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.application.options.RegistryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefOsrHandler;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JPanel;
import org.cef.browser.CefBrowser;
import org.jetbrains.annotations.NotNull;

class JBCefOsrComponent
extends JPanel {
    @NotNull
    private volatile JBCefOsrHandler myRenderHandler;
    @NotNull
    private volatile CefBrowser myBrowser;
    @NotNull
    private final MyScale myScale = new MyScale();
    @NotNull
    private Alarm myAlarm;
    @NotNull
    private Disposable myDisposable;

    JBCefOsrComponent() {
        this.setPreferredSize(JBCefBrowser.DEF_PREF_SIZE);
        this.setBackground(JBColor.background());
        this.addPropertyChangeListener("graphicsConfiguration", e -> this.myRenderHandler.updateScale(this.myScale.update(this.myRenderHandler.getDeviceScaleFactor(this.myBrowser))));
        this.enableEvents(131128L);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JBCefOsrComponent.this.myBrowser.setFocus(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                JBCefOsrComponent.this.myBrowser.setFocus(false);
            }
        });
    }

    public void setBrowser(@NotNull CefBrowser browser) {
        if (browser == null) {
            JBCefOsrComponent.$$$reportNull$$$0(0);
        }
        this.myBrowser = browser;
    }

    public void setRenderHandler(@NotNull JBCefOsrHandler renderHandler) {
        if (renderHandler == null) {
            JBCefOsrComponent.$$$reportNull$$$0(1);
        }
        this.myRenderHandler = renderHandler;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.myDisposable = Disposer.newDisposable();
        this.myAlarm = AlarmFactory.getInstance().create(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        if (!JBCefBrowserBase.isCefBrowserCreated(this.myBrowser)) {
            this.myBrowser.createImmediately();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myRenderHandler.paint((Graphics2D)g);
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        this.myAlarm.cancelAllRequests();
        double scale = this.myScale.getInverted();
        this.myAlarm.addRequest(() -> this.myBrowser.wasResized(PaintUtil.RoundingMode.CEIL.round((double)w * scale), PaintUtil.RoundingMode.CEIL.round((double)h * scale)), 100);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        double scale = this.myScale.getIdeBiased();
        this.myBrowser.sendMouseEvent(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), PaintUtil.RoundingMode.ROUND.round((double)e.getX() / scale), PaintUtil.RoundingMode.ROUND.round((double)e.getY() / scale), PaintUtil.RoundingMode.ROUND.round((double)e.getXOnScreen() / scale), PaintUtil.RoundingMode.ROUND.round((double)e.getYOnScreen() / scale), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        if (e.getID() == 501) {
            this.requestFocusInWindow();
        }
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        double val = e.getPreciseWheelRotation() * (double)RegistryManager.getInstance().intValue("ide.browser.jcef.osr.wheelRotation.factor");
        if (SystemInfoRt.isLinux || SystemInfoRt.isMac) {
            val *= -1.0;
        }
        double scale = this.myScale.getIdeBiased();
        this.myBrowser.sendMouseWheelEvent(new MouseWheelEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), PaintUtil.RoundingMode.ROUND.round((double)e.getX() / scale), PaintUtil.RoundingMode.ROUND.round((double)e.getY() / scale), PaintUtil.RoundingMode.ROUND.round((double)e.getXOnScreen() / scale), PaintUtil.RoundingMode.ROUND.round((double)e.getYOnScreen() / scale), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), (int)val, val));
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        double scale = this.myScale.getIdeBiased();
        this.myBrowser.sendMouseEvent(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), PaintUtil.RoundingMode.ROUND.round((double)e.getX() / scale), PaintUtil.RoundingMode.ROUND.round((double)e.getY() / scale), PaintUtil.RoundingMode.ROUND.round((double)e.getXOnScreen() / scale), PaintUtil.RoundingMode.ROUND.round((double)e.getYOnScreen() / scale), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        this.myBrowser.sendKeyEvent(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/jcef/JBCefOsrComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setRenderHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MyScale {
        private volatile double myScale = 1.0;
        private volatile double myInvertedScale = 1.0;

        MyScale() {
        }

        public MyScale update(double scale) {
            this.myScale = scale;
            if (!JreHiDpiUtil.isJreHiDPIEnabled()) {
                this.myInvertedScale = 1.0 / this.myScale;
            }
            return this;
        }

        public MyScale update(MyScale scale) {
            this.myScale = scale.myScale;
            this.myInvertedScale = scale.myInvertedScale;
            return this;
        }

        public double get() {
            return this.myScale;
        }

        public double getInverted() {
            return JreHiDpiUtil.isJreHiDPIEnabled() ? this.myScale : this.myInvertedScale;
        }

        public double getIdeBiased() {
            return JreHiDpiUtil.isJreHiDPIEnabled() ? 1.0 : this.myScale;
        }

        public double getJreBiased() {
            return JreHiDpiUtil.isJreHiDPIEnabled() ? this.myScale : 1.0;
        }
    }
}

