/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import sun.awt.AWTAccessor;

public class CellRendererPanel
extends JPanel {
    private boolean mySelected;

    public CellRendererPanel() {
        this(null);
    }

    public CellRendererPanel(LayoutManager lm) {
        super(lm);
        super.setOpaque(false);
        super.setFont(null);
    }

    public final boolean isSelected() {
        return this.mySelected;
    }

    public final void setSelected(boolean isSelected) {
        this.mySelected = isSelected;
    }

    public void setForcedBackground(Color bg) {
        super.setBackground(bg);
        if (bg != null && !this.mySelected) {
            this.setSelected(true);
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.mySelected) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            int count = this.getComponentCount();
            if (count == 1) {
                Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
                JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
                JComponent child = (JComponent)this.getComponent(0);
                CellRendererPanel.reshapeImpl(child, bounds.x, bounds.y, bounds.width, bounds.height);
                CellRendererPanel.invalidateLayout(child);
                child.validate();
            } else {
                CellRendererPanel.invalidateLayout(this);
                super.doLayout();
                for (int i2 = 0; i2 < count; ++i2) {
                    Component c = this.getComponent(i2);
                    c.validate();
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getComponentCount() != 1 || super.getBorder() != null) {
            return super.getPreferredSize();
        }
        return this.getComponent(0).getPreferredSize();
    }

    protected final Dimension super_getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    @Deprecated
    public final Dimension preferredSize() {
        LayoutManager layoutMgr = this.getLayout();
        return layoutMgr != null ? layoutMgr.preferredLayoutSize(this) : super.preferredSize();
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        CellRendererPanel.reshapeImpl(this, x, y, w, h);
    }

    static void reshapeImpl(JComponent component, int x, int y, int w, int h) {
        AWTAccessor.getComponentAccessor().setLocation(component, x, y);
        AWTAccessor.getComponentAccessor().setSize(component, w, h);
    }

    @Override
    public void invalidate() {
    }

    public void forceInvalidate() {
        super.invalidate();
    }

    private static void invalidateLayout(JComponent component) {
        LayoutManager layout = component.getLayout();
        if (layout instanceof LayoutManager2) {
            ((LayoutManager2)layout).invalidateLayout(component);
        }
    }

    @Override
    public void validate() {
        this.doLayout();
    }

    protected final void super_validate() {
        super.validate();
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }
}

