/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.remote.RemoteBundle;
import com.intellij.remote.RemoteCredentialException;
import java.net.NoRouteToHostException;

public class RemoteSdkException
extends ExecutionException {
    private final boolean myNoRouteToHost;
    private final boolean myAuthFailed;
    private Throwable myCause;

    public RemoteSdkException(@NlsContexts.DialogMessage String s, Throwable throwable) {
        super(s, throwable);
        this.myAuthFailed = false;
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!(t instanceof NoRouteToHostException)) continue;
            this.myCause = t;
            this.myNoRouteToHost = true;
            return;
        }
        this.myNoRouteToHost = false;
        this.myCause = throwable;
    }

    public RemoteSdkException(@NlsContexts.DialogMessage String s) {
        super(s);
        this.myAuthFailed = false;
        this.myNoRouteToHost = false;
    }

    public boolean isNoRouteToHost() {
        return this.myNoRouteToHost;
    }

    public boolean isAuthFailed() {
        return this.myAuthFailed;
    }

    public String getMessage() {
        if (this.myNoRouteToHost) {
            return this.myCause.getMessage();
        }
        if (this.myAuthFailed) {
            return RemoteBundle.message("authentication.failed", new Object[0]);
        }
        return super.getMessage();
    }

    public static RemoteSdkException cantObtainRemoteCredentials(Throwable e) {
        if (e.getCause() instanceof RemoteCredentialException) {
            return new RemoteSdkException(RemoteBundle.message("remote.sdk.exception.cant.obtain.remote.credentials", new Object[0]), e);
        }
        return new RemoteSdkException(e.getMessage(), e);
    }
}

