/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.util.containers.WeakList;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WeakFocusStackManager {
    private static final WeakFocusStackManager INSTANCE = new WeakFocusStackManager();
    private final WeakList<Component> focusOwners = new WeakList();

    @NotNull
    public static WeakFocusStackManager getInstance() {
        WeakFocusStackManager weakFocusStackManager = INSTANCE;
        if (weakFocusStackManager == null) {
            WeakFocusStackManager.$$$reportNull$$$0(0);
        }
        return weakFocusStackManager;
    }

    private WeakFocusStackManager() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 1004) {
                    WeakFocusStackManager.this.focusOwners.add((Object)((Component)event.getSource()));
                }
            }
        }, 4L);
    }

    @Nullable
    public Component getLastFocusedOutside(Container container) {
        List components = this.focusOwners.toStrongList();
        for (int i2 = components.size() - 1; i2 >= 0; --i2) {
            if (SwingUtilities.isDescendingFrom((Component)components.get(i2), container)) continue;
            return (Component)components.get(i2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/WeakFocusStackManager", "getInstance"));
    }
}

