/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.ui.UISettings;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ToolWindowAnchor {
    @NotNull
    public static final ToolWindowAnchor TOP = new ToolWindowAnchor("top", "action.text.anchor.top", "action.text.anchor.top.capitalized");
    @NotNull
    public static final ToolWindowAnchor LEFT = new ToolWindowAnchor("left", "action.text.anchor.left", "action.text.anchor.left.capitalized");
    @NotNull
    public static final ToolWindowAnchor BOTTOM = new ToolWindowAnchor("bottom", "action.text.anchor.bottom", "action.text.anchor.bottom.capitalized");
    @NotNull
    public static final ToolWindowAnchor RIGHT = new ToolWindowAnchor("right", "action.text.anchor.right", "action.text.anchor.right.capitalized");
    @NotNull
    public static final ToolWindowAnchor NONE = new ToolWindowAnchor("none", "action.text.anchor.none", "action.text.anchor.none.capitalized");
    @NotNull
    private final String myText;
    @NotNull
    private final String bundleKey;
    @NotNull
    private final String capitalizedBundleKey;

    private ToolWindowAnchor(@NotNull String text2, @NotNull String bundleKey, @NotNull String capitalizedBundleKey) {
        if (text2 == null) {
            ToolWindowAnchor.$$$reportNull$$$0(0);
        }
        if (bundleKey == null) {
            ToolWindowAnchor.$$$reportNull$$$0(1);
        }
        if (capitalizedBundleKey == null) {
            ToolWindowAnchor.$$$reportNull$$$0(2);
        }
        this.bundleKey = bundleKey;
        this.capitalizedBundleKey = capitalizedBundleKey;
        this.myText = text2;
    }

    @NotNull
    public String toString() {
        String string = this.myText;
        if (string == null) {
            ToolWindowAnchor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getDisplayName() {
        String string = IdeCoreBundle.message(this.bundleKey, new Object[0]);
        if (string == null) {
            ToolWindowAnchor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getCapitalizedDisplayName() {
        String string = IdeCoreBundle.message(this.capitalizedBundleKey, new Object[0]);
        if (string == null) {
            ToolWindowAnchor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isHorizontal() {
        return this == TOP || this == BOTTOM;
    }

    @NotNull
    public static ToolWindowAnchor get(int swingOrientationConstant) {
        switch (swingOrientationConstant) {
            case 1: {
                ToolWindowAnchor toolWindowAnchor = TOP;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(6);
                }
                return toolWindowAnchor;
            }
            case 3: {
                ToolWindowAnchor toolWindowAnchor = BOTTOM;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(7);
                }
                return toolWindowAnchor;
            }
            case 2: {
                ToolWindowAnchor toolWindowAnchor = LEFT;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(8);
                }
                return toolWindowAnchor;
            }
            case 4: {
                ToolWindowAnchor toolWindowAnchor = RIGHT;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(9);
                }
                return toolWindowAnchor;
            }
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + swingOrientationConstant);
    }

    public boolean isSplitVertically() {
        return this == LEFT && !UISettings.getInstance().getLeftHorizontalSplit() || this == RIGHT && !UISettings.getInstance().getRightHorizontalSplit();
    }

    @NotNull
    public static ToolWindowAnchor fromText(@NotNull String anchor) {
        if (anchor == null) {
            ToolWindowAnchor.$$$reportNull$$$0(10);
        }
        switch (anchor) {
            case "top": {
                ToolWindowAnchor toolWindowAnchor = TOP;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(11);
                }
                return toolWindowAnchor;
            }
            case "left": {
                ToolWindowAnchor toolWindowAnchor = LEFT;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(12);
                }
                return toolWindowAnchor;
            }
            case "bottom": {
                ToolWindowAnchor toolWindowAnchor = BOTTOM;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(13);
                }
                return toolWindowAnchor;
            }
            case "right": {
                ToolWindowAnchor toolWindowAnchor = RIGHT;
                if (toolWindowAnchor == null) {
                    ToolWindowAnchor.$$$reportNull$$$0(14);
                }
                return toolWindowAnchor;
            }
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capitalizedBundleKey";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/ToolWindowAnchor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/ToolWindowAnchor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapitalizedDisplayName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

